/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css2;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class SrcManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 38;
    }

    @Override
    public String getPropertyName() {
        return "src";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
            }
            case IDENT: 
            case STRING: 
            case URI: 
        }
        ListValue listValue = new ListValue();
        do {
            switch (lexicalUnit.getLexicalUnitType()) {
                case STRING: {
                    listValue.append(new StringValue(19, lexicalUnit.getStringValue()));
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    break;
                }
                case URI: {
                    String string = SrcManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue());
                    listValue.append(new URIValue(lexicalUnit.getStringValue(), string));
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.FUNCTION || !lexicalUnit.getFunctionName().equalsIgnoreCase("format")) break;
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    break;
                }
                case IDENT: {
                    StringBuilder stringBuilder = new StringBuilder(lexicalUnit.getStringValue());
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (lexicalUnit != null && lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                        do {
                            stringBuilder.append(' ');
                            stringBuilder.append(lexicalUnit.getStringValue());
                        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null && lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT);
                        listValue.append(new StringValue(19, stringBuilder.toString()));
                        break;
                    }
                    String string = stringBuilder.toString();
                    String string2 = string.toLowerCase().intern();
                    Value value = (Value)values.get(string2);
                    listValue.append(value != null ? value : new StringValue(19, string));
                    break;
                }
            }
            if (lexicalUnit == null) {
                return listValue;
            }
            if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    static {
        values.put("none", ValueConstants.NONE_VALUE);
    }
}

