/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class ColorProfileManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public String getPropertyName() {
        return "color-profile";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 20;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case IDENT: {
                String string = lexicalUnit.getStringValue().toLowerCase();
                if (string.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (string.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, string);
            }
            case URI: {
                return new URIValue(lexicalUnit.getStringValue(), ColorProfileManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue()));
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        switch (s) {
            case 21: {
                String string2 = string.toLowerCase();
                if (string2.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (string2.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, string2);
            }
            case 20: {
                return new URIValue(string, ColorProfileManager.resolveURI(cSSEngine.getCSSBaseURI(), string));
            }
        }
        throw this.createInvalidStringTypeDOMException(s);
    }
}

