/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class GlyphOrientationManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 5;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case DIMENSION: {
                switch (lexicalUnit.getCssUnit()) {
                    case 80: {
                        return new FloatValue(11, lexicalUnit.getFloatValue());
                    }
                    case 81: {
                        return new FloatValue(12, lexicalUnit.getFloatValue());
                    }
                    case 82: {
                        return new FloatValue(13, lexicalUnit.getFloatValue());
                    }
                    case 83: {
                        return new FloatValue(11, lexicalUnit.getFloatValue() * 360.0f);
                    }
                }
            }
            case INTEGER: {
                int n = lexicalUnit.getIntegerValue();
                return new FloatValue(11, n);
            }
            case REAL: {
                float f = lexicalUnit.getFloatValue();
                return new FloatValue(11, f);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        switch (s) {
            case 11: 
            case 12: 
            case 13: {
                return new FloatValue(s, f);
            }
        }
        throw this.createInvalidFloatValueDOMException(f);
    }
}

