/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import org.w3c.dom.DOMException;

public class ICCColor
extends AbstractValue {
    public static final String ICC_COLOR_FUNCTION = "icc-color";
    protected String colorProfile;
    protected int count;
    protected float[] colors = new float[5];

    public ICCColor(String string) {
        this.colorProfile = string;
    }

    @Override
    public short getCssValueType() {
        return 3;
    }

    public String getColorProfile() throws DOMException {
        return this.colorProfile;
    }

    public int getNumberOfColors() throws DOMException {
        return this.count;
    }

    public float getColor(int n) throws DOMException {
        return this.colors[n];
    }

    @Override
    public String getCssText() {
        StringBuilder stringBuilder = new StringBuilder(this.count * 8);
        stringBuilder.append(ICC_COLOR_FUNCTION).append('(');
        stringBuilder.append(this.colorProfile);
        for (int i = 0; i < this.count; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.colors[i]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public void append(float f) {
        if (this.count == this.colors.length) {
            float[] fArray = new float[this.count * 2];
            System.arraycopy(this.colors, 0, fArray, 0, this.count);
            this.colors = fArray;
        }
        this.colors[this.count++] = f;
    }

    public String toString() {
        return this.getCssText();
    }
}

