/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.ColorManager;
import io.sf.carte.echosvg.css.engine.value.svg.ICCColor;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg12.CIELCHColor;
import io.sf.carte.echosvg.css.engine.value.svg12.CIELabColor;
import io.sf.carte.echosvg.css.engine.value.svg12.DeviceColor;
import io.sf.carte.echosvg.css.engine.value.svg12.ICCNamedColor;
import org.w3c.dom.DOMException;

public class SVGColorManager
extends ColorManager {
    protected String property;
    protected Value defaultValue;

    public SVGColorManager(String string) {
        this(string, ValueConstants.BLACK_RGB_VALUE);
    }

    public SVGColorManager(String string, Value value) {
        this.property = string;
        this.defaultValue = value;
    }

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 6;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public Value getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && lexicalUnit.getStringValue().equalsIgnoreCase("currentcolor")) {
            return SVGValueConstants.CURRENTCOLOR_VALUE;
        }
        Value value = super.createValue(lexicalUnit, cSSEngine);
        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
            return value;
        }
        if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.FUNCTION) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        ListValue listValue = new ListValue(' ');
        listValue.append(value);
        Value value2 = this.parseColorFunction(lexicalUnit, value);
        if (value2 == null) {
            return value;
        }
        listValue.append(value2);
        return listValue;
    }

    private Value parseColorFunction(LexicalUnit lexicalUnit, Value value) {
        String string = lexicalUnit.getFunctionName();
        if (string.equalsIgnoreCase("icc-color")) {
            return this.createICCColorValue(lexicalUnit, value);
        }
        return this.parseColor12Function(lexicalUnit, value);
    }

    private Value parseColor12Function(LexicalUnit lexicalUnit, Value value) {
        String string = lexicalUnit.getFunctionName();
        if (string.equalsIgnoreCase("icc-named-color")) {
            return this.createICCNamedColorValue(lexicalUnit, value);
        }
        if (string.equalsIgnoreCase("cielab")) {
            return this.createCIELabColorValue(lexicalUnit, value);
        }
        if (string.equalsIgnoreCase("cielch")) {
            return this.createCIELCHColorValue(lexicalUnit, value);
        }
        if (string.equalsIgnoreCase("device-cmyk")) {
            return this.createDeviceColorValue(lexicalUnit, value, 4);
        }
        if (string.equalsIgnoreCase("device-rgb")) {
            return this.createDeviceColorValue(lexicalUnit, value, 3);
        }
        if (string.equalsIgnoreCase("device-gray")) {
            return this.createDeviceColorValue(lexicalUnit, value, 1);
        }
        if (string.equalsIgnoreCase("device-nchannel")) {
            return this.createDeviceColorValue(lexicalUnit, value, 0);
        }
        return null;
    }

    private Value createICCColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        this.expectIdent(lexicalUnit);
        ICCColor iCCColor = new ICCColor(lexicalUnit.getStringValue());
        for (lexicalUnit = lexicalUnit.getNextLexicalUnit(); lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
            this.expectComma(lexicalUnit);
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            iCCColor.append(this.getColorValue(lexicalUnit));
        }
        return iCCColor;
    }

    private Value createICCNamedColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        this.expectIdent(lexicalUnit);
        String string = lexicalUnit.getStringValue();
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectIdent(lexicalUnit);
        String string2 = lexicalUnit.getStringValue();
        ICCNamedColor iCCNamedColor = new ICCNamedColor(string, string2);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        return iCCNamedColor;
    }

    private Value createCIELabColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        float f = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f2 = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f3 = this.getColorValue(lexicalUnit);
        CIELabColor cIELabColor = new CIELabColor(f, f2, f3);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        return cIELabColor;
    }

    private Value createCIELCHColorValue(LexicalUnit lexicalUnit, Value value) {
        lexicalUnit = lexicalUnit.getParameters();
        float f = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f2 = this.getColorValue(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        this.expectComma(lexicalUnit);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        float f3 = this.getColorValue(lexicalUnit);
        CIELCHColor cIELCHColor = new CIELCHColor(f, f2, f3);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        return cIELCHColor;
    }

    private Value createDeviceColorValue(LexicalUnit lexicalUnit, Value value, int n) {
        lexicalUnit = lexicalUnit.getParameters();
        boolean bl = n <= 0;
        DeviceColor deviceColor = new DeviceColor(bl);
        deviceColor.append(this.getColorValue(lexicalUnit));
        LexicalUnit lexicalUnit2 = lexicalUnit;
        for (lexicalUnit = lexicalUnit.getNextLexicalUnit(); lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
            this.expectComma(lexicalUnit);
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            deviceColor.append(this.getColorValue(lexicalUnit));
            lexicalUnit2 = lexicalUnit;
        }
        if (!bl && n != deviceColor.getNumberOfColors()) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit2.getLexicalUnitType());
        }
        return deviceColor;
    }

    private void expectIdent(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
    }

    private void expectComma(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
    }

    private void expectNonNull(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            throw this.createInvalidLexicalUnitDOMException(LexicalUnit.LexicalType.UNKNOWN);
        }
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value == SVGValueConstants.CURRENTCOLOR_VALUE) {
            styleMap.putColorRelative(n, true);
            int n2 = cSSEngine.getColorIndex();
            return cSSEngine.getComputedStyle(cSSStylableElement, string, n2);
        }
        if (value.getCssValueType() == 2) {
            ListValue listValue = (ListValue)value;
            Value value2 = listValue.item(0);
            Value value3 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value2);
            if (value3 != value2) {
                ListValue listValue2 = new ListValue(' ');
                listValue2.append(value3);
                listValue2.append(listValue.item(1));
                return listValue2;
            }
            return value;
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    protected float getColorValue(LexicalUnit lexicalUnit) {
        this.expectNonNull(lexicalUnit);
        switch (lexicalUnit.getLexicalUnitType()) {
            case INTEGER: {
                return lexicalUnit.getIntegerValue();
            }
            case REAL: {
                return lexicalUnit.getFloatValue();
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }
}

