/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.renderer;

import io.sf.carte.echosvg.ext.awt.geom.RectListManager;
import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.renderer.ImageRenderer;
import io.sf.carte.echosvg.util.HaltingThread;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;

public class MacRenderer
implements ImageRenderer {
    static final int COPY_OVERHEAD = 1000;
    static final int COPY_LINE_OVERHEAD = 10;
    static final AffineTransform IDENTITY = new AffineTransform();
    protected RenderingHints renderingHints = new RenderingHints(null);
    protected AffineTransform usr2dev;
    protected GraphicsNode rootGN;
    protected int offScreenWidth;
    protected int offScreenHeight;
    protected boolean isDoubleBuffered;
    protected BufferedImage currImg;
    protected BufferedImage workImg;
    protected RectListManager damagedAreas;
    public static int IMAGE_TYPE = 3;
    public static Color TRANSPARENT_WHITE = new Color(255, 255, 255, 0);
    protected static RenderingHints defaultRenderingHints = new RenderingHints(null);

    public MacRenderer() {
        this.renderingHints.add(defaultRenderingHints);
        this.usr2dev = new AffineTransform();
    }

    public MacRenderer(RenderingHints renderingHints, AffineTransform affineTransform) {
        this.renderingHints.add(renderingHints);
        this.usr2dev = affineTransform == null ? new AffineTransform() : new AffineTransform(affineTransform);
    }

    @Override
    public void dispose() {
        this.rootGN = null;
        this.currImg = null;
        this.workImg = null;
        this.renderingHints = null;
        this.usr2dev = null;
        if (this.damagedAreas != null) {
            this.damagedAreas.clear();
        }
        this.damagedAreas = null;
    }

    @Override
    public void setTree(GraphicsNode graphicsNode) {
        this.rootGN = graphicsNode;
    }

    @Override
    public GraphicsNode getTree() {
        return this.rootGN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.usr2dev = affineTransform == null ? new AffineTransform() : new AffineTransform(affineTransform);
        if (this.workImg == null) {
            return;
        }
        BufferedImage bufferedImage = this.workImg;
        synchronized (bufferedImage) {
            Graphics2D graphics2D = this.workImg.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, this.workImg.getWidth(), this.workImg.getHeight());
            graphics2D.dispose();
        }
        this.damagedAreas = null;
    }

    @Override
    public AffineTransform getTransform() {
        return this.usr2dev;
    }

    @Override
    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.add(renderingHints);
        this.damagedAreas = null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.isDoubleBuffered;
    }

    @Override
    public void setDoubleBuffered(boolean bl) {
        if (this.isDoubleBuffered == bl) {
            return;
        }
        this.isDoubleBuffered = bl;
        if (bl) {
            this.workImg = null;
        } else {
            this.workImg = this.currImg;
            this.damagedAreas = null;
        }
    }

    @Override
    public void updateOffScreen(int n, int n2) {
        this.offScreenWidth = n;
        this.offScreenHeight = n2;
    }

    @Override
    public BufferedImage getOffScreen() {
        if (this.rootGN == null) {
            return null;
        }
        return this.currImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOffScreen() {
        if (this.isDoubleBuffered) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.workImg == null) {
            return;
        }
        BufferedImage bufferedImage = this.workImg;
        synchronized (bufferedImage) {
            Graphics2D graphics2D = this.workImg.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, this.workImg.getWidth(), this.workImg.getHeight());
            graphics2D.dispose();
        }
        this.damagedAreas = null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void flush(Rectangle rectangle) {
    }

    @Override
    public void flush(Collection<Shape> collection) {
    }

    protected void updateWorkingBuffers() {
        if (this.rootGN == null) {
            this.currImg = null;
            this.workImg = null;
            return;
        }
        int n = this.offScreenWidth;
        int n2 = this.offScreenHeight;
        if (this.workImg == null || this.workImg.getWidth() < n || this.workImg.getHeight() < n2) {
            this.workImg = new BufferedImage(n, n2, IMAGE_TYPE);
        }
        if (!this.isDoubleBuffered) {
            this.currImg = this.workImg;
        }
    }

    @Override
    public void repaint(Shape shape) {
        if (shape == null) {
            return;
        }
        RectListManager rectListManager = new RectListManager();
        rectListManager.add(this.usr2dev.createTransformedShape(shape).getBounds());
        this.repaint(rectListManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint(RectListManager rectListManager) {
        BufferedImage bufferedImage;
        if (rectListManager == null) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.rootGN == null || this.workImg == null) {
            return;
        }
        try {
            bufferedImage = this.workImg;
            synchronized (bufferedImage) {
                Graphics2D graphics2D = GraphicsUtil.createGraphics((BufferedImage)this.workImg, (RenderingHints)this.renderingHints);
                Rectangle rectangle = new Rectangle(0, 0, this.offScreenWidth, this.offScreenHeight);
                if (this.isDoubleBuffered && this.currImg != null && this.damagedAreas != null) {
                    this.damagedAreas.subtract(rectListManager, 1000, 10);
                    this.damagedAreas.mergeRects(1000, 10);
                    Iterator iterator = this.damagedAreas.iterator();
                    graphics2D.setComposite(AlphaComposite.Src);
                    while (iterator.hasNext()) {
                        Rectangle rectangle2 = (Rectangle)iterator.next();
                        if (!rectangle.intersects(rectangle2)) continue;
                        rectangle2 = rectangle.intersection(rectangle2);
                        graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics2D.setComposite(AlphaComposite.Clear);
                        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics2D.setComposite(AlphaComposite.SrcOver);
                        graphics2D.drawImage((Image)this.currImg, 0, 0, null);
                    }
                }
                for (Rectangle rectangle2 : rectListManager) {
                    if (!rectangle.intersects(rectangle2)) continue;
                    rectangle2 = rectangle.intersection(rectangle2);
                    graphics2D.setTransform(IDENTITY);
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics2D.setComposite(AlphaComposite.Clear);
                    graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics2D.setComposite(AlphaComposite.SrcOver);
                    graphics2D.transform(this.usr2dev);
                    this.rootGN.paint(graphics2D);
                }
                graphics2D.dispose();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (HaltingThread.hasBeenHalted()) {
            return;
        }
        if (this.isDoubleBuffered) {
            bufferedImage = this.workImg;
            this.workImg = this.currImg;
            this.currImg = bufferedImage;
            this.damagedAreas = rectListManager;
        }
    }

    static {
        defaultRenderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        defaultRenderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }
}

