/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.svg;

import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.dom.svg.SVGNumberItem;
import io.sf.carte.echosvg.parser.NumberListHandler;
import io.sf.carte.echosvg.parser.NumberListParser;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public abstract class AbstractSVGNumberList
extends AbstractSVGList
implements SVGNumberList {
    public static final String SVG_NUMBER_LIST_SEPARATOR = " ";

    @Override
    protected String getItemSeparator() {
        return SVG_NUMBER_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGNumberList() {
    }

    public SVGNumber initialize(SVGNumber sVGNumber) throws DOMException, SVGException {
        return (SVGNumber)this.initializeImpl(sVGNumber);
    }

    public SVGNumber getItem(int n) throws DOMException {
        return (SVGNumber)this.getItemImpl(n);
    }

    public SVGNumber insertItemBefore(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
        return (SVGNumber)this.insertItemBeforeImpl(sVGNumber, n);
    }

    public SVGNumber replaceItem(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
        return (SVGNumber)this.replaceItemImpl(sVGNumber, n);
    }

    public SVGNumber removeItem(int n) throws DOMException {
        return (SVGNumber)this.removeItemImpl(n);
    }

    public SVGNumber appendItem(SVGNumber sVGNumber) throws DOMException, SVGException {
        return (SVGNumber)this.appendItemImpl(sVGNumber);
    }

    @Override
    protected SVGItem createSVGItem(Object object) {
        SVGNumber sVGNumber = (SVGNumber)object;
        return new SVGNumberItem(sVGNumber.getValue());
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        NumberListParser numberListParser = new NumberListParser();
        NumberListBuilder numberListBuilder = new NumberListBuilder(listHandler);
        numberListParser.setNumberListHandler((NumberListHandler)numberListBuilder);
        numberListParser.parse(string);
    }

    @Override
    protected void checkItemType(Object object) throws SVGException {
        if (!(object instanceof SVGNumber)) {
            this.createSVGException((short)0, "expected SVGNumber", null);
        }
    }

    protected static class NumberListBuilder
    implements NumberListHandler {
        protected ListHandler listHandler;
        protected float currentValue;

        public NumberListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startNumberList() throws ParseException {
            this.listHandler.startList();
        }

        public void startNumber() throws ParseException {
            this.currentValue = 0.0f;
        }

        public void numberValue(float f) throws ParseException {
            this.currentValue = f;
        }

        public void endNumber() throws ParseException {
            this.listHandler.item(new SVGNumberItem(this.currentValue));
        }

        public void endNumberList() throws ParseException {
            this.listHandler.endList();
        }
    }
}

