/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.awt;

import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.lang.constant.Constable;
import java.util.HashMap;
import org.w3c.dom.DOMException;

public class AWTHelper {
    public static Font createFont(CSSComputedProperties cSSComputedProperties) {
        String string;
        String string2 = cSSComputedProperties.getUsedFontFamily();
        float f = cSSComputedProperties.getComputedFontSize();
        String string3 = cSSComputedProperties.getPropertyValue("font-style");
        int n = 0;
        if (string3.length() > 0 && (string3 = string3.toLowerCase()).equals("italic")) {
            n = 2;
        }
        if ((string = cSSComputedProperties.getFontWeight()) != null && (string = string.toLowerCase()).equals("bold")) {
            n = n != 2 ? 1 : 0;
        }
        HashMap<TextAttribute, Constable> hashMap = new HashMap<TextAttribute, Constable>();
        String string4 = cSSComputedProperties.getPropertyValue("text-decoration");
        if (string4.length() > 0) {
            if ((string4 = string4.toLowerCase()).equals("underline")) {
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else if (string4.equals("line-through")) {
                hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
        }
        Font font = new Font(string2, n, Math.round(f));
        return font.deriveFont(hashMap);
    }

    public static Color getAWTColor(CSSTypedValue cSSTypedValue) throws CSSPropertyValueException {
        Color color = null;
        if (cSSTypedValue != null) {
            switch (cSSTypedValue.getPrimitiveType()) {
                case COLOR: 
                case IDENT: {
                    double[] dArray;
                    RGBAColor rGBAColor;
                    try {
                        rGBAColor = cSSTypedValue.toRGBColor();
                    }
                    catch (RuntimeException runtimeException) {
                        CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Cannot obtain a RGB color.", (Throwable)runtimeException);
                        cSSPropertyValueException.setValueText(cSSTypedValue.getCssText());
                        throw cSSPropertyValueException;
                    }
                    try {
                        dArray = rGBAColor.toNumberArray();
                    }
                    catch (RuntimeException runtimeException) {
                        CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Cannot obtain the color components.", (Throwable)runtimeException);
                        cSSPropertyValueException.setValueText(cSSTypedValue.getCssText());
                        throw cSSPropertyValueException;
                    }
                    CSSPrimitiveValue cSSPrimitiveValue = rGBAColor.getAlpha();
                    if (cSSPrimitiveValue.getCssValueType() != CSSValue.CssType.TYPED) {
                        CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Unsupported alpha channel.");
                        cSSPropertyValueException.setValueText(cSSTypedValue.getCssText());
                        throw cSSPropertyValueException;
                    }
                    float f = AWTHelper.normalizedAlphaComponent((CSSTypedValue)cSSPrimitiveValue);
                    try {
                        color = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2], f);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Unknown color.", (Throwable)illegalArgumentException);
                        cSSPropertyValueException.setValueText(cSSTypedValue.getCssText());
                        throw cSSPropertyValueException;
                    }
                }
                case NUMERIC: {
                    if (cSSTypedValue.getUnitType() == 0) {
                        return new Color((int)cSSTypedValue.getFloatValue((short)0));
                    }
                }
                default: {
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Unknown color");
                    cSSPropertyValueException.setValueText(cSSTypedValue.getCssText());
                    throw cSSPropertyValueException;
                }
            }
        }
        return color;
    }

    private static float normalizedAlphaComponent(CSSTypedValue cSSTypedValue) {
        float f;
        short s = cSSTypedValue.getUnitType();
        if (s == 2) {
            f = cSSTypedValue.getFloatValue((short)2) * 0.01f;
        } else if (s == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
        } else if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            f = 0.0f;
        } else {
            throw new DOMException(17, "Wrong component: " + cSSTypedValue.getCssText());
        }
        return Math.max(Math.min(1.0f, f), 0.0f);
    }
}

