/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent;

import io.sf.carte.doc.agent.AuthenticationCredentials;
import io.sf.carte.doc.agent.Cookie;
import io.sf.carte.doc.agent.CookieConfig;
import io.sf.carte.doc.agent.DefaultCookie;
import io.sf.carte.doc.agent.LogUserAgentErrorHandler;
import io.sf.carte.doc.agent.OriginPolicy;
import io.sf.carte.doc.agent.UserAgent;
import io.sf.carte.doc.agent.UserAgentErrorHandler;
import io.sf.carte.doc.style.css.nsac.Parser;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractUserAgent
implements UserAgent,
UserAgent.AgentControl,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String HEADER_COOKIE = "Cookie";
    private static final String HEADER_SET_COOKIE = "Set-Cookie";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AGENT = "User-agent";
    private OriginPolicy originPolicy = null;
    private final EnumSet<Parser.Flag> parserFlags = EnumSet.noneOf(Parser.Flag.class);
    private final UserAgentErrorHandler errorHandler = new LogUserAgentErrorHandler();
    private final Map<String, Set<Cookie>> cookieMap = new HashMap<String, Set<Cookie>>();
    private final SimpleDateFormat cookieDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.ROOT);
    private final CookieConfig globalConfig = new GlobalCookieConfig();
    private final Map<String, Set<AuthenticationCredentials>> credentialMap = new HashMap<String, Set<AuthenticationCredentials>>();
    private String userAgentId = System.getProperty("http.agent", "Mozilla/4.0 (compatible; CSS4J)");
    private int timeout = 15000;

    protected AbstractUserAgent(EnumSet<Parser.Flag> enumSet) {
        this.parserFlags.addAll(enumSet);
    }

    protected OriginPolicy getOriginPolicy() {
        return this.originPolicy;
    }

    public void setOriginPolicy(OriginPolicy originPolicy) {
        this.originPolicy = originPolicy;
    }

    @Override
    public UserAgent.AgentControl getAgentControl() {
        return this;
    }

    @Override
    public CookieConfig getCookieConfig() {
        return this.globalConfig;
    }

    public Set<Cookie> getCookies(String string) {
        return this.cookieMap.get(string);
    }

    protected EnumSet<Parser.Flag> getParserFlags() {
        return this.parserFlags;
    }

    @Override
    public String getProperty(String string) {
        if (string.equals("parser.starhack")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.STARHACK));
        }
        if (string.equals("parser.ievalues")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.IEVALUES));
        }
        if (string.equals("parser.ieprio")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.IEPRIO));
        }
        if (string.equals("parser.iepriochar")) {
            return Boolean.toString(this.parserFlags.contains((Object)Parser.Flag.IEPRIOCHAR));
        }
        return null;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals("parser.starhack")) {
            if ("true".equalsIgnoreCase(string2)) {
                this.parserFlags.add(Parser.Flag.STARHACK);
            } else {
                this.parserFlags.remove((Object)Parser.Flag.STARHACK);
            }
        } else if (string.equals("parser.ievalues")) {
            if ("true".equalsIgnoreCase(string2)) {
                this.parserFlags.add(Parser.Flag.IEVALUES);
            } else {
                this.parserFlags.remove((Object)Parser.Flag.IEVALUES);
            }
        }
    }

    @Override
    public AuthenticationCredentials getAuthenticationCredentials(URL uRL, String string) {
        Set<AuthenticationCredentials> set = this.credentialMap.get(uRL.getHost());
        if (set != null) {
            for (AuthenticationCredentials authenticationCredentials : set) {
                String string2 = authenticationCredentials.getRealm();
                if (string != null && !string.equals(string2)) continue;
                return authenticationCredentials;
            }
        }
        return null;
    }

    @Override
    public AuthenticationCredentials authenticationCredentials(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Attempt to create a null realm.");
        }
        Set<AuthenticationCredentials> set = this.credentialMap.get(string);
        if (set == null) {
            set = new HashSet<AuthenticationCredentials>();
        } else {
            for (AuthenticationCredentials authenticationCredentials : set) {
                if (!string2.equals(authenticationCredentials.getRealm())) continue;
                return authenticationCredentials;
            }
        }
        MyAuthenticationCredentials myAuthenticationCredentials = new MyAuthenticationCredentials(string2);
        set.add(myAuthenticationCredentials);
        return myAuthenticationCredentials;
    }

    @Override
    public void setConnectionTimeout(int n) {
        this.timeout = n;
    }

    @Override
    public boolean isVisitedURL(URL uRL) {
        return false;
    }

    public void setUseragentId(String string) {
        this.userAgentId = string;
    }

    protected URLConnection openConnection(URL uRL, long l) throws IOException {
        URLConnection uRLConnection = this.createConnection(uRL);
        uRLConnection.setConnectTimeout(this.timeout);
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            this.setCookies(httpURLConnection, uRL, l);
            this.setCredentials(httpURLConnection, uRL, null, l);
            if (this.userAgentId != null) {
                httpURLConnection.setRequestProperty(HEADER_AGENT, this.userAgentId);
            }
        }
        uRLConnection.setAllowUserInteraction(false);
        return uRLConnection;
    }

    protected URLConnection createConnection(URL uRL) throws IOException {
        return uRL.openConnection();
    }

    private void setCredentials(HttpURLConnection httpURLConnection, URL uRL, String string, long l) {
        AuthenticationCredentials authenticationCredentials = this.getAuthenticationCredentials(uRL, string);
        if (authenticationCredentials != null && authenticationCredentials.getAuthType() == 1) {
            httpURLConnection.setRequestProperty(HEADER_AUTHORIZATION, AbstractUserAgent.basicToken(authenticationCredentials));
        }
    }

    private static String basicToken(AuthenticationCredentials authenticationCredentials) {
        String string;
        int n;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Basic ").append(authenticationCredentials.getLoginPrincipal().getName()).append(':');
        if (authenticationCredentials.getPassword() != null) {
            stringBuilder.append(authenticationCredentials.getPassword());
        }
        if ((n = (string = Base64.getEncoder().encodeToString(stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1))).indexOf(61)) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private void setCookies(HttpURLConnection httpURLConnection, URL uRL, long l) {
        Object object;
        HashSet<Cookie> hashSet = new HashSet<Cookie>(8);
        String string = uRL.getHost().toLowerCase(Locale.ROOT);
        Set<Cookie> set = this.cookieMap.get(string);
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                Cookie cookie = object.next();
                if (!AbstractUserAgent.match(cookie, uRL, string, l)) continue;
                hashSet.add(cookie);
            }
            AbstractUserAgent.setCookies(httpURLConnection, hashSet);
        }
        if (this.originPolicy != null && (object = this.originPolicy.domainFromHostname(string)) != string && (set = this.cookieMap.get(string)) != null) {
            for (Cookie cookie : set) {
                if (!AbstractUserAgent.match(cookie, uRL, string, l)) continue;
                hashSet.add(cookie);
            }
            AbstractUserAgent.setCookies(httpURLConnection, hashSet);
        }
    }

    protected void readCookies(HttpURLConnection httpURLConnection, long l) {
        if ((this.globalConfig.acceptsAllCookies() || this.globalConfig.acceptsSessionCookies()) && this.originPolicy != null) {
            String string = httpURLConnection.getHeaderField(HEADER_SET_COOKIE);
            if (string == null) {
                return;
            }
            URL uRL = httpURLConnection.getURL();
            String string2 = uRL.getHost();
            int n = uRL.getPort();
            if (n == -1) {
                n = uRL.getDefaultPort();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                Cookie cookie = this.parseCookie(stringTokenizer.nextToken().trim(), string2, n, l);
                if (cookie == null) continue;
                if (this.originPolicy.isTopLevelSuffix(cookie.getDomain())) {
                    this.errorHandler.onSuperCookie(uRL, cookie.getDomain());
                    continue;
                }
                Set<Cookie> set = this.cookieMap.get(cookie.getDomain());
                if (set == null) {
                    set = new HashSet<Cookie>(8);
                    this.cookieMap.put(cookie.getDomain(), set);
                }
                set.add(cookie);
            }
        }
    }

    Cookie parseCookie(String string, String string2, int n, long l) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string3 = stringTokenizer.nextToken().trim();
        int n2 = string3.indexOf(61);
        if (n2 == -1) {
            return null;
        }
        String string4 = string3.substring(0, n2).trim();
        string3 = string3.substring(n2 + 1).trim();
        DefaultCookie defaultCookie = new DefaultCookie(n, string4, string3);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            n2 = string3.indexOf(61);
            if (n2 == -1) {
                if ("Secure".equalsIgnoreCase(string3)) {
                    defaultCookie.setSecure();
                    continue;
                }
                if (!"HttpOnly".equalsIgnoreCase(string3)) continue;
                defaultCookie.setHttpOnly();
                continue;
            }
            string4 = string3.substring(0, n2).trim();
            string3 = string3.substring(n2 + 1).trim();
            if ("path".equalsIgnoreCase(string4)) {
                defaultCookie.setPath(string3);
                continue;
            }
            if ("max-age".equalsIgnoreCase(string4)) {
                defaultCookie.setExpiryTime(Long.parseLong(string3) + l);
                continue;
            }
            if ("Expires".equalsIgnoreCase(string4)) {
                try {
                    defaultCookie.setExpiryTime(this.cookieDateFormat.parse(string3).getTime());
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (!"domain".equalsIgnoreCase(string4)) continue;
            defaultCookie.setDomain(string3.toLowerCase(Locale.ROOT));
        }
        if (!this.globalConfig.acceptsAllCookies() && defaultCookie.isPersistent()) {
            return null;
        }
        if (defaultCookie.getDomain() == null) {
            defaultCookie.setDomain(string2);
        } else if (!string2.endsWith(defaultCookie.getDomain())) {
            return null;
        }
        return defaultCookie;
    }

    static void setCookies(HttpURLConnection httpURLConnection, Set<Cookie> set) {
        Iterator<Cookie> iterator = set.iterator();
        StringBuilder stringBuilder = new StringBuilder(256);
        if (iterator.hasNext()) {
            AbstractUserAgent.formatCookie(stringBuilder, iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(',');
            AbstractUserAgent.formatCookie(stringBuilder, iterator.next());
        }
        httpURLConnection.setRequestProperty(HEADER_COOKIE, stringBuilder.toString());
    }

    private static void formatCookie(StringBuilder stringBuilder, Cookie cookie) {
        stringBuilder.append(cookie.getName()).append('=').append(cookie.getValue());
        String string = cookie.getPath();
        if (string != null) {
            stringBuilder.append(';').append("Path=").append(string);
        }
    }

    static boolean match(Cookie cookie, URL uRL, String string, long l) {
        return !(!string.endsWith(cookie.getDomain()) || !AbstractUserAgent.matchPath(uRL.getPath(), cookie.getPath()) || cookie.isSecure() && !"https".equals(uRL.getProtocol()) || !AbstractUserAgent.matchPort(uRL, cookie.getPorts()) || cookie.isPersistent() && l >= cookie.getExpiryTime());
    }

    static boolean matchPath(String string, String string2) {
        if (string == string2) {
            return true;
        }
        return string != null && string.startsWith(string2);
    }

    private static boolean matchPort(URL uRL, int[] nArray) {
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        if (nArray[0] == n) {
            return true;
        }
        int n2 = nArray.length;
        for (int i = 1; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    static class GlobalCookieConfig
    implements CookieConfig {
        private boolean acceptAllCookies = false;
        private boolean acceptSessionCookies = false;

        GlobalCookieConfig() {
        }

        @Override
        public boolean acceptsAllCookies() {
            return this.acceptAllCookies;
        }

        @Override
        public void setAcceptAllCookies(boolean bl) {
            if (bl) {
                this.acceptSessionCookies = true;
            }
            this.acceptAllCookies = bl;
        }

        @Override
        public boolean acceptsSessionCookies() {
            return this.acceptSessionCookies;
        }

        @Override
        public void setAcceptSessionCookies(boolean bl) {
            if (!bl) {
                this.acceptAllCookies = false;
            }
            this.acceptSessionCookies = bl;
        }
    }

    static class MyAuthenticationCredentials
    implements AuthenticationCredentials {
        private Principal loginPrincipal = null;
        private String password = null;
        private final String realm;
        private byte authtype = 1;

        MyAuthenticationCredentials(String string) {
            this.realm = string;
        }

        @Override
        public Principal getLoginPrincipal() {
            return this.loginPrincipal;
        }

        @Override
        public void setLoginPrincipal(Principal principal) {
            this.loginPrincipal = principal;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public void setPassword(String string) {
            this.password = string;
        }

        @Override
        public String getRealm() {
            return this.realm;
        }

        @Override
        public void setAuthType(byte by) {
            this.authtype = by;
        }

        @Override
        public byte getAuthType() {
            return this.authtype;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + this.authtype;
            n2 = 31 * n2 + (this.loginPrincipal == null ? 0 : this.loginPrincipal.hashCode());
            n2 = 31 * n2 + (this.password == null ? 0 : this.password.hashCode());
            n2 = 31 * n2 + (this.realm == null ? 0 : this.realm.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MyAuthenticationCredentials myAuthenticationCredentials = (MyAuthenticationCredentials)object;
            if (this.authtype != myAuthenticationCredentials.authtype) {
                return false;
            }
            if (this.loginPrincipal == null ? myAuthenticationCredentials.loginPrincipal != null : !this.loginPrincipal.equals(myAuthenticationCredentials.loginPrincipal)) {
                return false;
            }
            if (this.password == null ? myAuthenticationCredentials.password != null : !this.password.equals(myAuthenticationCredentials.password)) {
                return false;
            }
            if (this.realm == null) {
                return myAuthenticationCredentials.realm == null;
            }
            return this.realm.equals(myAuthenticationCredentials.realm);
        }

        public String toString() {
            return "[loginPrincipal=" + this.loginPrincipal + ", password=" + this.password + ", realm=" + this.realm + "]";
        }
    }
}

