/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DummyNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class LinkedNodeList
implements AbstractDOMNode.RawNodeList,
Serializable {
    private static final long serialVersionUID = 1L;
    private AbstractDOMNode firstNode = null;
    private AbstractDOMNode lastNode = null;

    LinkedNodeList() {
    }

    @Override
    public void add(AbstractDOMNode abstractDOMNode) throws DOMException {
        if (this.lastNode != null) {
            this.lastNode.nextSibling = abstractDOMNode;
            abstractDOMNode.previousSibling = this.lastNode;
        } else {
            this.firstNode = abstractDOMNode;
        }
        this.lastNode = abstractDOMNode;
    }

    @Override
    public void clear() {
        AbstractDOMNode abstractDOMNode = this.firstNode;
        while (abstractDOMNode != null) {
            AbstractDOMNode abstractDOMNode2 = abstractDOMNode.nextSibling;
            abstractDOMNode.nextSibling = null;
            abstractDOMNode.previousSibling = null;
            abstractDOMNode.setParentNode(null);
            abstractDOMNode = abstractDOMNode2;
        }
        this.firstNode = null;
        this.lastNode = null;
    }

    @Override
    public boolean contains(Node node) {
        AbstractDOMNode abstractDOMNode = this.firstNode;
        while (abstractDOMNode != null) {
            if (abstractDOMNode == node) {
                return true;
            }
            abstractDOMNode = abstractDOMNode.nextSibling;
        }
        return false;
    }

    @Override
    public void insertBefore(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        AbstractDOMNode abstractDOMNode3 = abstractDOMNode2.previousSibling;
        abstractDOMNode.nextSibling = abstractDOMNode2;
        abstractDOMNode.previousSibling = abstractDOMNode3;
        if (abstractDOMNode3 != null) {
            abstractDOMNode3.nextSibling = abstractDOMNode;
        } else {
            this.firstNode = abstractDOMNode;
        }
        abstractDOMNode2.previousSibling = abstractDOMNode;
    }

    @Override
    public DOMNode item(int n) {
        int n2 = 0;
        AbstractDOMNode abstractDOMNode = this.firstNode;
        while (abstractDOMNode != null) {
            if (n2 == n) {
                return abstractDOMNode;
            }
            ++n2;
            abstractDOMNode = abstractDOMNode.nextSibling;
        }
        return null;
    }

    @Override
    public AbstractDOMNode getFirst() {
        return this.firstNode;
    }

    @Override
    public AbstractDOMNode getLast() {
        return this.lastNode;
    }

    @Override
    public int indexOf(Node node) {
        int n = 0;
        AbstractDOMNode abstractDOMNode = this.firstNode;
        while (abstractDOMNode != null) {
            if (abstractDOMNode == node) {
                return n;
            }
            ++n;
            abstractDOMNode = abstractDOMNode.nextSibling;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.firstNode == null;
    }

    @Override
    public int getLength() {
        int n = 0;
        AbstractDOMNode abstractDOMNode = this.firstNode;
        while (abstractDOMNode != null) {
            ++n;
            abstractDOMNode = abstractDOMNode.nextSibling;
        }
        return n;
    }

    @Override
    public Iterator<DOMNode> iterator() {
        return new ChildIterator();
    }

    public Iterator<DOMNode> createDescendingIterator() {
        return new DescendingChildIterator();
    }

    public Iterator<DOMNode> createIterator(BitSet bitSet) {
        return new BitSetFilteredChildIterator(bitSet);
    }

    public Iterator<DOMNode> createIterator(int n, NodeFilter nodeFilter) {
        if (nodeFilter == null) {
            return new MaskFilteredChildIterator(n);
        }
        return new CustomFilteredChildIterator(n, nodeFilter);
    }

    public NodeListIterator createListIterator() {
        return new ChildListIterator();
    }

    @Override
    public Iterator<DOMElement> elementIterator() {
        return new ElementIterator();
    }

    @Override
    public Iterator<DOMElement> elementIterator(String string) throws DOMException {
        if (string == null || string.length() == 0) {
            throw new DOMException(5, "Invalid tag name.");
        }
        return new ElementNameIterator(string);
    }

    @Override
    public Iterator<DOMElement> elementIteratorNS(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new DOMException(5, "Invalid localName.");
        }
        return new ElementNameIteratorNS(string, string2);
    }

    @Override
    public Iterator<Attr> attributeIterator() {
        return new AttributeIterator();
    }

    private void removeChild(AbstractDOMNode abstractDOMNode) {
        abstractDOMNode.removeFromParent(this);
        this.postRemoveChild(abstractDOMNode);
    }

    @Override
    public void remove(AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.previousSibling;
        AbstractDOMNode abstractDOMNode3 = abstractDOMNode.nextSibling;
        if (this.lastNode == abstractDOMNode) {
            this.lastNode = abstractDOMNode2;
        } else {
            abstractDOMNode3.previousSibling = abstractDOMNode2;
        }
        if (this.firstNode == abstractDOMNode) {
            this.firstNode = abstractDOMNode3;
        } else {
            abstractDOMNode2.nextSibling = abstractDOMNode3;
        }
        abstractDOMNode.previousSibling = null;
        abstractDOMNode.nextSibling = null;
    }

    @Override
    public AbstractDOMNode replace(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        AbstractDOMNode abstractDOMNode3 = abstractDOMNode2.previousSibling;
        AbstractDOMNode abstractDOMNode4 = abstractDOMNode2.nextSibling;
        if (this.lastNode == abstractDOMNode2) {
            this.lastNode = abstractDOMNode;
        } else {
            abstractDOMNode4.previousSibling = abstractDOMNode;
        }
        if (this.firstNode == abstractDOMNode2) {
            this.firstNode = abstractDOMNode;
        } else {
            abstractDOMNode3.nextSibling = abstractDOMNode;
        }
        abstractDOMNode.previousSibling = abstractDOMNode3;
        abstractDOMNode.nextSibling = abstractDOMNode4;
        abstractDOMNode2.previousSibling = null;
        abstractDOMNode2.nextSibling = null;
        return abstractDOMNode2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        AbstractDOMNode abstractDOMNode = this.firstNode;
        while (abstractDOMNode != null) {
            stringBuilder.append(abstractDOMNode.toString());
            abstractDOMNode = abstractDOMNode.nextSibling;
        }
        return stringBuilder.toString();
    }

    abstract void preAddChild(Node var1);

    abstract void postAddChild(AbstractDOMNode var1);

    abstract void replaceChild(Node var1, Node var2);

    abstract void postRemoveChild(AbstractDOMNode var1);

    private boolean isSameNamespace(String string, AbstractDOMNode abstractDOMNode) {
        String string2 = abstractDOMNode.getNamespaceURI();
        if (string == null) {
            return string2 == null || abstractDOMNode.isDefaultNamespace(string2);
        }
        return string.equals(string2);
    }

    private class AttributeIterator
    extends FilteredChildIterator<Attr> {
        AttributeIterator() {
        }

        @Override
        boolean isToShow(Node node) {
            return node.getNodeType() == 2;
        }

        @Override
        void removeItem(AbstractDOMNode abstractDOMNode) {
            AbstractDOMNode abstractDOMNode2 = abstractDOMNode.parentNode();
            if (abstractDOMNode2 == null) {
                throw new IllegalStateException();
            }
            abstractDOMNode2.getAttributes().removeNamedItemNS(abstractDOMNode.getNamespaceURI(), abstractDOMNode.getLocalName());
        }
    }

    private class BitSetFilteredChildIterator
    extends FilteredChildIterator<DOMNode> {
        private final BitSet whatToShow;

        BitSetFilteredChildIterator(BitSet bitSet) {
            this.whatToShow = bitSet;
        }

        @Override
        public DOMNode next() {
            AbstractDOMNode abstractDOMNode = this.findNext();
            if (abstractDOMNode != null) {
                this.currentNode = abstractDOMNode;
                return abstractDOMNode;
            }
            throw new NoSuchElementException();
        }

        @Override
        boolean isToShow(Node node) {
            return this.whatToShow.get(node.getNodeType());
        }
    }

    private class ChildIterator
    implements Iterator<DOMNode> {
        private AbstractDOMNode currentNode;
        private AbstractDOMNode last;

        ChildIterator() {
            this.currentNode = LinkedNodeList.this.firstNode;
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public DOMNode next() {
            if (this.hasNext()) {
                this.last = this.currentNode;
                this.currentNode = this.currentNode.nextSibling;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedNodeList.this.removeChild(this.last);
            this.last = null;
        }
    }

    private class ChildListIterator
    implements NodeListIterator {
        private AbstractDOMNode currentNode;
        private AbstractDOMNode last;
        private int currentIndex;

        ChildListIterator() {
            this.currentNode = LinkedNodeList.this.firstNode;
            this.last = null;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public DOMNode next() {
            if (this.hasNext()) {
                this.last = this.currentNode;
                this.currentNode = this.currentNode.nextSibling;
                ++this.currentIndex;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            if (this.currentNode != null) {
                return this.currentNode.previousSibling != null;
            }
            return LinkedNodeList.this.lastNode != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public DOMNode previous() {
            if (this.currentNode != null) {
                AbstractDOMNode abstractDOMNode = this.currentNode.previousSibling;
                if (abstractDOMNode == null) throw new NoSuchElementException();
                this.currentNode = abstractDOMNode;
            } else {
                if (LinkedNodeList.this.lastNode == null) throw new NoSuchElementException();
                this.currentNode = LinkedNodeList.this.lastNode;
            }
            this.last = this.currentNode;
            --this.currentIndex;
            return this.last;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void remove() {
            if (this.last != null) {
                if (this.currentNode != null) {
                    if (this.currentNode != this.last) {
                        int n = this.currentIndex - 1;
                        if (n < 0 || this.last != LinkedNodeList.this.item(n)) {
                            throw new IllegalStateException();
                        }
                        this.currentIndex = n;
                    } else {
                        this.currentNode = this.last.nextSibling;
                    }
                    LinkedNodeList.this.removeChild(this.last);
                } else {
                    int n = this.currentIndex - 1;
                    DOMNode dOMNode = LinkedNodeList.this.item(n);
                    if (dOMNode != this.last) {
                        throw new IllegalStateException();
                    }
                    LinkedNodeList.this.removeChild(this.last);
                    this.currentIndex = n;
                }
            } else {
                throw new IllegalStateException();
            }
            this.last = null;
        }

        @Override
        public void set(Node node) {
            if (this.last != null) {
                LinkedNodeList.this.replaceChild(node, this.last);
                if (this.currentNode == this.last) {
                    this.currentNode = (AbstractDOMNode)node;
                }
            } else {
                throw new IllegalStateException();
            }
            this.last = null;
        }

        @Override
        public void add(Node node) {
            AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
            LinkedNodeList.this.preAddChild(abstractDOMNode);
            if (this.currentNode != null) {
                LinkedNodeList.this.insertBefore(abstractDOMNode, this.currentNode);
            } else {
                LinkedNodeList.this.add(abstractDOMNode);
            }
            ++this.currentIndex;
            LinkedNodeList.this.postAddChild(abstractDOMNode);
            this.last = null;
        }
    }

    private class CustomFilteredChildIterator
    extends MaskFilteredChildIterator {
        private final NodeFilter nodeFilter;

        CustomFilteredChildIterator(int n, NodeFilter nodeFilter) {
            super(n);
            this.nodeFilter = nodeFilter;
        }

        @Override
        boolean isToShow(Node node) {
            return super.isToShow(node) && this.nodeFilter.acceptNode(node) == 1;
        }
    }

    private class DescendingChildIterator
    implements Iterator<DOMNode> {
        AbstractDOMNode currentNode;
        private AbstractDOMNode last;

        DescendingChildIterator() {
            this.currentNode = LinkedNodeList.this.lastNode;
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public DOMNode next() {
            if (this.hasNext()) {
                this.last = this.currentNode;
                this.currentNode = this.currentNode.previousSibling;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedNodeList.this.removeChild(this.last);
            this.last = null;
        }
    }

    private class ElementIterator
    extends FilteredChildIterator<DOMElement> {
        ElementIterator() {
        }

        @Override
        boolean isToShow(Node node) {
            return node.getNodeType() == 1;
        }
    }

    private class ElementNameIterator
    extends FilteredChildIterator<DOMElement> {
        private final String tagname;

        ElementNameIterator(String string) {
            this.tagname = string;
        }

        @Override
        boolean isToShow(Node node) {
            return node.getNodeType() == 1 && this.tagname.equals(node.getNodeName());
        }
    }

    private class ElementNameIteratorNS
    extends FilteredChildIterator<DOMElement> {
        private final String namespaceURI;
        private final String localName;

        ElementNameIteratorNS(String string, String string2) {
            this.namespaceURI = string;
            this.localName = string2;
        }

        @Override
        boolean isToShow(Node node) {
            DOMElement dOMElement;
            return node.getNodeType() == 1 && this.localName.equals((dOMElement = (DOMElement)node).getLocalName()) && LinkedNodeList.this.isSameNamespace(this.namespaceURI, dOMElement);
        }
    }

    private abstract class FilteredChildIterator<T extends Node>
    implements Iterator<T> {
        AbstractDOMNode currentNode = null;

        private FilteredChildIterator() {
        }

        abstract boolean isToShow(Node var1);

        @Override
        public boolean hasNext() {
            return this.findNext() != null;
        }

        AbstractDOMNode findNext() {
            AbstractDOMNode abstractDOMNode = this.currentNode;
            abstractDOMNode = abstractDOMNode == null ? LinkedNodeList.this.firstNode : abstractDOMNode.nextSibling;
            while (abstractDOMNode != null && !this.isToShow(abstractDOMNode)) {
                abstractDOMNode = abstractDOMNode.nextSibling;
            }
            return abstractDOMNode;
        }

        @Override
        public T next() {
            AbstractDOMNode abstractDOMNode = this.findNext();
            if (abstractDOMNode != null) {
                this.currentNode = abstractDOMNode;
                return (T)abstractDOMNode;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            AbstractDOMNode abstractDOMNode;
            if (this.currentNode != null && this.currentNode.parentNode() != null) {
                abstractDOMNode = this.currentNode;
                this.currentNode = this.currentNode.previousSibling;
                if (this.currentNode != null) {
                    DummyNode dummyNode = new DummyNode();
                    dummyNode.nextSibling = abstractDOMNode.nextSibling;
                    dummyNode.previousSibling = this.currentNode;
                    this.currentNode = dummyNode;
                }
            } else {
                throw new IllegalStateException();
            }
            this.removeItem(abstractDOMNode);
        }

        void removeItem(AbstractDOMNode abstractDOMNode) {
            LinkedNodeList.this.removeChild(abstractDOMNode);
        }
    }

    private class MaskFilteredChildIterator
    extends FilteredChildIterator<DOMNode> {
        final int whatToShow;

        MaskFilteredChildIterator(int n) {
            this.whatToShow = n;
        }

        @Override
        public DOMNode next() {
            AbstractDOMNode abstractDOMNode = this.findNext();
            if (abstractDOMNode != null) {
                this.currentNode = abstractDOMNode;
                return abstractDOMNode;
            }
            throw new NoSuchElementException();
        }

        @Override
        boolean isToShow(Node node) {
            int n = NodeFilter.maskTable[node.getNodeType() - 1];
            return (this.whatToShow & n) == n;
        }
    }
}

