/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.ClassnameElementList;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementLinkedList;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.EmptyElementList;
import io.sf.carte.doc.dom.LinkedNodeList;
import io.sf.carte.doc.dom.NonDocumentTypeChildNode;
import io.sf.carte.doc.dom.TagnameElementList;
import io.sf.carte.doc.dom.TagnameElementListNS;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class NDTNode
extends AbstractDOMNode
implements NonDocumentTypeChildNode {
    private static final long serialVersionUID = 2L;

    NDTNode(short s) {
        super(s);
    }

    public DOMElement getFirstElementChild() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    public DOMElement getLastElementChild() {
        for (Node node = this.getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    public int getChildElementCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean hasChildNodes() {
        return !this.getNodeList().isEmpty();
    }

    @Override
    public DOMElement getPreviousElementSibling() {
        Node node;
        for (node = this.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
        }
        return (DOMElement)node;
    }

    @Override
    public DOMElement getNextElementSibling() {
        Node node;
        for (node = this.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (DOMElement)node;
    }

    public DOMNode prependChild(Node node) throws DOMException {
        AbstractDOMNode.RawNodeList rawNodeList = this.getNodeList();
        if (rawNodeList.isEmpty()) {
            return this.appendChild(node);
        }
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
        if (abstractDOMNode.getNodeType() != 11) {
            this.preAddChild(abstractDOMNode);
            AbstractDOMNode abstractDOMNode2 = rawNodeList.getFirst();
            rawNodeList.insertBefore(abstractDOMNode, abstractDOMNode2);
            this.postAddChild(abstractDOMNode);
        } else {
            this.prependDocumentFragment(abstractDOMNode);
        }
        return abstractDOMNode;
    }

    private void prependDocumentFragment(Node node) {
        Node node2 = node.getLastChild();
        while (node2 != null) {
            Node node3 = node2.getPreviousSibling();
            this.prependChild(node2);
            node2 = node3;
        }
    }

    static DOMElement querySelector(String string, Node node) {
        SelectorList selectorList = NDTNode.parseSelectors(string);
        return NDTNode.matchQuerySelector(selectorList, node);
    }

    private static DOMElement matchQuerySelector(SelectorList selectorList, Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            DOMElement dOMElement = (DOMElement)node2;
            if (dOMElement.matches(selectorList, null)) {
                return dOMElement;
            }
            DOMElement dOMElement2 = NDTNode.matchQuerySelector(selectorList, dOMElement.getFirstChild());
            if (dOMElement2 == null) continue;
            return dOMElement2;
        }
        return null;
    }

    static ElementList querySelectorAll(String string, Node node) {
        SelectorList selectorList = NDTNode.parseSelectors(string);
        DOMElementLinkedList dOMElementLinkedList = new DOMElementLinkedList();
        dOMElementLinkedList.fillQuerySelectorList(selectorList, node);
        return dOMElementLinkedList;
    }

    private static SelectorList parseSelectors(String string) throws DOMException {
        SelectorList selectorList;
        CSSParser cSSParser = new CSSParser();
        try {
            selectorList = cSSParser.parseSelectors(new StringReader(string));
        }
        catch (CSSNamespaceParseException cSSNamespaceParseException) {
            throw NDTNode.createDOMException((short)14, "Namespaces inside the selectors are not supported: " + string, cSSNamespaceParseException);
        }
        catch (Exception exception) {
            throw NDTNode.createDOMException((short)12, "Unable to parse selector in: " + string, exception);
        }
        return selectorList;
    }

    private static DOMException createDOMException(short s, String string, Exception exception) {
        DOMException dOMException = new DOMException(s, string);
        dOMException.initCause(exception);
        return dOMException;
    }

    class ChildElementList
    implements ElementList {
        ChildElementList() {
        }

        @Override
        public boolean contains(Node node) {
            return NDTNode.this.getNodeList().contains(node);
        }

        @Override
        public DOMElement item(int n) {
            int n2 = 0;
            for (Node node = NDTNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                if (n2 == n) {
                    return (DOMElement)node;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Iterator<DOMElement> iterator() {
            return NDTNode.this.getNodeList().elementIterator();
        }

        @Override
        public int getLength() {
            return NDTNode.this.getChildElementCount();
        }

        @Override
        public boolean isEmpty() {
            return NDTNode.this.getFirstElementChild() == null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.getLength() * 32 + 40);
            for (Node node = NDTNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                stringBuilder.append(node.toString());
            }
            return stringBuilder.toString();
        }
    }

    class DefaultChildNodeList
    extends LinkedNodeList
    implements AbstractDOMNode.ChildCollections {
        private static final long serialVersionUID = 1L;
        private WeakReference<ElementList> childElementRef = null;

        DefaultChildNodeList() {
        }

        @Override
        public ElementList getChildren() {
            ElementList elementList = null;
            if (this.childElementRef != null) {
                elementList = (ElementList)this.childElementRef.get();
            }
            if (elementList == null) {
                elementList = new ChildElementList();
                this.childElementRef = new WeakReference<ElementList>(elementList);
            }
            return elementList;
        }

        @Override
        public ElementList getElementsByTagNameNS(String string, String string2) {
            boolean bl = "*".equals(string2);
            boolean bl2 = "*".equals(string);
            if (string != null && !bl2) {
                string = string.intern();
            }
            TagnameElementListNS tagnameElementListNS = new TagnameElementListNS(NDTNode.this, string2, string, bl, bl2);
            return tagnameElementListNS;
        }

        @Override
        public ElementList getElementsByTagName(String string, boolean bl) {
            if (string == null) {
                return EmptyElementList.getInstance();
            }
            boolean bl2 = "*".equals(string);
            String string2 = null;
            int n = string.indexOf(58);
            if (n != -1) {
                string2 = string.substring(0, n);
                if (++n == string.length()) {
                    return EmptyElementList.getInstance();
                }
                string = string.substring(n);
            }
            TagnameElementList tagnameElementList = new TagnameElementList(NDTNode.this, string, string2, bl2, bl);
            return tagnameElementList;
        }

        @Override
        public ElementList getElementsByClassName(String string, CSSDocument.ComplianceMode complianceMode) {
            if (string == null) {
                return EmptyElementList.getInstance();
            }
            string = string.trim();
            if (complianceMode == CSSDocument.ComplianceMode.QUIRKS) {
                string = string.toLowerCase(Locale.ROOT);
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            if (string.indexOf(32) != -1) {
                string = this.sortClassNames(string, treeSet);
            } else {
                treeSet.add(string);
            }
            ClassnameElementList classnameElementList = new ClassnameElementList(NDTNode.this, treeSet);
            return classnameElementList;
        }

        private String sortClassNames(String string, SortedSet<String> sortedSet) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                sortedSet.add(stringTokenizer.nextToken());
            }
            StringBuilder stringBuilder = new StringBuilder(string.length());
            Iterator iterator = sortedSet.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append((String)iterator.next());
            }
            return stringBuilder.toString();
        }

        @Override
        void postRemoveChild(AbstractDOMNode abstractDOMNode) {
            NDTNode.this.postRemoveChild(abstractDOMNode);
        }

        @Override
        void preAddChild(Node node) {
            NDTNode.this.preAddChild(node);
        }

        @Override
        void postAddChild(AbstractDOMNode abstractDOMNode) {
            NDTNode.this.postAddChild(abstractDOMNode);
        }

        @Override
        void replaceChild(Node node, Node node2) {
            NDTNode.this.replaceChild(node, node2);
        }
    }
}

