/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.Viewport;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;

public abstract class AbstractCSSCanvas
implements CSSCanvas {
    private CSSDocument document;

    protected AbstractCSSCanvas(CSSDocument cSSDocument) {
        this.document = cSSDocument;
    }

    @Override
    public CSSDocument getDocument() {
        return this.document;
    }

    protected void setDocument(CSSDocument cSSDocument) {
        this.document = cSSDocument;
    }

    @Override
    public CSSTypedValue getFeatureValue(String string) {
        if ("width".equals(string)) {
            return this.getWidth();
        }
        if ("height".equals(string)) {
            return this.getHeight();
        }
        if ("aspect-ratio".equals(string)) {
            float f = this.getWidthFloat() / this.getHeightFloat();
            NumberValue numberValue = new NumberValue();
            numberValue.setFloatValue((short)0, f);
            return numberValue;
        }
        if ("orientation".equals(string)) {
            return new IdentifierValue(this.getOrientation());
        }
        if ("resolution".equals(string)) {
            NumberValue numberValue = new NumberValue();
            numberValue.setFloatValue((short)60, this.getResolution());
            return numberValue;
        }
        if ("scan".equals(string)) {
            return new IdentifierValue(this.getScanType());
        }
        if ("grid".equals(string)) {
            NumberValue numberValue = new NumberValue();
            numberValue.setFloatValue((short)0, this.isGridDevice() ? 1.0f : 0.0f);
            return numberValue;
        }
        if ("update".equals(string)) {
            return new IdentifierValue(this.getUpdateFrequency());
        }
        if ("overflow-block".equals(string)) {
            return new IdentifierValue(this.getOverflowBlock());
        }
        if ("overflow-inline".equals(string)) {
            return new IdentifierValue(this.getOverflowInline());
        }
        if ("prefers-color-scheme".equals(string)) {
            return new IdentifierValue(this.getPrefersColorScheme());
        }
        if ("prefers-reduced-motion".equals(string)) {
            return new IdentifierValue(this.getPrefersReducedMotion());
        }
        if ("color".equals(string)) {
            NumberValue numberValue = new NumberValue();
            int n = this.getStyleDatabase().getColorDepth();
            numberValue.setFloatValue((short)0, n);
            return numberValue;
        }
        if ("color-index".equals(string)) {
            NumberValue numberValue = new NumberValue();
            numberValue.setFloatValue((short)0, this.getColorIndex());
            return numberValue;
        }
        if ("monochrome".equals(string)) {
            NumberValue numberValue = new NumberValue();
            numberValue.setFloatValue((short)0, this.getMonoBitsPerPixel());
            return numberValue;
        }
        return null;
    }

    @Override
    public boolean matchesFeature(String string, CSSTypedValue cSSTypedValue) {
        if ("orientation".equals(string)) {
            return this.matches(cSSTypedValue, this.getOrientation());
        }
        if ("scan".equals(string)) {
            return this.matches(cSSTypedValue, this.getScanType());
        }
        if ("grid".equals(string)) {
            return this.isGridDevice() ? cSSTypedValue == null || !cSSTypedValue.isNumberZero() : cSSTypedValue != null && cSSTypedValue.isNumberZero();
        }
        if ("update".equals(string)) {
            return this.matches(cSSTypedValue, this.getUpdateFrequency());
        }
        if ("overflow-block".equals(string)) {
            return this.matches(cSSTypedValue, this.getOverflowBlock());
        }
        if ("overflow-inline".equals(string)) {
            return this.matches(cSSTypedValue, this.getOverflowInline());
        }
        if ("prefers-color-scheme".equals(string)) {
            String string2 = this.getPrefersColorScheme();
            if (cSSTypedValue != null) {
                return cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT && string2.equalsIgnoreCase(cSSTypedValue.getStringValue());
            }
        } else {
            if ("prefers-reduced-motion".equals(string)) {
                String string3 = this.getPrefersReducedMotion();
                if (cSSTypedValue != null) {
                    return cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT && string3.equalsIgnoreCase(cSSTypedValue.getStringValue());
                }
                return !"no-preference".equals(string3);
            }
            if ("color-gamut".equals(string)) {
                if (cSSTypedValue == null) {
                    return !this.supportsGamut("none");
                }
                if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    String string4 = cSSTypedValue.getStringValue();
                    return this.supportsGamut(string4);
                }
            } else if ("pointer".equals(string)) {
                return this.matches(cSSTypedValue, this.getPointerAccuracy());
            }
        }
        return false;
    }

    private boolean matches(CSSTypedValue cSSTypedValue, String string) {
        if (cSSTypedValue == null) {
            return !"none".equals(string);
        }
        return AbstractCSSCanvas.isCSSIdentifier(cSSTypedValue, string);
    }

    private static boolean isCSSIdentifier(CSSTypedValue cSSTypedValue, String string) {
        return cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT && string.equalsIgnoreCase(cSSTypedValue.getStringValue());
    }

    private NumberValue getWidth() {
        StyleDatabase styleDatabase = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float f = viewport == null ? styleDatabase.getDeviceWidth() : (float)viewport.getViewportWidth();
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue(styleDatabase.getNaturalUnit(), f);
        return numberValue;
    }

    private NumberValue getHeight() {
        StyleDatabase styleDatabase = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float f = viewport == null ? styleDatabase.getDeviceHeight() : (float)viewport.getViewportHeight();
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue(styleDatabase.getNaturalUnit(), f);
        return numberValue;
    }

    private float getWidthFloat() {
        StyleDatabase styleDatabase = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float f = viewport == null ? styleDatabase.getDeviceWidth() : (float)viewport.getViewportWidth();
        return f;
    }

    private float getHeightFloat() {
        StyleDatabase styleDatabase = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float f = viewport == null ? styleDatabase.getDeviceHeight() : (float)viewport.getViewportHeight();
        return f;
    }

    protected float getColorIndex() {
        return 1.6777216E7f;
    }

    protected boolean isGridDevice() {
        return false;
    }

    protected int getMonoBitsPerPixel() {
        return 0;
    }

    protected String getOrientation() {
        float f;
        float f2 = this.getWidth().getFloatValue((short)3);
        if (f2 >= (f = this.getHeight().getFloatValue((short)3))) {
            return "landscape";
        }
        return "portrait";
    }

    protected abstract String getOverflowBlock();

    protected abstract String getOverflowInline();

    protected String getPointerAccuracy() {
        return "none";
    }

    protected String getPrefersColorScheme() {
        return "light";
    }

    protected String getPrefersReducedMotion() {
        return "no-preference";
    }

    protected float getResolution() {
        return 96.0f;
    }

    protected String getScanType() {
        return "progressive";
    }

    protected String getUpdateFrequency() {
        return "none";
    }

    protected boolean supportsGamut(String string) {
        return "srgb".equalsIgnoreCase(string);
    }
}

