/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AbstractStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import io.sf.carte.doc.style.css.om.UnknownRule;
import io.sf.carte.doc.style.css.om.ViewportRule;
import io.sf.carte.util.Visitor;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.DOMException;

public abstract class AbstractCSSStyleSheet
extends AbstractStyleSheet
implements CSSStyleSheet<AbstractCSSRule> {
    private static final long serialVersionUID = 1L;
    static final int CONNECT_TIMEOUT = 10000;

    protected AbstractCSSStyleSheet(String string) {
        super(string);
    }

    @Override
    public abstract CSSRuleArrayList getCssRules();

    @Override
    public abstract AbstractCSSStyleSheet getParentStyleSheet();

    @Override
    public abstract AbstractCSSRule getOwnerRule();

    @Override
    public abstract AbstractCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public abstract boolean parseStyleSheet(Reader var1) throws DOMException, IOException;

    @Override
    public abstract boolean parseStyleSheet(Reader var1, short var2) throws DOMException, IOException;

    @Override
    public abstract void addStyleSheet(AbstractCSSStyleSheet var1);

    public abstract boolean loadStyleSheet(URL var1, String var2) throws DOMException, IOException;

    @Override
    public abstract FontFaceRule createFontFaceRule();

    @Override
    public abstract ImportRule createImportRule(MediaQueryList var1, String var2);

    @Override
    public abstract MediaRule createMediaRule(MediaQueryList var1);

    @Override
    public abstract PageRule createPageRule();

    @Override
    public abstract StyleRule createStyleRule();

    @Override
    public abstract SupportsRule createSupportsRule(String var1) throws DOMException;

    @Override
    public abstract SupportsRule createSupportsRule(BooleanCondition var1);

    @Override
    @Deprecated
    public abstract SupportsRule createSupportsRule();

    @Override
    public abstract UnknownRule createUnknownRule();

    @Override
    public abstract ViewportRule createViewportRule();

    @Override
    public abstract AbstractCSSStyleDeclaration createStyleDeclaration();

    protected abstract AbstractCSSStyleDeclaration createStyleDeclaration(BaseCSSDeclarationRule var1);

    protected abstract void registerNamespace(CSSNamespaceRule var1);

    protected abstract void unregisterNamespace(String var1);

    protected abstract String getNamespacePrefix(String var1);

    protected abstract boolean hasDefaultNamespace();

    public abstract void setHref(String var1);

    public abstract byte getOrigin();

    @Override
    public abstract AbstractCSSStyleSheet clone();

    @Override
    public URLConnection openConnection(URL uRL, String string) throws IOException {
        Object object;
        Object object2;
        CSSDocument cSSDocument = null;
        if (this.getOwnerNode() != null) {
            cSSDocument = (CSSDocument)this.getOwnerNode().getOwnerDocument();
        } else if (this.getOwnerRule() != null && (object2 = this.getOwnerRule().getParentStyleSheet()) != null && (object = object2.getOwnerNode()) != null) {
            cSSDocument = object.getNodeType() != 9 ? (CSSDocument)object.getOwnerDocument() : (CSSDocument)object;
        }
        if (cSSDocument != null) {
            object2 = cSSDocument.openConnection(uRL);
            object = cSSDocument.getDocumentURI();
            if (object != null) {
                String string2;
                if ("".equals(string)) {
                    string = cSSDocument.getReferrerPolicy();
                }
                if ((string2 = this.getReferrer((String)object, uRL, string)) != null) {
                    ((URLConnection)object2).setRequestProperty("Referer", string2);
                }
            }
        } else {
            object2 = uRL.openConnection();
        }
        ((URLConnection)object2).setAllowUserInteraction(false);
        ((URLConnection)object2).setConnectTimeout(10000);
        return object2;
    }

    private String getReferrer(String string, URL uRL, String string2) {
        if ("no-referrer".equals(string2)) {
            string = null;
        } else if ("origin".equals(string2)) {
            string = this.getOrigin(string);
        } else if ("same-origin".equals(string2)) {
            string = this.getSameOrigin(string, uRL);
        } else if ("strict-origin".equals(string2)) {
            string = this.getStrictOrigin(string, uRL);
        } else if (!"unsafe-url".equals(string2)) {
            string = this.getNoReferrerWhenDowngrade(string, uRL);
        }
        return string;
    }

    private String getOrigin(String string) {
        try {
            URL uRL = new URL(string);
            if (!this.isLocalScheme(uRL.getProtocol())) {
                URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), this.urlPort(uRL), "/");
                return uRL2.toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private String getSameOrigin(String string, URL uRL) {
        try {
            String string2;
            URL uRL2 = new URL(string);
            if (!this.isLocalScheme(uRL2.getProtocol()) && (string2 = uRL.getHost()) != null && string2.equalsIgnoreCase(uRL2.getHost())) {
                URL uRL3 = new URL(uRL2.getProtocol(), uRL2.getHost(), this.urlPort(uRL2), uRL2.getFile());
                return uRL3.toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private String getStrictOrigin(String string, URL uRL) {
        try {
            URL uRL2 = new URL(string);
            if (!this.isLocalScheme(uRL2.getProtocol())) {
                String string2 = uRL.getProtocol();
                String string3 = uRL.getHost();
                if (!"https".equals(uRL2.getProtocol()) || "https".equals(string2) && string3 != null && string3.equalsIgnoreCase(uRL2.getHost())) {
                    URL uRL3 = new URL(uRL2.getProtocol(), uRL2.getHost(), this.urlPort(uRL2), "/");
                    return uRL3.toExternalForm();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private String getNoReferrerWhenDowngrade(String string, URL uRL) {
        try {
            URL uRL2 = new URL(string);
            if (!this.isLocalScheme(uRL2.getProtocol())) {
                String string2 = uRL.getProtocol();
                if (!"https".equals(uRL2.getProtocol()) || "https".equals(string2)) {
                    URL uRL3 = new URL(uRL2.getProtocol(), uRL2.getHost(), this.urlPort(uRL2), uRL2.getFile());
                    return uRL3.toExternalForm();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private boolean isLocalScheme(String string) {
        return !"https".equals(string) && !"http".equals(string);
    }

    private int urlPort(URL uRL) {
        int n = uRL.getPort();
        if (n == uRL.getDefaultPort()) {
            n = -1;
        }
        return n;
    }

    public abstract StyleRule getFirstStyleRule(SelectorList var1);

    public abstract CSSRuleArrayList getStyleRules(Selector var1);

    public abstract void acceptStyleRuleVisitor(Visitor<CSSStyleRule> var1);

    public abstract void acceptDeclarationRuleVisitor(Visitor<CSSDeclarationRule> var1);

    public abstract void acceptDescriptorRuleVisitor(Visitor<CSSDeclarationRule> var1);

    protected abstract void setParentStyleSheet(AbstractCSSStyleSheet var1);

    public static byte parseRelAttribute(String string) {
        boolean bl = false;
        boolean bl2 = false;
        byte by = -1;
        int n = (string = string.trim()).indexOf(32);
        if (n == -1) {
            boolean bl3 = bl = string.length() == 0 || string.equalsIgnoreCase("stylesheet");
            if (!bl) {
                bl = bl2 = "alternate".equalsIgnoreCase(string);
            }
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1).trim();
            bl2 = "alternate".equalsIgnoreCase(string2) || "alternate".equalsIgnoreCase(string3);
            boolean bl4 = bl = bl2 && ("stylesheet".equalsIgnoreCase(string3) || "stylesheet".equalsIgnoreCase(string2));
        }
        if (bl) {
            by = bl2 ? (byte)1 : 0;
        }
        return by;
    }
}

