/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class BackgroundShorthandSetter
extends ShorthandSetter {
    private static CSSValueSyntax lengthPercentage = new SyntaxParser().parseSyntax("<length-percentage>");
    private StringBuilder layerBuffer = null;
    private StringBuilder miniLayerBuffer = null;
    private int layerCount = 0;
    private final ValueList lstImage = ValueList.createCSValueList();
    private final ValueList lstPosition = ValueList.createCSValueList();
    private final ValueList lstSize = ValueList.createCSValueList();
    private final ValueList lstRepeat = ValueList.createCSValueList();
    private final ValueList lstClip = ValueList.createCSValueList();
    private final ValueList lstOrigin = ValueList.createCSValueList();
    private final ValueList lstAttachment = ValueList.createCSValueList();
    private LexicalUnit geometryBox = null;

    BackgroundShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "background");
    }

    @Override
    public void init(LexicalUnit lexicalUnit, boolean bl) {
        this.currentValue = lexicalUnit;
        this.setPriority(bl);
        this.countLayers(lexicalUnit);
    }

    void countLayers(LexicalUnit lexicalUnit) {
        this.layerCount = 0;
        int n = 0;
        for (LexicalUnit lexicalUnit2 = lexicalUnit; lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (n <= 0) continue;
                ++this.layerCount;
                n = 0;
                continue;
            }
            ++n;
        }
        if (n > 0) {
            ++this.layerCount;
        }
    }

    @Override
    StringBuilder getValueItemBuffer() {
        return this.layerBuffer;
    }

    @Override
    StringBuilder getValueItemBufferMini() {
        return this.miniLayerBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean assignSubproperties() {
        LinkedList<LexicalUnit> linkedList = null;
        this.layerBuffer = new StringBuilder(64);
        this.miniLayerBuffer = new StringBuilder(64);
        String[] stringArray = this.getShorthandSubproperties();
        int n = 0;
        while (true) {
            StyleValue styleValue;
            HashSet<String> hashSet;
            block24: {
                boolean bl;
                if (n < this.layerCount && this.currentValue != null) {
                    bl = false;
                    hashSet = new HashSet<String>(stringArray.length);
                    Collections.addAll(hashSet, stringArray);
                } else {
                    this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                    this.setListSubpropertyValue("background-image", this.lstImage);
                    this.setListSubpropertyValue("background-position", this.lstPosition);
                    this.setListSubpropertyValue("background-size", this.lstSize);
                    this.setListSubpropertyValue("background-origin", this.lstOrigin);
                    this.setListSubpropertyValue("background-clip", this.lstClip);
                    this.setListSubpropertyValue("background-repeat", this.lstRepeat);
                    this.setListSubpropertyValue("background-attachment", this.lstAttachment);
                    if (!this.isPropertySet("background-color")) {
                        StyleValue styleValue2 = this.defaultPropertyValue("background-color");
                        this.setSubpropertyValue("background-color", styleValue2);
                    }
                    this.flush();
                    return true;
                }
                block7: while (this.currentValue != null) {
                    if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        if (bl) {
                            this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                            this.layerBuffer.setLength(0);
                            this.miniLayerBuffer.setLength(0);
                            if (++n != this.layerCount) {
                                this.layerBuffer.append(',');
                                this.miniLayerBuffer.append(',');
                            }
                            if (linkedList != null) {
                                this.reportUnknownValues(hashSet, linkedList);
                                linkedList = null;
                            }
                        } else {
                            linkedList = null;
                            break;
                        }
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        break;
                    }
                    LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
                    if (lexicalType == LexicalUnit.LexicalType.INHERIT || lexicalType == LexicalUnit.LexicalType.INITIAL || lexicalType == LexicalUnit.LexicalType.UNSET || lexicalType == LexicalUnit.LexicalType.REVERT) {
                        styleValue = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                        break block24;
                    }
                    switch (this.assignLayerValue(n, hashSet)) {
                        case 1: {
                            if (n != this.layerCount - 1) {
                                bl = false;
                                break block7;
                            }
                        }
                        case 0: {
                            bl = true;
                            break;
                        }
                        case 2: {
                            if (linkedList == null) {
                                linkedList = new LinkedList<LexicalUnit>();
                            }
                            linkedList.add(this.currentValue);
                            this.nextCurrentValue();
                        }
                        case 3: {
                            bl = false;
                            break block7;
                        }
                    }
                }
                if (linkedList != null) {
                    this.handleLayerUnknownValues(hashSet, linkedList);
                    linkedList = null;
                }
                if (!bl) {
                    this.layerBuffer.setLength(0);
                    this.miniLayerBuffer.setLength(0);
                    StringBuilder stringBuilder = new StringBuilder(64);
                    stringBuilder.append("Invalid layer found: ").append(n);
                    if (this.currentValue != null) {
                        stringBuilder.append(' ').append(this.currentValue.toString());
                    }
                    this.reportDeclarationError("background", stringBuilder.toString());
                    return false;
                }
                this.assignPendingValues(n, hashSet);
                if (hashSet.size() <= 0) continue;
                this.resetUnsetProperties(hashSet);
                continue;
            }
            while (this.currentValue != null) {
                boolean bl = this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA;
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (!bl) continue;
            }
            this.clearLayer(hashSet, ++n);
            this.addSingleValueLayer(styleValue);
            this.layerBuffer.setLength(0);
            this.miniLayerBuffer.setLength(0);
            if (n != 1) {
                this.layerBuffer.append(',');
                this.miniLayerBuffer.append(',');
            }
            this.appendValueItemString(styleValue);
            this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
            this.layerBuffer.setLength(0);
            this.miniLayerBuffer.setLength(0);
            if (n == this.layerCount) continue;
            this.layerBuffer.append(',');
            this.miniLayerBuffer.append(',');
        }
    }

    private void clearLayer(Set<String> set, int n) {
        if (!set.contains("background-image") && this.lstImage.getLength() == n) {
            this.lstImage.remove(n - 1);
        }
        if (!set.contains("background-position") && this.lstPosition.getLength() == n) {
            this.lstPosition.remove(n - 1);
        }
        if (!set.contains("background-size") && this.lstSize.getLength() == n) {
            this.lstSize.remove(n - 1);
        }
        if (!set.contains("background-origin") && this.lstOrigin.getLength() == n) {
            this.lstOrigin.remove(n - 1);
        }
        if (!set.contains("background-clip") && this.lstClip.getLength() == n) {
            this.lstClip.remove(n - 1);
        }
        if (!set.contains("background-repeat") && this.lstRepeat.getLength() == n) {
            this.lstRepeat.remove(n - 1);
        }
        if (!set.contains("background-attachment") && this.lstAttachment.getLength() == n) {
            this.lstAttachment.remove(n - 1);
        }
    }

    private void addSingleValueLayer(StyleValue styleValue) {
        this.lstImage.add(styleValue);
        this.lstPosition.add(styleValue);
        this.lstSize.add(styleValue);
        this.lstRepeat.add(styleValue);
        this.lstOrigin.add(styleValue);
        this.lstClip.add(styleValue);
        this.lstAttachment.add(styleValue);
        if (this.currentValue == null) {
            this.setSubpropertyValue("background-color", styleValue);
        }
    }

    private byte assignLayerValue(int n, Set<String> set) {
        int n2;
        if (set.contains("background-color") && BaseCSSStyleDeclaration.testColor(this.currentValue)) {
            StyleValue styleValue = this.createCSSValue("background-color", this.currentValue);
            this.setSubpropertyValue("background-color", styleValue);
            set.remove("background-color");
            n2 = 1;
            this.nextCurrentValue();
        } else if (set.contains("background-image") && this.testBackgroundImage(n, set)) {
            this.nextCurrentValue();
            n2 = 0;
        } else if (set.contains("background-position") && this.testBackgroundPosition(this.lstPosition)) {
            set.remove("background-position");
            this.nextCurrentValue();
            n2 = 0;
            if (this.currentValue != null && LexicalUnit.LexicalType.OPERATOR_SLASH == this.currentValue.getLexicalUnitType()) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.testBackgroundSize(n, set)) {
                    this.nextCurrentValue();
                } else {
                    StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                    if (styleDeclarationErrorHandler != null) {
                        styleDeclarationErrorHandler.shorthandSyntaxError("background", "Size not found after slash");
                    }
                    n2 = 3;
                }
            }
        } else if (set.contains("background-attachment") && this.testIdentifierProperty(n, set, "background-attachment", this.lstAttachment)) {
            this.nextCurrentValue();
            set.remove("background-attachment");
            n2 = 0;
        } else if (set.contains("background-repeat") && this.testBackgroundRepeat(this.lstRepeat)) {
            set.remove("background-repeat");
            n2 = 0;
        } else if (set.contains("background-origin") && this.testIdentifierProperty(n, set, "background-origin", this.lstOrigin)) {
            this.geometryBox = this.currentValue;
            this.nextCurrentValue();
            set.remove("background-origin");
            n2 = 0;
        } else if (set.contains("background-clip") && this.testIdentifierProperty(n, set, "background-clip", this.lstClip)) {
            this.nextCurrentValue();
            set.remove("background-clip");
            this.geometryBox = null;
            n2 = 0;
        } else {
            n2 = 2;
        }
        return (byte)n2;
    }

    private void assignPendingValues(int n, Set<String> set) {
        if (set.contains("background-clip") && this.geometryBox != null) {
            StyleValue styleValue = this.createCSSValue("background-clip", this.geometryBox);
            this.lstClip.add(styleValue);
            set.remove("background-clip");
        }
        this.geometryBox = null;
    }

    private void handleLayerUnknownValues(Set<String> set, List<LexicalUnit> list) {
        if (set.size() == 1 && list.size() == 1 && this.lastChanceLayerAssign(set.iterator().next(), list.get(0))) {
            set.clear();
            return;
        }
        this.reportUnknownValues(set, list);
    }

    private boolean lastChanceLayerAssign(String string, LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
            StyleValue styleValue = this.createCSSValue(string, lexicalUnit);
            this.setSubpropertyValue(string, styleValue);
            return true;
        }
        return false;
    }

    private void reportUnknownValues(Set<String> set, List<LexicalUnit> list) {
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.styleDeclaration.getParentRule();
        if (baseCSSDeclarationRule != null) {
            StyleDeclarationErrorHandler styleDeclarationErrorHandler = baseCSSDeclarationRule.getStyleDeclarationErrorHandler();
            if (list.size() == 1 && list.get(0).getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                styleDeclarationErrorHandler.unknownIdentifier("background", list.get(0).getStringValue());
            } else {
                styleDeclarationErrorHandler.unassignedShorthandValues("background", set.toArray(new String[0]), list.toArray(new LexicalUnit[0]));
            }
        }
    }

    private void resetUnsetProperties(Set<String> set) {
        for (String string : set) {
            StyleValue styleValue = this.defaultPropertyValue(string);
            if ("background-image".equals(string)) {
                this.lstImage.add(styleValue);
                continue;
            }
            if ("background-position".equals(string)) {
                this.lstPosition.add(styleValue);
                continue;
            }
            if ("background-size".equals(string)) {
                ValueList valueList = ValueList.createWSValueList();
                valueList.add(styleValue);
                valueList.add(styleValue);
                this.lstSize.add(valueList);
                continue;
            }
            if ("background-origin".equals(string)) {
                this.lstOrigin.add(styleValue);
                continue;
            }
            if ("background-clip".equals(string)) {
                this.lstClip.add(styleValue);
                continue;
            }
            if ("background-repeat".equals(string)) {
                this.lstRepeat.add(styleValue);
                continue;
            }
            if (!"background-attachment".equals(string)) continue;
            this.lstAttachment.add(styleValue);
        }
    }

    @Override
    protected void nextCurrentValue() {
        this.appendValueItemString();
        this.currentValue = this.currentValue.getNextLexicalUnit();
    }

    private boolean testBackgroundImage(int n, Set<String> set) {
        if (this.isImage()) {
            this.lstImage.add(this.createCSSValue("background-image", this.currentValue));
            set.remove("background-image");
            return true;
        }
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "none".equals(this.currentValue.getStringValue())) {
            this.lstImage.add(this.createCSSValue("background-image", this.currentValue));
            set.remove("background-image");
            return true;
        }
        return false;
    }

    private boolean testBackgroundPosition(ValueList valueList) {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.testIdentifiers("background-position") || ValueFactory.isSizeSACUnit(this.currentValue)) {
            ValueList valueList2 = ValueList.createWSValueList();
            StyleValue styleValue = this.createCSSValue("background-position", this.currentValue);
            valueList2.add(styleValue);
            int n = 1;
            LexicalUnit lexicalUnit = this.currentValue.getNextLexicalUnit();
            while (lexicalUnit != null && n < 4) {
                if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.getShorthandDatabase().isIdentifierValue("background-position", lexicalUnit.getStringValue()) || ValueFactory.isSizeSACUnit(lexicalUnit) || lexicalUnit.matches(lengthPercentage) == CSSValueSyntax.Match.TRUE) {
                    styleValue = this.createCSSValue("background-position", lexicalUnit);
                    valueList2.add(styleValue);
                    n = (short)(n + 1);
                    this.nextCurrentValue();
                    lexicalUnit = this.currentValue.getNextLexicalUnit();
                    continue;
                }
                lexicalUnit = null;
            }
            if (valueList2.getLength() == 1) {
                valueList.add(valueList2.item(0));
            } else if (this.checkPositionProperty(valueList2)) {
                valueList.add(valueList2);
            } else {
                BaseCSSDeclarationRule baseCSSDeclarationRule = this.styleDeclaration.getParentRule();
                if (baseCSSDeclarationRule != null) {
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Wrong value for background-position");
                    cSSPropertyValueException.setValueText(valueList2.getCssText());
                    baseCSSDeclarationRule.getStyleDeclarationErrorHandler().wrongValue("background-position", cSSPropertyValueException);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkPositionProperty(ValueList valueList) {
        int n = valueList.getLength();
        if (n == 2) {
            return true;
        }
        if (n == 4) {
            return valueList.item(0).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(1).getPrimitiveType() != CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(3).getPrimitiveType() != CSSValue.Type.IDENT;
        }
        if (valueList.item(0).getPrimitiveType() != CSSValue.Type.IDENT) {
            return false;
        }
        if (valueList.item(1).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() != CSSValue.Type.IDENT) {
            return true;
        }
        return valueList.item(1).getPrimitiveType() != CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() == CSSValue.Type.IDENT;
    }

    private boolean testBackgroundSize(int n, Set<String> set) {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.testIdentifiers("background-size") || ValueFactory.isSizeSACUnit(this.currentValue)) {
            ValueList valueList = ValueList.createWSValueList();
            StyleValue styleValue = this.createCSSValue("background-size", this.currentValue);
            valueList.add(styleValue);
            this.layerBuffer.append(" /");
            this.miniLayerBuffer.append('/');
            LexicalUnit lexicalUnit = this.currentValue.getNextLexicalUnit();
            if (lexicalUnit != null && (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.getShorthandDatabase().isIdentifierValue("background-size", lexicalUnit.getStringValue()) || ValueFactory.isSizeSACUnit(lexicalUnit) || lexicalUnit.matches(lengthPercentage) == CSSValueSyntax.Match.TRUE)) {
                styleValue = this.createCSSValue("background-size", lexicalUnit);
                valueList.add(styleValue);
                this.nextCurrentValue();
            }
            if (valueList.getLength() == 1) {
                this.lstSize.add(valueList.item(0));
            } else {
                this.lstSize.add(valueList);
            }
            set.remove("background-size");
            return true;
        }
        return false;
    }

    private boolean testBackgroundRepeat(ValueList valueList) {
        if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers("background-repeat")) {
            StyleValue styleValue = this.createCSSValue("background-repeat", this.currentValue);
            String string = styleValue.getCssText();
            this.nextCurrentValue();
            if (string.equals("repeat-y") || string.equals("repeat-x")) {
                valueList.add(styleValue);
            } else if (this.currentValue != null && LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers("background-repeat")) {
                ValueList valueList2 = ValueList.createWSValueList();
                valueList2.add(styleValue);
                valueList2.add(this.createCSSValue("background-repeat", this.currentValue));
                valueList.add(valueList2);
                this.nextCurrentValue();
            } else {
                valueList.add(styleValue);
            }
            return true;
        }
        return false;
    }

    private boolean testIdentifierProperty(int n, Set<String> set, String string, ValueList valueList) {
        if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers(string)) {
            StyleValue styleValue = this.createCSSValue(string, this.currentValue);
            valueList.add(styleValue);
            return true;
        }
        return false;
    }
}

