/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.agent.HeadlessDeviceFactory;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSLexicalValue;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingFactory;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.DefaultSheetErrorHandler;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingFactory;
import io.sf.carte.doc.style.css.om.LenientSystemDefaultValue;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.PropertyDefinition;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.agent.AgentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class BaseCSSStyleSheetFactory
extends AbstractCSSStyleSheetFactory {
    private static final long serialVersionUID = 1L;
    private static final String HTML_DEFAULT_SHEET = "/io/sf/carte/doc/style/css/html.css";
    private static final String HTML_DEFAULT_SHEET_QUIRKS = "/io/sf/carte/doc/style/css/html-quirks.css";
    private ClassLoader classLoader = null;
    private StyleFormattingFactory formattingFactory;
    private final EnumSet<Parser.Flag> parserFlags;
    private byte flags = 0;
    private boolean lenientSystemValues = true;
    private AbstractCSSStyleSheet userImportantSheet = null;
    private AbstractCSSStyleSheet userNormalSheet = null;
    private DeviceFactory deviceFactory = null;

    protected BaseCSSStyleSheetFactory() {
        this(EnumSet.noneOf(Parser.Flag.class));
    }

    protected BaseCSSStyleSheetFactory(EnumSet<Parser.Flag> enumSet) {
        this.parserFlags = enumSet;
        this.setDeviceFactory(new HeadlessDeviceFactory());
        this.setStyleFormattingFactory(this.createDefaultStyleFormattingFactory());
    }

    protected StyleFormattingFactory createDefaultStyleFormattingFactory() {
        return new DefaultStyleFormattingFactory();
    }

    protected abstract BaseDocumentCSSStyleSheet createDocumentStyleSheet(byte var1);

    @Override
    public AbstractCSSStyleSheet createStyleSheet(String string, MediaQueryList mediaQueryList) {
        if (mediaQueryList == null) {
            mediaQueryList = MediaQueryListImpl.createUnmodifiable();
        }
        return this.createLinkedStyleSheet(null, string, mediaQueryList);
    }

    @Override
    protected abstract AbstractCSSStyleSheet createRuleStyleSheet(AbstractCSSRule var1, String var2, MediaQueryList var3);

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public CSSPropertyDefinition createPropertyDefinition(String string, CSSValueSyntax cSSValueSyntax, boolean bl, CSSLexicalValue cSSLexicalValue) throws DOMException {
        if (string == null) {
            throw new NullPointerException("Null name.");
        }
        if (cSSValueSyntax == null) {
            throw new NullPointerException("Null syntax.");
        }
        if (cSSLexicalValue == null) {
            if (cSSValueSyntax.getCategory() != CSSValueSyntax.Category.universal) {
                throw new DOMException(15, "Null initial value.");
            }
        } else if (cSSLexicalValue.matches(cSSValueSyntax) != CSSValueSyntax.Match.TRUE) {
            throw new DOMException(15, "Value " + cSSLexicalValue.getCssText() + " does not match syntax " + cSSValueSyntax.toString() + '.');
        }
        PropertyDefinition propertyDefinition = new PropertyDefinition(string, cSSValueSyntax, bl, cSSLexicalValue);
        return propertyDefinition;
    }

    @Override
    public StyleFormattingFactory getStyleFormattingFactory() {
        return this.formattingFactory;
    }

    @Override
    public void setStyleFormattingFactory(StyleFormattingFactory styleFormattingFactory) {
        this.formattingFactory = styleFormattingFactory;
    }

    @Override
    public void setUserStyleSheet(String string, Reader reader) throws DOMException, IOException {
        block15: {
            if (reader != null) {
                this.loadUserStyleSheet(string, reader);
            } else {
                if (string != null) {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    String string2 = uRLConnection.getContentType();
                    String string3 = uRLConnection.getContentEncoding();
                    try (InputStream inputStream = uRLConnection.getInputStream();
                         Reader reader2 = AgentUtil.inputStreamToReader((InputStream)inputStream, (String)string2, (String)string3, (Charset)StandardCharsets.UTF_8);){
                        this.loadUserStyleSheet(uRL.toExternalForm(), reader2);
                        break block15;
                    }
                }
                this.userImportantSheet = null;
                this.userNormalSheet = null;
            }
        }
    }

    private void loadUserStyleSheet(String string, Reader reader) throws DOMException, IOException {
        BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet = this.createDocumentStyleSheet((byte)9);
        ((AbstractCSSStyleSheet)baseDocumentCSSStyleSheet).parseStyleSheet(reader);
        this.userImportantSheet = this.createDocumentStyleSheet((byte)3);
        this.userNormalSheet = this.createDocumentStyleSheet((byte)9);
        this.userImportantSheet.setHref(string);
        this.userNormalSheet.setHref(string);
        this.userNormalSheet.getCssRules().ensureCapacity(((AbstractCSSStyleSheet)baseDocumentCSSStyleSheet).getCssRules().getLength());
        BaseCSSStyleSheetFactory.prioritySplit(baseDocumentCSSStyleSheet, this.userImportantSheet, this.userNormalSheet);
    }

    @Override
    public void setUserStyleSheet(Reader reader) throws DOMException, IOException {
        this.setUserStyleSheet(null, reader);
    }

    @Override
    protected AbstractCSSStyleSheet getUserImportantStyleSheet() {
        return this.userImportantSheet;
    }

    @Override
    protected AbstractCSSStyleSheet getUserNormalStyleSheet() {
        return this.userNormalSheet;
    }

    static void prioritySplit(AbstractCSSStyleSheet abstractCSSStyleSheet, AbstractCSSStyleSheet abstractCSSStyleSheet2, AbstractCSSStyleSheet abstractCSSStyleSheet3) {
        AbstractCSSStyleDeclaration abstractCSSStyleDeclaration = abstractCSSStyleSheet.createStyleDeclaration();
        AbstractCSSStyleDeclaration abstractCSSStyleDeclaration2 = abstractCSSStyleSheet.createStyleDeclaration();
        CSSRuleArrayList cSSRuleArrayList = abstractCSSStyleSheet.getCssRules();
        int n = cSSRuleArrayList.getLength();
        for (int i = 0; i < n; ++i) {
            AbstractCSSRule abstractCSSRule = (AbstractCSSRule)cSSRuleArrayList.item(i);
            if (abstractCSSRule.getType() == 1) {
                BaseCSSStyleDeclaration baseCSSStyleDeclaration;
                StyleRule styleRule;
                abstractCSSStyleDeclaration.clear();
                abstractCSSStyleDeclaration2.clear();
                StyleRule styleRule2 = (StyleRule)abstractCSSRule;
                AbstractCSSStyleDeclaration abstractCSSStyleDeclaration3 = styleRule2.getStyle();
                abstractCSSStyleDeclaration3.prioritySplit(abstractCSSStyleDeclaration, abstractCSSStyleDeclaration2);
                if (!abstractCSSStyleDeclaration.isEmpty()) {
                    styleRule = abstractCSSStyleSheet2.createStyleRule();
                    styleRule.setSelectorList(styleRule2.getSelectorList());
                    baseCSSStyleDeclaration = (BaseCSSStyleDeclaration)styleRule.getStyle();
                    baseCSSStyleDeclaration.setProperties((BaseCSSStyleDeclaration)abstractCSSStyleDeclaration);
                    abstractCSSStyleSheet2.addRule(styleRule);
                }
                if (abstractCSSStyleDeclaration2.isEmpty()) continue;
                styleRule = abstractCSSStyleSheet3.createStyleRule();
                styleRule.setSelectorList(styleRule2.getSelectorList());
                baseCSSStyleDeclaration = (BaseCSSStyleDeclaration)styleRule.getStyle();
                baseCSSStyleDeclaration.setProperties((BaseCSSStyleDeclaration)abstractCSSStyleDeclaration2);
                abstractCSSStyleSheet3.addRule(styleRule);
                continue;
            }
            abstractCSSStyleSheet3.addRule(abstractCSSRule.clone(abstractCSSStyleSheet3));
        }
    }

    protected BaseDocumentCSSStyleSheet htmlDefaultSheet() throws IllegalStateException {
        InputStream inputStream = this.loadCSSfromClasspath(HTML_DEFAULT_SHEET);
        try {
            return this.loadDefaultSheet(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not read the default style sheet", iOException);
        }
    }

    protected BaseDocumentCSSStyleSheet htmlQuirksDefaultSheet() throws IllegalStateException {
        InputStream inputStream = this.loadCSSfromClasspath(HTML_DEFAULT_SHEET_QUIRKS);
        try {
            return this.loadDefaultSheet(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not read the default style sheet", iOException);
        }
    }

    private BaseDocumentCSSStyleSheet loadDefaultSheet(InputStream inputStream) throws IOException {
        BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            baseDocumentCSSStyleSheet = this.createDocumentStyleSheet((byte)16);
            baseDocumentCSSStyleSheet.parseStyleSheet(inputStreamReader, (short)0);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return baseDocumentCSSStyleSheet;
    }

    private InputStream loadCSSfromClasspath(String string) {
        if (this.classLoader != null) {
            return this.classLoader.getResourceAsStream(BaseCSSStyleSheetFactory.resourcePath(BaseCSSStyleSheetFactory.class.getPackage().getName(), string));
        }
        return this.getClass().getResourceAsStream(string);
    }

    private static String resourcePath(String string, String string2) {
        return '/' + string.replace('.', '/') + '/' + string2;
    }

    @Override
    protected ValueFactory getValueFactory() {
        return new ValueFactory(this.flags);
    }

    @Override
    public void setFactoryFlag(byte by) {
        if (by < 3) {
            this.flags = (byte)(this.flags & 0x7C);
            this.flags = (byte)(this.flags | by);
        } else {
            this.flags = by = (byte)(by | this.flags & 3);
        }
    }

    @Override
    public void setLenientSystemValues(boolean bl) {
        this.lenientSystemValues = bl;
    }

    @Override
    public TypedValue getSystemDefaultValue(String string) {
        if (this.lenientSystemValues) {
            TypedValue typedValue = null;
            if ("color".equals(string = string.toLowerCase(Locale.ROOT)) || string.endsWith("-color")) {
                typedValue = (TypedValue)new ValueFactory().parseProperty("#000");
                ((ColorValue)typedValue).setSystemDefault();
                return typedValue;
            }
            if ("font-family".equals(string)) {
                typedValue = (TypedValue)new ValueFactory().parseProperty("serif");
                return new LenientSystemDefaultValue((CSSTypedValue)typedValue);
            }
        }
        return SystemDefaultValue.getInstance();
    }

    @Override
    protected Parser createSACParser() {
        CSSOMParser cSSOMParser = new CSSOMParser();
        EnumSet<Parser.Flag> enumSet = this.getParserFlags();
        for (Parser.Flag flag : enumSet) {
            cSSOMParser.setFlag(flag);
        }
        return cSSOMParser;
    }

    @Override
    protected EnumSet<Parser.Flag> getParserFlags() {
        return this.parserFlags;
    }

    @Override
    protected boolean hasCompatValueFlags() {
        EnumSet<Parser.Flag> enumSet = this.parserFlags;
        return enumSet.contains((Object)Parser.Flag.IEVALUES) || enumSet.contains((Object)Parser.Flag.IEPRIO) || enumSet.contains((Object)Parser.Flag.IEPRIOCHAR);
    }

    @Override
    public StyleDeclarationErrorHandler createInlineStyleErrorHandler(CSSElement cSSElement) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public StyleDeclarationErrorHandler createStyleDeclarationErrorHandler(CSSDeclarationRule cSSDeclarationRule) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public SheetErrorHandler createSheetErrorHandler(CSSStyleSheet<? extends CSSRule> cSSStyleSheet) {
        return new DefaultSheetErrorHandler(cSSStyleSheet);
    }

    @Override
    public MediaQueryList createMediaQueryList(String string, Node node) throws CSSBudgetException {
        if (string == null) {
            return new MediaQueryListImpl();
        }
        return this.parseMediaQueryList(string, node);
    }

    @Override
    public MediaQueryList createImmutableMediaQueryList(String string, Node node) throws CSSBudgetException {
        if (string == null) {
            return MediaQueryListImpl.createUnmodifiable();
        }
        return ((MediaListAccess)((Object)this.parseMediaQueryList(string, node))).unmodifiable();
    }

    MediaQueryList parseMediaQueryList(String string, Node node) throws CSSBudgetException {
        CSSOMParser cSSOMParser = new CSSOMParser();
        if (this.getParserFlags().contains((Object)Parser.Flag.IEVALUES)) {
            cSSOMParser.setFlag(Parser.Flag.IEVALUES);
        }
        return cSSOMParser.parseMediaQueryList(string, node);
    }

    @Override
    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }
}

