/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class BorderShorthandSetter
extends ShorthandSetter {
    BorderShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "border");
    }

    @Override
    public boolean assignSubproperties() {
        if (super.assignSubproperties()) {
            this.styleDeclaration.getShorthandSet().remove("border-image");
            return true;
        }
        return false;
    }

    @Override
    protected boolean assignSubproperty(String string) {
        if ("border-width".equals(string)) {
            if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers(string) || ValueFactory.isSizeSACUnit(this.currentValue)) {
                StyleValue styleValue = this.createCSSValue("border-width", this.currentValue);
                this.setSubpropertyValue(string, styleValue);
                this.nextCurrentValue();
                return true;
            }
        } else if ("border-style".equals(string)) {
            LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
            if (LexicalUnit.LexicalType.IDENT == lexicalType && this.testIdentifiers(string)) {
                StyleValue styleValue = this.createCSSValue("border-style", this.currentValue);
                this.setSubpropertyValue(string, styleValue);
                this.nextCurrentValue();
                return true;
            }
        } else if ("border-color".equals(string) && BaseCSSStyleDeclaration.testColor(this.currentValue)) {
            StyleValue styleValue = this.createCSSValue("border-color", this.currentValue);
            this.setSubpropertyValue(string, styleValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    @Override
    protected void setSubpropertyValue(String string, StyleValue styleValue) {
        String[] stringArray = this.getShorthandDatabase().getShorthandSubproperties(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                styleValue = styleValue.clone();
            }
            super.setSubpropertyValue(stringArray[i], styleValue);
        }
    }

    @Override
    protected void resetSubproperties() {
        super.resetSubproperties();
        this.setPropertyToDefault("border-image-source");
        this.setPropertyToDefault("border-image-slice");
        this.setPropertyToDefault("border-image-width");
        this.setPropertyToDefault("border-image-outset");
        this.setPropertyToDefault("border-image-repeat");
    }

    @Override
    protected void setSubpropertiesToKeyword(StyleValue styleValue) {
        super.setSubpropertiesToKeyword(styleValue);
        this.setProperty("border-image-source", styleValue, this.isPriorityImportant());
        this.setProperty("border-image-slice", styleValue, this.isPriorityImportant());
        this.setProperty("border-image-width", styleValue, this.isPriorityImportant());
        this.setProperty("border-image-outset", styleValue, this.isPriorityImportant());
        this.setProperty("border-image-repeat", styleValue, this.isPriorityImportant());
        this.flush();
    }
}

