/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.SimpleBoxModel;
import io.sf.carte.doc.style.css.property.NumberValue;

public class BoxModelHelper {
    public static String contractSpaces(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf("  ", n3)) != -1) {
            stringBuilder.append(string, n3, n2);
            n3 = n2;
            while (++n3 < n && string.charAt(n3) == ' ') {
            }
            --n3;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static float computeNodeMinimumWidth(String string, ComputedCSSStyle computedCSSStyle, CSSCanvas cSSCanvas, short s) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (BoxModelHelper.isSeparator(string.charAt(n5))) {
                n = cSSCanvas.stringWidth(string.substring(n4, n5), computedCSSStyle);
                if (n > n3) {
                    n3 = n;
                }
                n4 = n5;
                ++n4;
                while (n4 < n2 && BoxModelHelper.isSeparator(string.charAt(n4))) {
                    ++n4;
                }
                n5 = n4;
                continue;
            }
            ++n5;
        }
        if (n4 > 0) {
            n = cSSCanvas.stringWidth(string.substring(n4, n2), computedCSSStyle);
            if (n > n3) {
                n3 = n;
            }
        } else {
            n3 = cSSCanvas.stringWidth(string, computedCSSStyle);
        }
        return NumberValue.floatValueConversion(n3, (short)6, s);
    }

    public static float computeNodeMinimumWidth(String string, ComputedCSSStyle computedCSSStyle, short s) {
        float f = BoxModelHelper.computeMinimumCharsWidth(string);
        if (f == 0.0f) {
            return 0.0f;
        }
        if (computedCSSStyle.getStyleDatabase() == null) {
            if (s < 0) {
                throw new StyleDatabaseRequiredException();
            }
            f *= 0.5f * computedCSSStyle.getComputedFontSize();
        } else {
            if (s < 0) {
                s = computedCSSStyle.getStyleDatabase().getNaturalUnit();
            }
            f *= computedCSSStyle.getStyleDatabase().getExSizeInPt(computedCSSStyle.getUsedFontFamily(), computedCSSStyle.getComputedFontSize());
        }
        return NumberValue.floatValueConversion(f, (short)6, s);
    }

    public static int computeMinimumCharsWidth(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (BoxModelHelper.isSeparator(string.charAt(n4))) {
                int n5 = n4 - n3;
                if (n5 > n2) {
                    n2 = n5;
                }
                n3 = n4;
                ++n3;
                while (n3 < n && BoxModelHelper.isSeparator(string.charAt(n3))) {
                    ++n3;
                }
                n4 = n3;
                continue;
            }
            ++n4;
        }
        if (n3 > 0) {
            if (n - n3 > n2) {
                n2 = n - n3;
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    private static boolean isSeparator(char c) {
        return Character.isWhitespace(c);
    }

    public static float computeTextWidth(String string, ComputedCSSStyle computedCSSStyle, short s) {
        float f = string.length();
        if (f == 0.0f) {
            return 0.0f;
        }
        if (computedCSSStyle.getStyleDatabase() == null) {
            if (s < 0) {
                throw new StyleDatabaseRequiredException();
            }
            f *= 0.5f * computedCSSStyle.getComputedFontSize();
        } else {
            if (s < 0) {
                s = computedCSSStyle.getStyleDatabase().getNaturalUnit();
            }
            f *= computedCSSStyle.getStyleDatabase().getExSizeInPt(computedCSSStyle.getUsedFontFamily(), computedCSSStyle.getComputedFontSize());
        }
        return NumberValue.floatValueConversion(f, (short)6, s);
    }

    static void shrinkTo(SimpleBoxModel.MyTableBoxValues myTableBoxValues, float[] fArray, float f, float f2, float f3) {
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(myTableBoxValues.colwidth[i] > fArray[i])) continue;
            ++n;
        }
        if (n == 0) {
            return;
        }
        float f4 = f2 - f3;
        float f5 = f4 / (float)n;
        float f6 = 0.0f;
        f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f7 = myTableBoxValues.colwidth[i];
            if (f7 > fArray[i]) {
                if ((f7 -= f5) < fArray[i]) {
                    f7 = fArray[i];
                }
                f6 += myTableBoxValues.colwidth[i] - f7;
                myTableBoxValues.colwidth[i] = f7;
            }
            f2 += f7;
        }
        if (Math.abs(f4 - f6) > 0.1f) {
            BoxModelHelper.shrinkTo(myTableBoxValues, fArray, f, f2, f3);
        }
    }
}

