/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.ArrayStringList;
import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.CSSFontFeatureValuesMap;
import io.sf.carte.doc.style.css.CSSFontFeatureValuesRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSParentHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CommentRemover;
import io.sf.carte.doc.style.css.parser.EmptyCSSHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.dom.DOMException;

public class FontFeatureValuesRule
extends BaseCSSRule
implements CSSFontFeatureValuesRule {
    private static final long serialVersionUID = 1L;
    private String[] fontFamily = null;
    private CSSFontFeatureValuesMapImpl annotation = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl ornaments = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl stylistic = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl swash = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl characterVariant = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl styleset = new CSSFontFeatureValuesMapImpl();
    private HashMap<String, CSSFontFeatureValuesMapImpl> mapmap = null;

    protected FontFeatureValuesRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)14, by);
    }

    @Override
    public String[] getFontFamily() {
        return this.fontFamily;
    }

    void setFontFamily(String[] stringArray) {
        this.fontFamily = stringArray;
    }

    @Override
    public CSSFontFeatureValuesMap getAnnotation() {
        return this.annotation;
    }

    @Override
    public CSSFontFeatureValuesMap getOrnaments() {
        return this.ornaments;
    }

    @Override
    public CSSFontFeatureValuesMap getStylistic() {
        return this.stylistic;
    }

    @Override
    public CSSFontFeatureValuesMap getSwash() {
        return this.swash;
    }

    @Override
    public CSSFontFeatureValuesMap getCharacterVariant() {
        return this.characterVariant;
    }

    @Override
    public CSSFontFeatureValuesMap getStyleset() {
        return this.styleset;
    }

    @Override
    public void enableMap(String string) {
        string = string.toLowerCase(Locale.ROOT);
        FontFeatureValuesRule.enableMap(string, this.mapmap);
    }

    private static void enableMap(String string, HashMap<String, CSSFontFeatureValuesMapImpl> hashMap) {
        if (!(string.equals("annotation") || string.equals("ornaments") || string.equals("stylistic") || string.equals("swash") || string.equals("character-variant") || string.equals("styleset"))) {
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            hashMap.put(string, new CSSFontFeatureValuesMapImpl());
        }
    }

    @Override
    public CSSFontFeatureValuesMap getFeatureValuesMap(String string) {
        Object object = (string = string.toLowerCase(Locale.ROOT)).equals("annotation") ? this.annotation : (string.equals("ornaments") ? this.ornaments : (string.equals("stylistic") ? this.stylistic : (string.equals("swash") ? this.swash : (string.equals("character-variant") ? this.characterVariant : (string.equals("styleset") ? this.styleset : (this.mapmap == null ? null : (CSSFontFeatureValuesMap)this.mapmap.get(string)))))));
        return object;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(256);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.fontFamily == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("@font-feature-values ");
        stringBuilder.append(this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            stringBuilder.append(',').append(this.fontFamily[i]);
        }
        stringBuilder.append('{');
        if (!this.swash.isEmpty()) {
            stringBuilder.append("@swash{");
            this.appendMinifiedFeatureString(stringBuilder, this.swash);
            stringBuilder.append('}');
        }
        if (!this.annotation.isEmpty()) {
            stringBuilder.append("@annotation{");
            this.appendMinifiedFeatureString(stringBuilder, this.annotation);
            stringBuilder.append('}');
        }
        if (!this.ornaments.isEmpty()) {
            stringBuilder.append("@ornaments{");
            this.appendMinifiedFeatureString(stringBuilder, this.ornaments);
            stringBuilder.append('}');
        }
        if (!this.stylistic.isEmpty()) {
            stringBuilder.append("@stylistic{");
            this.appendMinifiedFeatureString(stringBuilder, this.stylistic);
            stringBuilder.append('}');
        }
        if (!this.styleset.isEmpty()) {
            stringBuilder.append("@styleset{");
            this.appendMinifiedFeatureString(stringBuilder, this.styleset);
            stringBuilder.append('}');
        }
        if (!this.characterVariant.isEmpty()) {
            stringBuilder.append("@character-variant{");
            this.appendMinifiedFeatureString(stringBuilder, this.characterVariant);
            stringBuilder.append('}');
        }
        if (this.mapmap != null) {
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> entry : this.mapmap.entrySet()) {
                stringBuilder.append('@').append(entry.getKey()).append('{');
                this.appendMinifiedFeatureString(stringBuilder, entry.getValue());
                stringBuilder.append('}');
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void appendMinifiedFeatureString(StringBuilder stringBuilder, CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl) {
        int n = cSSFontFeatureValuesMapImpl.featureMap.size() - 1;
        String[] stringArray = cSSFontFeatureValuesMapImpl.featureMap.keySet().toArray(new String[0]);
        for (int i = 0; i <= n; ++i) {
            String string = stringArray[i];
            stringBuilder.append(string).append(':');
            PrimitiveValue[] primitiveValueArray = (PrimitiveValue[])cSSFontFeatureValuesMapImpl.featureMap.get(string);
            stringBuilder.append(primitiveValueArray[0].getMinifiedCssText(string));
            for (int j = 1; j < primitiveValueArray.length; ++j) {
                stringBuilder.append(' ').append(primitiveValueArray[j].getMinifiedCssText(string));
            }
            if (i == n) continue;
            stringBuilder.append(';');
        }
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        if (this.fontFamily == null) {
            return;
        }
        styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
        simpleWriter.write((CharSequence)"@font-feature-values ");
        FontFeatureValuesRule.writeFontFamily(simpleWriter, this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            styleFormattingContext.writeComma(simpleWriter);
            FontFeatureValuesRule.writeFontFamily(simpleWriter, this.fontFamily[i]);
        }
        styleFormattingContext.updateContext(this);
        styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
        this.writeFeatureBlock(simpleWriter, styleFormattingContext, "@swash", this.swash);
        this.writeFeatureBlock(simpleWriter, styleFormattingContext, "@annotation", this.annotation);
        this.writeFeatureBlock(simpleWriter, styleFormattingContext, "@ornaments", this.ornaments);
        this.writeFeatureBlock(simpleWriter, styleFormattingContext, "@stylistic", this.stylistic);
        this.writeFeatureBlock(simpleWriter, styleFormattingContext, "@styleset", this.styleset);
        this.writeFeatureBlock(simpleWriter, styleFormattingContext, "@character-variant", this.characterVariant);
        if (this.mapmap != null) {
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> entry : this.mapmap.entrySet()) {
                CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl = entry.getValue();
                styleFormattingContext.startRule(simpleWriter, cSSFontFeatureValuesMapImpl.precedingComments);
                simpleWriter.write('@');
                simpleWriter.write((CharSequence)entry.getKey());
                styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
                this.appendFeatureString(simpleWriter, styleFormattingContext, cSSFontFeatureValuesMapImpl);
                styleFormattingContext.writeRightCurlyBracket(simpleWriter);
                styleFormattingContext.endRule(simpleWriter, cSSFontFeatureValuesMapImpl.trailingComments);
            }
        }
        styleFormattingContext.endCurrentContext(this);
        styleFormattingContext.writeRightCurlyBracket(simpleWriter);
        styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
    }

    private static void writeFontFamily(SimpleWriter simpleWriter, String string) throws IOException {
        if (string.indexOf(32) == -1) {
            simpleWriter.write((CharSequence)string);
        } else {
            simpleWriter.write('\'');
            simpleWriter.write((CharSequence)string);
            simpleWriter.write('\'');
        }
    }

    private void writeFeatureBlock(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl) throws IOException {
        if (!cSSFontFeatureValuesMapImpl.isEmpty()) {
            styleFormattingContext.startRule(simpleWriter, cSSFontFeatureValuesMapImpl.precedingComments);
            simpleWriter.write((CharSequence)string);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            this.appendFeatureString(simpleWriter, styleFormattingContext, cSSFontFeatureValuesMapImpl);
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, cSSFontFeatureValuesMapImpl.trailingComments);
        }
    }

    private void appendFeatureString(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl) throws IOException {
        styleFormattingContext.deepenCurrentContext();
        styleFormattingContext.startStyleDeclaration(simpleWriter);
        for (Map.Entry entry : cSSFontFeatureValuesMapImpl.featureMap.entrySet()) {
            styleFormattingContext.startPropertyDeclaration(simpleWriter);
            simpleWriter.write((CharSequence)entry.getKey());
            styleFormattingContext.writeColon(simpleWriter);
            PrimitiveValue[] primitiveValueArray = (PrimitiveValue[])entry.getValue();
            primitiveValueArray[0].writeCssText(simpleWriter);
            for (int i = 1; i < primitiveValueArray.length; ++i) {
                simpleWriter.write(' ');
                primitiveValueArray[i].writeCssText(simpleWriter);
            }
            styleFormattingContext.writeSemiColon(simpleWriter);
            styleFormattingContext.endPropertyDeclaration(simpleWriter);
        }
        styleFormattingContext.updateContext(this);
        styleFormattingContext.endStyleDeclaration(simpleWriter);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        string = string.trim();
        int n = string.length();
        int n2 = string.indexOf(64);
        if (n < 24 || n2 == -1) {
            throw new DOMException(12, "Invalid @font-feature-values rule: " + string);
        }
        String string2 = CommentRemover.removeComments(string).toString().trim();
        CharSequence charSequence = string2.subSequence(0, 21);
        if (!ParseHelper.startsWithIgnoreCase(charSequence, "@font-feature-values") || !Character.isWhitespace(charSequence.charAt(20))) {
            throw new DOMException(13, "Not a @font-feature-values rule: " + string);
        }
        String string3 = string.substring(n2 + 21);
        MyFontFeatureValuesHandler myFontFeatureValuesHandler = new MyFontFeatureValuesHandler();
        CSSParser cSSParser = (CSSParser)this.createSACParser();
        cSSParser.setDocumentHandler(myFontFeatureValuesHandler);
        try {
            cSSParser.parseFontFeatureValuesBody(string3);
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(5, "Parse error at [" + cSSParseException.getLineNumber() + ',' + cSSParseException.getColumnNumber() + "]: " + cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
    }

    @Override
    void clear() {
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        this.setPrecedingComments(abstractCSSRule.getPrecedingComments());
        this.setTrailingComments(abstractCSSRule.getTrailingComments());
        FontFeatureValuesRule fontFeatureValuesRule = (FontFeatureValuesRule)abstractCSSRule;
        this.fontFamily = fontFeatureValuesRule.fontFamily;
        this.annotation = fontFeatureValuesRule.annotation;
        this.ornaments = fontFeatureValuesRule.ornaments;
        this.stylistic = fontFeatureValuesRule.stylistic;
        this.swash = fontFeatureValuesRule.swash;
        this.styleset = fontFeatureValuesRule.styleset;
        this.characterVariant = fontFeatureValuesRule.characterVariant;
        this.mapmap = fontFeatureValuesRule.mapmap;
    }

    CSSHandler createFontFeatureValuesHandler(CSSParentHandler cSSParentHandler, ParserControl parserControl) {
        return new MyFontFeatureValuesHandler(cSSParentHandler, parserControl);
    }

    public int hashCode() {
        int n = 31;
        int n2 = this.annotation == null ? 0 : this.annotation.hashCode();
        n2 = 31 * n2 + (this.characterVariant == null ? 0 : this.characterVariant.hashCode());
        n2 = 31 * n2 + Arrays.hashCode(this.fontFamily);
        n2 = 31 * n2 + (this.mapmap == null ? 0 : this.mapmap.hashCode());
        n2 = 31 * n2 + (this.ornaments == null ? 0 : this.ornaments.hashCode());
        n2 = 31 * n2 + (this.styleset == null ? 0 : this.styleset.hashCode());
        n2 = 31 * n2 + (this.stylistic == null ? 0 : this.stylistic.hashCode());
        n2 = 31 * n2 + (this.swash == null ? 0 : this.swash.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FontFeatureValuesRule fontFeatureValuesRule = (FontFeatureValuesRule)object;
        if (this.annotation == null ? fontFeatureValuesRule.annotation != null : !this.annotation.equals(fontFeatureValuesRule.annotation)) {
            return false;
        }
        if (this.characterVariant == null ? fontFeatureValuesRule.characterVariant != null : !this.characterVariant.equals(fontFeatureValuesRule.characterVariant)) {
            return false;
        }
        if (!Arrays.equals(this.fontFamily, fontFeatureValuesRule.fontFamily)) {
            return false;
        }
        if (this.mapmap == null ? fontFeatureValuesRule.mapmap != null : !this.mapmap.equals(fontFeatureValuesRule.mapmap)) {
            return false;
        }
        if (this.ornaments == null ? fontFeatureValuesRule.ornaments != null : !this.ornaments.equals(fontFeatureValuesRule.ornaments)) {
            return false;
        }
        if (this.styleset == null ? fontFeatureValuesRule.styleset != null : !this.styleset.equals(fontFeatureValuesRule.styleset)) {
            return false;
        }
        if (this.stylistic == null ? fontFeatureValuesRule.stylistic != null : !this.stylistic.equals(fontFeatureValuesRule.stylistic)) {
            return false;
        }
        return !(this.swash == null ? fontFeatureValuesRule.swash != null : !this.swash.equals(fontFeatureValuesRule.swash));
    }

    @Override
    public FontFeatureValuesRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        FontFeatureValuesRule fontFeatureValuesRule = new FontFeatureValuesRule(abstractCSSStyleSheet, this.getOrigin());
        fontFeatureValuesRule.fontFamily = this.fontFamily;
        fontFeatureValuesRule.annotation = this.annotation;
        fontFeatureValuesRule.ornaments = this.ornaments;
        fontFeatureValuesRule.stylistic = this.stylistic;
        fontFeatureValuesRule.swash = this.swash;
        fontFeatureValuesRule.styleset = this.styleset;
        fontFeatureValuesRule.characterVariant = this.characterVariant;
        fontFeatureValuesRule.mapmap = this.deepClone(this.mapmap);
        return fontFeatureValuesRule;
    }

    private HashMap<String, CSSFontFeatureValuesMapImpl> deepClone(HashMap<String, CSSFontFeatureValuesMapImpl> hashMap) {
        HashMap<String, CSSFontFeatureValuesMapImpl> hashMap2 = null;
        if (hashMap != null) {
            hashMap2 = new HashMap<String, CSSFontFeatureValuesMapImpl>(hashMap.size());
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> entry : hashMap.entrySet()) {
                CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl = entry.getValue();
                if (cSSFontFeatureValuesMapImpl != null) {
                    cSSFontFeatureValuesMapImpl = cSSFontFeatureValuesMapImpl.clone();
                }
                hashMap2.put(entry.getKey(), cSSFontFeatureValuesMapImpl);
            }
        }
        return hashMap2;
    }

    static /* synthetic */ String[] access$502(FontFeatureValuesRule fontFeatureValuesRule, String[] stringArray) {
        fontFeatureValuesRule.fontFamily = stringArray;
        return stringArray;
    }

    private static class CSSFontFeatureValuesMapImpl
    implements CSSFontFeatureValuesMap,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final LinkedHashMap<String, PrimitiveValue[]> featureMap = new LinkedHashMap();
        private StringList precedingComments = null;
        private StringList trailingComments = null;

        CSSFontFeatureValuesMapImpl() {
        }

        CSSFontFeatureValuesMapImpl(CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl) {
            this.setPrecedingComments(cSSFontFeatureValuesMapImpl.precedingComments);
            this.trailingComments = cSSFontFeatureValuesMapImpl.trailingComments;
        }

        void addAll(CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl) {
            this.featureMap.putAll(cSSFontFeatureValuesMapImpl.featureMap);
        }

        void clear() {
            this.featureMap.clear();
        }

        @Override
        public PrimitiveValue[] get(String string) {
            return this.featureMap.get(string);
        }

        @Override
        public void set(String string, PrimitiveValue ... primitiveValueArray) {
            if (primitiveValueArray == null) {
                throw new DOMException(12, "Must provide at least one value");
            }
            for (PrimitiveValue primitiveValue : primitiveValueArray) {
                if (primitiveValue == null) {
                    throw new DOMException(12, "Null value supplied.");
                }
                primitiveValue.setExpectInteger();
            }
            this.featureMap.put(string, primitiveValueArray);
        }

        public boolean isEmpty() {
            return this.featureMap.isEmpty();
        }

        void setPrecedingComments(StringList stringList) {
            this.precedingComments = stringList;
        }

        void setTrailingComments(StringList stringList) {
            this.trailingComments = stringList;
        }

        @Override
        public StringList getPrecedingComments() {
            return this.precedingComments;
        }

        @Override
        public StringList getTrailingComments() {
            return this.trailingComments;
        }

        public int hashCode() {
            int n = 31;
            if (this.featureMap == null) {
                return 0;
            }
            int n2 = 1;
            TreeSet<String> treeSet = new TreeSet<String>(this.featureMap.keySet());
            for (String string : treeSet) {
                n2 = 31 * n2 + string.hashCode();
                n2 = 31 * n2 + Arrays.hashCode(this.featureMap.get(string));
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl = (CSSFontFeatureValuesMapImpl)object;
            if (this.featureMap == null) {
                if (cSSFontFeatureValuesMapImpl.featureMap != null) {
                    return false;
                }
            } else {
                if (cSSFontFeatureValuesMapImpl.featureMap == null || this.featureMap.size() != cSSFontFeatureValuesMapImpl.featureMap.size()) {
                    return false;
                }
                for (Map.Entry<String, PrimitiveValue[]> entry : this.featureMap.entrySet()) {
                    String string = entry.getKey();
                    Object[] objectArray = entry.getValue();
                    Object[] objectArray2 = cSSFontFeatureValuesMapImpl.featureMap.get(string);
                    if (objectArray2 != null && Arrays.equals(objectArray, objectArray2)) continue;
                    return false;
                }
            }
            return true;
        }

        public CSSFontFeatureValuesMapImpl clone() {
            return new CSSFontFeatureValuesMapImpl(this);
        }
    }

    private class MyFontFeatureValuesHandler
    extends EmptyCSSHandler {
        private String[] fontFamily = null;
        private final CSSFontFeatureValuesMapImpl annotation = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl ornaments = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl stylistic = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl swash = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl characterVariant = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl styleset = new CSSFontFeatureValuesMapImpl();
        private final HashMap<String, CSSFontFeatureValuesMapImpl> mapmap = null;
        private CSSFontFeatureValuesMapImpl currentMap = null;
        private CSSFontFeatureValuesMapImpl lastMap = null;
        private LinkedList<String> comments = null;
        private final CSSParentHandler parentHandler;
        private final ParserControl parserctl;

        private MyFontFeatureValuesHandler() {
            this(null, null);
        }

        private MyFontFeatureValuesHandler(CSSParentHandler cSSParentHandler, ParserControl parserControl) {
            this.parentHandler = cSSParentHandler;
            this.parserctl = parserControl;
        }

        @Override
        public void startFontFeatures(String[] stringArray) {
            this.fontFamily = stringArray;
        }

        @Override
        public void endFontFeatures() {
            if (this.fontFamily != null) {
                FontFeatureValuesRule.access$502(FontFeatureValuesRule.this, this.fontFamily);
                FontFeatureValuesRule.this.annotation.clear();
                FontFeatureValuesRule.this.ornaments.clear();
                FontFeatureValuesRule.this.stylistic.clear();
                FontFeatureValuesRule.this.swash.clear();
                FontFeatureValuesRule.this.characterVariant.clear();
                FontFeatureValuesRule.this.styleset.clear();
                FontFeatureValuesRule.this.annotation.addAll(this.annotation);
                FontFeatureValuesRule.this.ornaments.addAll(this.ornaments);
                FontFeatureValuesRule.this.stylistic.addAll(this.stylistic);
                FontFeatureValuesRule.this.swash.addAll(this.swash);
                FontFeatureValuesRule.this.characterVariant.addAll(this.characterVariant);
                FontFeatureValuesRule.this.styleset.addAll(this.styleset);
                FontFeatureValuesRule.this.mapmap = this.mapmap;
                FontFeatureValuesRule.this.annotation.setPrecedingComments(this.annotation.getPrecedingComments());
                FontFeatureValuesRule.this.ornaments.setPrecedingComments(this.ornaments.getPrecedingComments());
                FontFeatureValuesRule.this.stylistic.setPrecedingComments(this.stylistic.getPrecedingComments());
                FontFeatureValuesRule.this.swash.setPrecedingComments(this.swash.getPrecedingComments());
                FontFeatureValuesRule.this.characterVariant.setPrecedingComments(this.characterVariant.getPrecedingComments());
                FontFeatureValuesRule.this.styleset.setPrecedingComments(this.styleset.getPrecedingComments());
                FontFeatureValuesRule.this.annotation.setTrailingComments(this.annotation.getTrailingComments());
                FontFeatureValuesRule.this.ornaments.setTrailingComments(this.ornaments.getTrailingComments());
                FontFeatureValuesRule.this.stylistic.setTrailingComments(this.stylistic.getTrailingComments());
                FontFeatureValuesRule.this.swash.setTrailingComments(this.swash.getTrailingComments());
                FontFeatureValuesRule.this.characterVariant.setTrailingComments(this.characterVariant.getTrailingComments());
                FontFeatureValuesRule.this.styleset.setTrailingComments(this.styleset.getTrailingComments());
            }
            if (this.parentHandler != null) {
                this.parentHandler.endSubHandler((short)14);
            }
        }

        @Override
        public void startFeatureMap(String string) {
            string = string.toLowerCase(Locale.ROOT);
            this.enableMap(string);
            this.currentMap = this.getFeatureValuesMap(string);
        }

        private void enableMap(String string) {
            FontFeatureValuesRule.enableMap(string, this.mapmap);
            this.lastMap = null;
        }

        private CSSFontFeatureValuesMapImpl getFeatureValuesMap(String string) {
            CSSFontFeatureValuesMapImpl cSSFontFeatureValuesMapImpl;
            if (string.equals("annotation")) {
                cSSFontFeatureValuesMapImpl = this.annotation;
            } else if (string.equals("ornaments")) {
                cSSFontFeatureValuesMapImpl = this.ornaments;
            } else if (string.equals("stylistic")) {
                cSSFontFeatureValuesMapImpl = this.stylistic;
            } else if (string.equals("swash")) {
                cSSFontFeatureValuesMapImpl = this.swash;
            } else if (string.equals("character-variant")) {
                cSSFontFeatureValuesMapImpl = this.characterVariant;
            } else if (string.equals("styleset")) {
                cSSFontFeatureValuesMapImpl = this.styleset;
            } else if (this.mapmap == null) {
                cSSFontFeatureValuesMapImpl = null;
            } else {
                cSSFontFeatureValuesMapImpl = this.mapmap.get(string);
                cSSFontFeatureValuesMapImpl.precedingComments = null;
            }
            return cSSFontFeatureValuesMapImpl;
        }

        @Override
        public void endFeatureMap() {
            this.setCommentsToCurrentMap();
            this.lastMap = this.currentMap;
            this.currentMap = null;
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            PrimitiveValue[] primitiveValueArray;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (lexicalUnit != null) {
                Serializable serializable;
                Object object;
                primitiveValueArray = lexicalUnit.getLexicalUnitType();
                if (primitiveValueArray == LexicalUnit.LexicalType.INTEGER) {
                    object = new NumberValue();
                    int n = lexicalUnit.getIntegerValue();
                    ((NumberValue)object).setIntegerValue(n);
                    linkedList.add(object);
                } else if (primitiveValueArray == LexicalUnit.LexicalType.VAR || primitiveValueArray == LexicalUnit.LexicalType.CALC) {
                    object = new ValueFactory();
                    StyleValue styleValue = ((ValueFactory)object).createCSSValue(lexicalUnit);
                    serializable = (PrimitiveValue)styleValue;
                    serializable.setExpectInteger();
                    linkedList.add(serializable);
                } else {
                    object = "Found non-integer value: " + lexicalUnit.toString();
                    if (this.parserctl != null) {
                        Locator locator = this.parserctl.createLocator();
                        serializable = new CSSParseException((String)object, locator);
                        this.parserctl.getErrorHandler().error((CSSParseException)serializable);
                    } else {
                        throw new CSSException((String)object);
                    }
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
            primitiveValueArray = new PrimitiveValue[linkedList.size()];
            for (int i = 0; i < primitiveValueArray.length; ++i) {
                primitiveValueArray[i] = (PrimitiveValue)linkedList.get(i);
            }
            this.currentMap.set(string, primitiveValueArray);
        }

        @Override
        public void comment(String string, boolean bl) {
            if (this.lastMap != null && !bl) {
                if (this.lastMap.trailingComments == null) {
                    this.lastMap.trailingComments = new LinkedStringList();
                }
                this.lastMap.trailingComments.add(string);
            } else if (this.currentMap == null) {
                if (this.comments == null) {
                    this.comments = new LinkedStringList();
                }
                this.comments.add(string);
            }
        }

        private void setCommentsToCurrentMap() {
            if (this.comments != null && !this.comments.isEmpty()) {
                ArrayStringList arrayStringList = new ArrayStringList(this.comments.size());
                arrayStringList.addAll(this.comments);
                this.currentMap.setPrecedingComments(arrayStringList);
            }
            this.resetCommentStack();
        }

        private void resetCommentStack() {
            if (this.comments != null) {
                this.comments.clear();
            }
        }
    }
}

