/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSMediaRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.DOMException;

public class MediaRule
extends GroupingRule
implements CSSMediaRule {
    private static final long serialVersionUID = 1L;
    private MediaQueryList mediaList = null;

    protected MediaRule(AbstractCSSStyleSheet abstractCSSStyleSheet, MediaQueryList mediaQueryList, byte by) {
        super(abstractCSSStyleSheet, (short)4, by);
        this.mediaList = mediaQueryList;
    }

    MediaRule(AbstractCSSStyleSheet abstractCSSStyleSheet, MediaRule mediaRule) {
        super(abstractCSSStyleSheet, mediaRule);
        this.mediaList = ((MediaListAccess)((Object)mediaRule.getMedia())).unmodifiable();
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(64 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 36);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder stringBuilder = new StringBuilder(30 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 20);
        stringBuilder.append("@media");
        if (!this.mediaList.isAllMedia()) {
            stringBuilder.append(' ').append(this.mediaList.getMinifiedMedia());
        }
        stringBuilder.append("{");
        Iterator iterator = ((ArrayList)((Object)this.getCssRules())).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((AbstractCSSRule)iterator.next()).getMinifiedCssText());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
        simpleWriter.write((CharSequence)"@media");
        if (!this.mediaList.isAllMedia()) {
            simpleWriter.write(' ');
            simpleWriter.write((CharSequence)this.mediaList.getMediaText());
        }
        styleFormattingContext.updateContext(this);
        styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
        ((CSSRuleArrayList)this.getCssRules()).writeCssText(simpleWriter, styleFormattingContext);
        styleFormattingContext.endCurrentContext(this);
        styleFormattingContext.endRuleList(simpleWriter);
        styleFormattingContext.writeRightCurlyBracket(simpleWriter);
        styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
    }

    @Override
    protected void setGroupingRule(GroupingRule groupingRule) throws DOMException {
        MediaRule mediaRule = (MediaRule)groupingRule;
        this.mediaList = mediaRule.mediaList;
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return super.hasErrorsOrWarnings() || this.mediaList != null && this.mediaList.hasErrors();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.mediaList == null ? 0 : this.mediaList.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MediaRule mediaRule = (MediaRule)object;
        return !(this.mediaList == null ? mediaRule.mediaList != null : !this.mediaList.equals(mediaRule.mediaList));
    }

    @Override
    public MediaRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        return new MediaRule(abstractCSSStyleSheet, this);
    }
}

