/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LinkStyle;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.DOMNode;
import io.sf.carte.doc.style.css.om.DOMUtil;
import io.sf.carte.doc.style.css.om.DefaultErrorHandler;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.StyleSheetList;
import io.sf.carte.doc.style.css.om.WrapperSelectorMatcher;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public abstract class StylableDocumentWrapper
extends DOMNode
implements CSSDocument {
    private final Document document;
    private final Map<Node, CSSNode> nodemap = new HashMap<Node, CSSNode>();
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    Set<LinkStyleDefiner> linkedStyle = new LinkedHashSet<LinkStyleDefiner>(4);
    Set<LinkStyleDefiner> embeddedStyle = new LinkedHashSet<LinkStyleDefiner>(3);
    private Set<CSSPropertyDefinition> registeredPropertySet = null;
    private final StyleSheetList sheets = new MyOMStyleSheetList(7);
    private final ErrorHandler errorHandler = this.createErrorHandler();
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private final Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    protected StylableDocumentWrapper(Document document) {
        super(document);
        this.document = document;
        this.updateStyleLists();
    }

    protected abstract DOMCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public String getCompatMode() {
        DocumentType documentType = this.document.getDoctype();
        if (documentType != null) {
            return "CSS1Compat";
        }
        return "BackCompat";
    }

    @Override
    public CSSDocument.ComplianceMode getComplianceMode() {
        DocumentType documentType = this.document.getDoctype();
        if (documentType != null) {
            return CSSDocument.ComplianceMode.STRICT;
        }
        return CSSDocument.ComplianceMode.QUIRKS;
    }

    @Override
    public CSSDocument getOwnerDocument() {
        return null;
    }

    @Override
    protected CSSNode getMappedCSSNode(Node node) {
        return this.nodemap.get(node);
    }

    @Override
    protected CSSNode getCSSNode(Node node) {
        CSSNode cSSNode = this.getMappedCSSNode(node);
        if (cSSNode == null) {
            switch (node.getNodeType()) {
                case 2: {
                    String string = node.getNodeName();
                    if ("style".equalsIgnoreCase(string) && node.getPrefix() == null) {
                        cSSNode = new StyleAttr((Attr)node);
                        break;
                    }
                    Element element = ((Attr)node).getOwnerElement();
                    if (element != null && node.getPrefix() == null) {
                        String string2 = element.getTagName();
                        if (("link".equalsIgnoreCase(string2) || "style".equalsIgnoreCase(string2)) && ("href".equalsIgnoreCase(string) || "media".equalsIgnoreCase(string) || "title".equalsIgnoreCase(string) || "rel".equalsIgnoreCase(string) || "type".equalsIgnoreCase(string))) {
                            cSSNode = new StyleEventAttr((Attr)node);
                            break;
                        }
                        if ("meta".equalsIgnoreCase(string2) && ("http-equiv".equalsIgnoreCase(string) || "content".equalsIgnoreCase(string))) {
                            cSSNode = new EventAttr((Attr)node);
                            break;
                        }
                        cSSNode = new MyAttr((Attr)node);
                        break;
                    }
                    cSSNode = new MyAttr((Attr)node);
                    break;
                }
                case 1: {
                    Element element = (Element)node;
                    String string = element.getNodeName();
                    if (string != null) {
                        if ("link".equals(string = string.toLowerCase(Locale.ROOT))) {
                            cSSNode = new LinkElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                        if ("style".equals(string)) {
                            cSSNode = new StyleElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                    }
                    cSSNode = new MyElement((Element)node);
                    break;
                }
                case 3: {
                    cSSNode = new MyText((Text)node);
                    break;
                }
                case 4: {
                    cSSNode = new MyCDATASection((CDATASection)node);
                    break;
                }
                case 8: {
                    cSSNode = new MyComment((Comment)node);
                    break;
                }
                case 10: {
                    cSSNode = new MyDocumentType((DocumentType)node);
                    break;
                }
                case 7: {
                    if ("xml-stylesheet".equals(node.getNodeName())) {
                        cSSNode = new MyStyleProcessingInstruction((ProcessingInstruction)node);
                        this.onStyleModify();
                        break;
                    }
                    cSSNode = new MyProcessingInstruction((ProcessingInstruction)node);
                    break;
                }
                case 5: {
                    cSSNode = new MyEntityReference((EntityReference)node);
                    break;
                }
                default: {
                    cSSNode = new MyNode(node);
                }
            }
            this.nodemap.put(node, cSSNode);
        }
        return cSSNode;
    }

    @Override
    public DocumentType getDoctype() {
        DocumentType documentType = this.document.getDoctype();
        return documentType != null ? (DocumentType)((Object)this.getCSSNode(documentType)) : null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public boolean isVisitedURI(String string) {
        return false;
    }

    public abstract void setLoadingTime(long var1);

    @Override
    public CSSElement getDocumentElement() {
        Element element = this.document.getDocumentElement();
        return element != null ? (CSSElement)this.getCSSNode(element) : null;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(CSSElement cSSElement) {
        LinkStyleDefiner linkStyleDefiner = null;
        if (cSSElement != null && (linkStyleDefiner = this.getEmbeddedStyleDefiner(cSSElement.getId())) == null && cSSElement instanceof LinkStyleDefiner) {
            linkStyleDefiner = (LinkStyleDefiner)((Object)cSSElement);
        }
        return linkStyleDefiner;
    }

    private static String escapeAttributeEntities(String string) {
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder = StylableDocumentWrapper.appendEntityToBuffer(stringBuilder, "lt", string, i, n);
                continue;
            }
            if (c == '>') {
                stringBuilder = StylableDocumentWrapper.appendEntityToBuffer(stringBuilder, "gt", string, i, n);
                continue;
            }
            if (c == '&') {
                stringBuilder = StylableDocumentWrapper.appendEntityToBuffer(stringBuilder, "amp", string, i, n);
                continue;
            }
            if (c == '\"') {
                stringBuilder = StylableDocumentWrapper.appendEntityToBuffer(stringBuilder, "quot", string, i, n);
                continue;
            }
            if (c == '\u00a0') {
                stringBuilder = StylableDocumentWrapper.appendEntityToBuffer(stringBuilder, "nbsp", string, i, n);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    private static StringBuilder appendEntityToBuffer(StringBuilder stringBuilder, String string, String string2, int n, int n2) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(n2 + string.length() + 2);
            stringBuilder.append(string2.subSequence(0, n));
        }
        stringBuilder.append('&').append(string).append(';');
        return stringBuilder;
    }

    private MediaQueryList parseMediaList(String string, Node node) throws CSSMediaException {
        MediaQueryList mediaQueryList;
        if (string.length() == 0) {
            mediaQueryList = new MediaQueryListImpl().unmodifiable();
        } else {
            try {
                mediaQueryList = this.getStyleSheetFactory().createImmutableMediaQueryList(string, node);
            }
            catch (CSSBudgetException cSSBudgetException) {
                throw new CSSMediaException(cSSBudgetException);
            }
            if (mediaQueryList.isNotAllMedia() && mediaQueryList.hasErrors()) {
                return null;
            }
        }
        return mediaQueryList;
    }

    private AbstractCSSStyleSheet parseEmbeddedStyleSheet(AbstractCSSStyleSheet abstractCSSStyleSheet, String string, String string2, String string3, Node node) {
        MediaQueryList mediaQueryList;
        try {
            mediaQueryList = this.parseMediaList(string3.trim(), node);
        }
        catch (CSSMediaException cSSMediaException) {
            this.getErrorHandler().mediaQueryError(node, cSSMediaException);
            mediaQueryList = null;
        }
        if (mediaQueryList != null) {
            if (abstractCSSStyleSheet == null) {
                abstractCSSStyleSheet = this.getStyleSheetFactory().createLinkedStyleSheet(node, string2, mediaQueryList);
            } else {
                abstractCSSStyleSheet.getCssRules().clear();
                abstractCSSStyleSheet.setTitle(string2);
                abstractCSSStyleSheet.setMedia(mediaQueryList);
            }
            if (string.length() != 0) {
                abstractCSSStyleSheet.setHref(this.getBaseURI());
                StringReader stringReader = new StringReader(string);
                try {
                    abstractCSSStyleSheet.parseStyleSheet(stringReader);
                }
                catch (Exception exception) {
                    this.getErrorHandler().linkedSheetError(exception, abstractCSSStyleSheet);
                }
            } else {
                abstractCSSStyleSheet.getCssRules().clear();
            }
            return abstractCSSStyleSheet;
        }
        return null;
    }

    private AbstractCSSStyleSheet loadStyleSheet(AbstractCSSStyleSheet abstractCSSStyleSheet, String string, String string2, String string3, Node node) {
        MediaQueryList mediaQueryList;
        try {
            mediaQueryList = this.parseMediaList(string3.trim(), node);
        }
        catch (CSSMediaException cSSMediaException) {
            this.getErrorHandler().mediaQueryError(node, cSSMediaException);
            mediaQueryList = null;
        }
        if (mediaQueryList != null) {
            String string4 = this.getReferrerpolicyAttribute(node);
            if (abstractCSSStyleSheet == null) {
                abstractCSSStyleSheet = this.getStyleSheetFactory().createLinkedStyleSheet(node, string2, mediaQueryList);
            } else {
                abstractCSSStyleSheet.setTitle(string2);
                abstractCSSStyleSheet.setMedia(mediaQueryList);
                abstractCSSStyleSheet.getCssRules().clear();
            }
            try {
                URL uRL = this.getURL(string);
                if (this.isAuthorizedOrigin(uRL)) {
                    abstractCSSStyleSheet.setHref(uRL.toExternalForm());
                    abstractCSSStyleSheet.loadStyleSheet(uRL, string4);
                } else {
                    this.getErrorHandler().policyError(node, "Unauthorized URL: " + uRL.toExternalForm());
                }
            }
            catch (IOException iOException) {
                this.getErrorHandler().ioError(string, iOException);
            }
            catch (DOMPolicyException dOMPolicyException) {
                abstractCSSStyleSheet = null;
            }
            catch (DOMException dOMException) {
            }
            catch (Exception exception) {
                this.getErrorHandler().linkedSheetError(exception, abstractCSSStyleSheet);
            }
            return abstractCSSStyleSheet;
        }
        return null;
    }

    private String getReferrerpolicyAttribute(Node node) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("referrerpolicy")) != null) {
            return node2.getNodeValue();
        }
        return "";
    }

    @Override
    public CSSElement createElement(String string) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElement(string));
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Text createTextNode(String string) {
        return (Text)((Object)this.getCSSNode(this.document.createTextNode(string)));
    }

    @Override
    public Comment createComment(String string) {
        return (Comment)((Object)this.getCSSNode(this.document.createComment(string)));
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        return (CDATASection)((Object)this.getCSSNode(this.document.createCDATASection(string)));
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public Attr createAttribute(String string) throws DOMException {
        return (Attr)((Object)this.getCSSNode(this.document.createAttribute(string)));
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        return (EntityReference)((Object)this.getCSSNode(this.document.createEntityReference(string)));
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public CSSElement createElementNS(String string, String string2) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElementNS(string, string2));
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return (Attr)((Object)this.getCSSNode(this.document.createAttributeNS(string, string2)));
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        return new DOMNode.MyNodeList(this.document.getElementsByTagName(string));
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DOMNode.MyNodeList(this.document.getElementsByTagNameNS(string, string2));
    }

    @Override
    public CSSElement getElementById(String string) {
        Element element = this.document.getElementById(string);
        return element != null ? (CSSElement)this.getCSSNode(element) : null;
    }

    @Override
    public String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        throw new DOMException(9, "This is a readonly wrapper.");
    }

    @Override
    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String string) {
        this.document.setDocumentURI(string);
        this.onStyleModify();
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        throw new DOMException(7, "This is a readonly wrapper.");
    }

    @Override
    public Node cloneNode(boolean bl) {
        return this.getStyleSheetFactory().createCSSDocument((Document)this.document.cloneNode(bl));
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        throw new DOMException(7, "This is a readonly wrapper.");
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        throw new DOMException(7, "This is a readonly wrapper.");
    }

    @Override
    public void registerProperty(CSSPropertyDefinition cSSPropertyDefinition) {
        if (this.registeredPropertySet == null) {
            this.registeredPropertySet = new HashSet<CSSPropertyDefinition>();
        }
        this.registeredPropertySet.add(cSSPropertyDefinition);
        this.mergedStyleSheet = null;
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    void updateStyleLists() {
        this.linkedStyle.clear();
        this.embeddedStyle.clear();
        this.updateStyleFromProcessingInstructions();
        if (this.linkedStyle.isEmpty() && this.embeddedStyle.isEmpty() || this.isHTML()) {
            this.updateStyleFromHTMLElements();
        }
        Iterator<LinkStyleDefiner> iterator = this.linkedStyle.iterator();
        while (iterator.hasNext()) {
            this.addLinkedSheet(iterator.next().getSheet());
        }
        Iterator<LinkStyleDefiner> iterator2 = this.embeddedStyle.iterator();
        while (iterator2.hasNext()) {
            this.addLinkedSheet(iterator2.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else {
            this.metaDefaultStyleSet = this.getMetaDefaultStyleSet();
            if (this.metaDefaultStyleSet.length() > 0) {
                this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
                this.lastStyleSheetSet = null;
            } else {
                this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
                this.lastStyleSheetSet = null;
            }
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void updateStyleFromProcessingInstructions() {
        NodeList nodeList = this.document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short s = node.getNodeType();
            if (s == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction linkStyleProcessingInstruction;
                String string;
                CSSNode cSSNode = this.getMappedCSSNode(node);
                if (cSSNode == null) {
                    cSSNode = new MyStyleProcessingInstruction((ProcessingInstruction)node);
                    this.nodemap.put(node, cSSNode);
                }
                if ((string = (linkStyleProcessingInstruction = (LinkStyleProcessingInstruction)((Object)cSSNode)).getPseudoAttribute("href")).length() <= 1) continue;
                if (string.charAt(0) == '#') {
                    this.embeddedStyle.add(linkStyleProcessingInstruction);
                    continue;
                }
                this.linkedStyle.add(linkStyleProcessingInstruction);
                continue;
            }
            if (s == 1) break;
        }
    }

    private boolean isHTML() {
        Element element = this.document.getDocumentElement();
        return element != null && "html".equalsIgnoreCase(element.getTagName());
    }

    private void updateStyleFromHTMLElements() {
        Object object;
        Node node;
        int n;
        NodeList nodeList = this.document.getElementsByTagName("link");
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            LinkStyleDefiner linkStyleDefiner;
            node = nodeList.item(n);
            if (!this.linkedStyle.isEmpty() && (((String)(object = ((Element)node).getAttribute("href").trim())).length() == 0 || this.isAlreadyLoaded(this.linkedStyle, (String)object))) continue;
            object = this.getMappedCSSNode(node);
            if (object == null) {
                object = new LinkElement((Element)node);
                this.nodemap.put(node, (CSSNode)object);
            }
            if ((linkStyleDefiner = (LinkStyleDefiner)object).getSheet() == null) continue;
            this.linkedStyle.add(linkStyleDefiner);
        }
        nodeList = this.document.getElementsByTagName("style");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            node = nodeList.item(n);
            if (!this.embeddedStyle.isEmpty() && ((String)(object = ((Element)node).getAttribute("id"))).length() != 0 && this.isAlreadyLoaded(this.embeddedStyle, (String)object)) continue;
            object = this.getMappedCSSNode(node);
            if (object == null) {
                object = new StyleElement((Element)node);
                this.nodemap.put(node, (CSSNode)object);
            }
            this.embeddedStyle.add((LinkStyleDefiner)object);
        }
    }

    private boolean isAlreadyLoaded(Set<LinkStyleDefiner> set, String string) {
        for (LinkStyleDefiner linkStyleDefiner : set) {
            if (!(linkStyleDefiner instanceof LinkStyleProcessingInstruction) || !((LinkStyleProcessingInstruction)linkStyleDefiner).isSameSheet(string)) continue;
            return true;
        }
        return false;
    }

    private void addLinkedSheet(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        if (abstractCSSStyleSheet != null) {
            this.sheets.add(abstractCSSStyleSheet);
        }
    }

    private LinkStyleDefiner getEmbeddedStyleDefiner(String string) {
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short s = node.getNodeType();
            if (s == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction linkStyleProcessingInstruction = (LinkStyleProcessingInstruction)node;
                String string2 = linkStyleProcessingInstruction.getPseudoAttribute("href");
                if (string2.length() <= 1 || string2.charAt(0) != '#' || !string.equals(string2.substring(1))) continue;
                return linkStyleProcessingInstruction;
            }
            if (s == 1) break;
        }
        return null;
    }

    private String getMetaDefaultStyleSet() {
        NodeList nodeList = this.document.getElementsByTagName("head");
        if (nodeList.getLength() != 0) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getElementsByTagName("meta");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2 = (Element)nodeList2.item(i);
                NamedNodeMap namedNodeMap = element2.getAttributes();
                String string = null;
                String string2 = null;
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node = namedNodeMap.item(j);
                    if ("http-equiv".equalsIgnoreCase(node.getNodeName())) {
                        if (string2 != null) break;
                        string2 = node.getNodeValue();
                        continue;
                    }
                    if (!"content".equalsIgnoreCase(node.getNodeName())) continue;
                    if (string != null) break;
                    string = node.getNodeValue();
                }
                if (string2 == null || string == null || !"default-style".equalsIgnoreCase(string2)) continue;
                return string;
            }
        }
        return "";
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet = this.getStyleSheetFactory().getDefaultStyleSheet(this.getComplianceMode());
        this.mergedStyleSheet = this.targetMedium == null ? baseDocumentCSSStyleSheet.clone() : baseDocumentCSSStyleSheet.clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        Iterator<AbstractCSSStyleSheet> iterator = this.sheets.iterator();
        while (iterator.hasNext()) {
            this.mergedStyleSheet.addStyleSheet(iterator.next());
        }
        if (this.registeredPropertySet != null) {
            for (CSSPropertyDefinition cSSPropertyDefinition : this.registeredPropertySet) {
                this.mergedStyleSheet.registerProperty(cSSPropertyDefinition);
            }
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        Object object;
        Object object2;
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        Object object3 = "";
        Iterator<LinkStyleDefiner> iterator = this.linkedStyle.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().getSheet();
            if (object2 == null || (object = object2.getTitle()) == null || ((String)object).length() <= 0 || object2.getDisabled()) continue;
            if (((String)object3).length() > 0) {
                if (((String)object3).equalsIgnoreCase((String)object)) continue;
                return null;
            }
            object3 = object;
        }
        object2 = this.linkedStyle.iterator();
        while (iterator.hasNext()) {
            String string;
            object = ((LinkStyleDefiner)object2.next()).getSheet();
            if (object == null || (string = object.getTitle()) == null || string.length() <= 0 || object.getDisabled()) continue;
            if (((String)object3).length() > 0) {
                if (((String)object3).equalsIgnoreCase(string)) continue;
                return null;
            }
            object3 = string;
        }
        return object3;
    }

    @Override
    public void setSelectedStyleSheetSet(String string) {
        if (string == null || string.length() > 0 && !this.getStyleSheetSets().contains(string)) {
            return;
        }
        this.selectSheetSet(string, this.linkedStyle);
        this.selectSheetSet(string, this.embeddedStyle);
    }

    private void selectSheetSet(String string, Set<LinkStyleDefiner> set) {
        Iterator<LinkStyleDefiner> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            AbstractCSSStyleSheet abstractCSSStyleSheet = iterator.next().getSheet();
            if (abstractCSSStyleSheet == null || (string2 = abstractCSSStyleSheet.getTitle()) == null || string2.length() == 0) continue;
            if (string2.equalsIgnoreCase(string)) {
                abstractCSSStyleSheet.setDisabled(false);
                this.lastStyleSheetSet = string;
                continue;
            }
            abstractCSSStyleSheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StylableDocumentWrapper.enableStyleSheetSet(string, this.linkedStyle);
        StylableDocumentWrapper.enableStyleSheetSet(string, this.embeddedStyle);
    }

    private static void enableStyleSheetSet(String string, Set<LinkStyleDefiner> set) {
        Iterator<LinkStyleDefiner> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            AbstractCSSStyleSheet abstractCSSStyleSheet = iterator.next().getSheet();
            if (abstractCSSStyleSheet == null || (string2 = abstractCSSStyleSheet.getTitle()) == null || string2.length() <= 0 || !string2.equals(string)) continue;
            abstractCSSStyleSheet.setDisabled(false);
        }
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            this.sheets.setNeedsUpdate(true);
        } else if (this.sheets != null) {
            this.sheets.setNeedsUpdate(true);
        }
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        DeviceFactory deviceFactory;
        StyleDatabase styleDatabase = null;
        if (this.targetMedium != null && (deviceFactory = this.getStyleSheetFactory().getDeviceFactory()) != null) {
            styleDatabase = deviceFactory.getStyleDatabase(this.targetMedium);
        }
        return styleDatabase;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String string) throws CSSMediaException {
        if ("all".equals(string)) {
            this.targetMedium = null;
        } else {
            if (string != null) {
                string = string.intern();
            }
            this.targetMedium = string;
        }
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        CSSCanvas cSSCanvas;
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        DeviceFactory deviceFactory = this.getStyleSheetFactory().getDeviceFactory();
        if (deviceFactory != null) {
            cSSCanvas = deviceFactory.createCanvas(this.targetMedium, this);
            this.canvases.put(this.targetMedium, cSSCanvas);
        } else {
            cSSCanvas = null;
        }
        return cSSCanvas;
    }

    @Override
    public void rebuildCascade() {
        this.onStyleModify();
    }

    ErrorHandler createErrorHandler() {
        return new MyDefaultErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings() || this.getErrorHandler().hasErrors() || this.getErrorHandler().hasWarnings();
    }

    @Override
    public URL getBaseURL() {
        URL uRL = null;
        String string = this.getBaseURI();
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    String string2 = this.document.getDocumentURI();
                    if (string2 != null) {
                        URL uRL2 = new URL(string2);
                        uRL = new URL(uRL2, string);
                    }
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
        }
        return uRL;
    }

    @Override
    public String getBaseURI() {
        Object object;
        Object object2;
        String string;
        Object object3 = null;
        Element element = this.getDocumentElement();
        if (element != null) {
            string = element.getAttribute("xml:base");
            if (string.length() != 0) {
                object3 = string;
            } else if ("html".equalsIgnoreCase(element.getTagName()) && (object2 = this.document.getElementsByTagName("base")).getLength() != 0) {
                element = (Element)object2.item(0);
                object = element.getAttribute("href").trim();
                if (((String)object).length() != 0) {
                    object3 = object;
                } else {
                    object = element.getAttribute("HREF");
                    if (((String)object).length() != 0) {
                        object3 = object;
                    }
                }
            }
        }
        if (object3 != null) {
            string = this.document.getDocumentURI();
            if (string != null) {
                try {
                    object2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    return this.getBaseForNullDocumentURI((String)object3, element);
                }
                try {
                    object = new URL((URL)object2, (String)object3);
                }
                catch (MalformedURLException malformedURLException) {
                    this.getErrorHandler().ioError((String)object3, malformedURLException);
                    return object2 != null ? ((URL)object2).toExternalForm() : null;
                }
                object3 = ((URL)object).toExternalForm();
                String string2 = ((URL)object2).getProtocol();
                String string3 = ((URL)object).getProtocol();
                if (!(string2.equals(string3) || string3.equals("https") || string3.equals("http") || string2.equals("file") || string2.equals("jar"))) {
                    this.getErrorHandler().policyError(element, "Remote document wants to set a non-http base URL: " + (String)object3);
                    object3 = object2 != null ? ((URL)object2).toExternalForm() : null;
                }
                return object3;
            }
            if ((object3 = this.getBaseForNullDocumentURI((String)object3, element)) == null) {
                object3 = this.document.getDocumentURI();
            }
        } else {
            object3 = this.document.getDocumentURI();
        }
        return object3;
    }

    private String getBaseForNullDocumentURI(String string, Element element) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("https") || string2.equals("http")) {
                return string;
            }
            this.getErrorHandler().policyError(element, "Untrusted document wants to set a non-http base URL: " + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public URL getURL(String string) throws MalformedURLException {
        if (string.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL uRL = string.indexOf("://") < 0 ? new URL(this.getBaseURL(), string) : new URL(string);
        return uRL;
    }

    @Override
    public boolean isSafeOrigin(URL uRL) {
        URL uRL2 = this.getBaseURL();
        String string = uRL2.getHost();
        int n = uRL2.getPort();
        if (n == -1) {
            n = uRL2.getDefaultPort();
        }
        String string2 = uRL.getHost();
        int n2 = uRL.getPort();
        if (n2 == -1) {
            n2 = uRL.getDefaultPort();
        }
        return (string.equalsIgnoreCase(string2) || string2.endsWith(string)) && n == n2;
    }

    @Override
    public boolean isAuthorizedOrigin(URL uRL) {
        String string = uRL.getProtocol();
        URL uRL2 = this.getBaseURL();
        if (uRL2 != null) {
            String string2 = uRL2.getProtocol();
            if (!(string.equalsIgnoreCase("https") || string.equalsIgnoreCase("http") || string2.equals("file") || string2.equals("jar"))) {
                return false;
            }
        } else if (!string.equalsIgnoreCase("https") && !string.equalsIgnoreCase("http")) {
            return false;
        }
        return true;
    }

    @Override
    public String getReferrerPolicy() {
        NodeList nodeList = this.document.getElementsByTagName("meta");
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            String string;
            Element element = (Element)nodeList.item(i);
            if (!"referrer".equalsIgnoreCase(element.getAttribute("name")) || (string = element.getAttribute("content")).length() == 0) continue;
            this.metaReferrerPolicy = string;
            break;
        }
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String string) {
        if (this.metaReferrerPolicy.length() == 0) {
            this.metaReferrerPolicy = string;
        }
    }

    class EventAttr
    extends MyAttr {
        EventAttr(Attr attr) {
            super(attr);
        }

        @Override
        public void setValue(String string) throws DOMException {
            super.setValue(string);
            this.onDOMChange(this.getOwnerElement());
        }

        void onDOMChange(Node node) {
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class LinkElement
    extends StyleDefinerElement {
        LinkElement(Element element) {
            super(element);
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                String string = this.getAttribute("rel");
                String string2 = this.getAttribute("type");
                int n = string2.length();
                if (n == 0 ? string.length() == 0 : !"text/css".equalsIgnoreCase(string2)) {
                    return null;
                }
                byte by = AbstractCSSStyleSheet.parseRelAttribute(string);
                if (by != -1) {
                    String string3;
                    String string4 = this.getAttribute("title");
                    if (string4.length() == 0) {
                        string4 = null;
                    }
                    if ((string3 = this.getAttribute("href")).length() != 0) {
                        if (by == 0) {
                            if (this.loadDefinedSheet(string3, string4)) {
                                this.needsUpdate = false;
                            }
                        } else if (string4 != null) {
                            if (string3.length() != 0) {
                                boolean bl;
                                boolean bl2 = bl = this.definedSheet == null || !string4.equalsIgnoreCase(StylableDocumentWrapper.this.getSelectedStyleSheetSet());
                                if (this.loadDefinedSheet(string3, string4)) {
                                    if (bl) {
                                        this.definedSheet.setDisabled(true);
                                    }
                                    this.needsUpdate = false;
                                }
                            }
                        } else {
                            StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title.");
                        }
                    } else {
                        StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Missing or void href attribute.");
                    }
                } else {
                    this.definedSheet = null;
                }
            }
            return this.definedSheet;
        }

        private boolean loadDefinedSheet(String string, String string2) {
            this.definedSheet = StylableDocumentWrapper.this.loadStyleSheet(this.definedSheet, string, string2, this.getAttribute("media"), this);
            return this.definedSheet != null;
        }
    }

    static interface LinkStyleDefiner
    extends LinkStyle<AbstractCSSRule>,
    Node {
        public AbstractCSSStyleSheet getSheet();

        public void resetLinkedSheet();
    }

    static interface LinkStyleProcessingInstruction
    extends LinkStyleDefiner,
    ProcessingInstruction {
        public String getPseudoAttribute(String var1);

        public boolean isSameSheet(String var1);
    }

    class MyAttr
    extends MyNode
    implements Attr {
        MyAttr(Attr attr) {
            super(attr);
        }

        @Override
        public CSSNode getParentNode() {
            return null;
        }

        @Override
        public CSSNode getPreviousSibling() {
            return null;
        }

        @Override
        public CSSNode getNextSibling() {
            return null;
        }

        @Override
        public String getName() {
            return ((Attr)this.rawnode).getName();
        }

        @Override
        public void setNodeValue(String string) throws DOMException {
            this.setValue(string);
        }

        @Override
        public boolean getSpecified() {
            return ((Attr)this.rawnode).getSpecified();
        }

        @Override
        public String getValue() {
            return ((Attr)this.rawnode).getValue();
        }

        @Override
        public void setValue(String string) throws DOMException {
            ((Attr)this.rawnode).setValue(string);
        }

        @Override
        public CSSElement getOwnerElement() {
            Element element = ((Attr)this.rawnode).getOwnerElement();
            if (element == null) {
                return null;
            }
            return (CSSElement)this.getCSSNode(element);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return ((Attr)this.rawnode).getSchemaTypeInfo();
        }

        @Override
        public boolean isId() {
            return ((Attr)this.rawnode).isId();
        }

        public String toString() {
            return this.getName() + "=\"" + StylableDocumentWrapper.escapeAttributeEntities(this.getValue()) + '\"';
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection(CDATASection cDATASection) {
            super(cDATASection);
        }

        @Override
        void onDOMChange() {
            LinkStyleDefiner linkStyleDefiner = StylableDocumentWrapper.this.getEmbeddedStyleDefiner((CSSElement)this.getParentNode());
            if (linkStyleDefiner != null) {
                linkStyleDefiner.resetLinkedSheet();
            }
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    class MyCharacterData
    extends MyNode
    implements CharacterData {
        MyCharacterData(CharacterData characterData) {
            super(characterData);
        }

        @Override
        public String getData() throws DOMException {
            return this.rawnode.getNodeValue();
        }

        @Override
        public void setData(String string) throws DOMException {
            ((CharacterData)this.rawnode).setData(string);
            this.onDOMChange();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public void setNodeValue(String string) throws DOMException {
            this.setData(string);
        }

        @Override
        public void setTextContent(String string) throws DOMException {
            this.setNodeValue(string);
        }

        @Override
        public int getLength() {
            return ((CharacterData)this.rawnode).getLength();
        }

        @Override
        public String substringData(int n, int n2) throws DOMException {
            return ((CharacterData)this.rawnode).substringData(n, n2);
        }

        @Override
        public void appendData(String string) throws DOMException {
            ((CharacterData)this.rawnode).appendData(string);
            this.onDOMChange();
        }

        @Override
        public void insertData(int n, String string) throws DOMException {
            ((CharacterData)this.rawnode).insertData(n, string);
            this.onDOMChange();
        }

        @Override
        public void deleteData(int n, int n2) throws DOMException {
            ((CharacterData)this.rawnode).deleteData(n, n2);
            this.onDOMChange();
        }

        @Override
        public void replaceData(int n, int n2, String string) throws DOMException {
            ((CharacterData)this.rawnode).replaceData(n, n2, string);
            this.onDOMChange();
        }

        void onDOMChange() {
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment(Comment comment) {
            super(comment);
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    class MyDefaultErrorHandler
    extends DefaultErrorHandler {
        private static final long serialVersionUID = 1L;

        MyDefaultErrorHandler() {
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return StylableDocumentWrapper.this.getStyleSheetFactory();
        }
    }

    class MyDocumentType
    extends MyNode
    implements DocumentType {
        MyDocumentType(DocumentType documentType) {
            super(documentType);
        }

        @Override
        public String getName() {
            return ((DocumentType)this.rawnode).getName();
        }

        @Override
        public NamedNodeMap getEntities() {
            return ((DocumentType)this.rawnode).getEntities();
        }

        @Override
        public NamedNodeMap getNotations() {
            return ((DocumentType)this.rawnode).getNotations();
        }

        @Override
        public String getPublicId() {
            return ((DocumentType)this.rawnode).getPublicId();
        }

        @Override
        public String getSystemId() {
            return ((DocumentType)this.rawnode).getSystemId();
        }

        @Override
        public String getInternalSubset() {
            return ((DocumentType)this.rawnode).getInternalSubset();
        }
    }

    class MyElement
    extends MyNode
    implements CSSElement {
        private final Element element;
        WeakReference<SelectorMatcher> selectorMatcherRef;
        private Map<Condition, InlineStyle> overrideStyleSet;

        MyElement(Element element) {
            super(element);
            this.selectorMatcherRef = null;
            this.overrideStyleSet = null;
            this.element = element;
        }

        @Override
        public String getTagName() {
            return this.element.getTagName();
        }

        @Override
        public String getId() {
            return this.element.getAttribute("id");
        }

        @Override
        public String getAttribute(String string) {
            Attr attr = this.element.getAttributeNode(string);
            if (attr == null) {
                return "";
            }
            return this.getCSSNode(attr).getNodeValue();
        }

        @Override
        public void setAttribute(String string, String string2) throws DOMException {
            this.element.setAttribute(string, string2);
        }

        @Override
        public void removeAttribute(String string) throws DOMException {
            Attr attr = this.element.getAttributeNode(string);
            StylableDocumentWrapper.this.nodemap.remove(attr);
            this.element.removeAttribute(string);
        }

        @Override
        public Attr getAttributeNode(String string) {
            Attr attr = this.element.getAttributeNode(string);
            if (attr == null) {
                return null;
            }
            return (Attr)((Object)this.getCSSNode(attr));
        }

        @Override
        public Attr setAttributeNode(Attr attr) throws DOMException {
            Attr attr2 = (Attr)((DOMNode)((Object)attr)).rawnode;
            this.element.setAttributeNode(attr2);
            return attr;
        }

        @Override
        public Attr removeAttributeNode(Attr attr) throws DOMException {
            Attr attr2 = (Attr)((DOMNode)((Object)attr)).rawnode;
            Attr attr3 = this.element.removeAttributeNode(attr2);
            StylableDocumentWrapper.this.nodemap.remove(attr3);
            return attr;
        }

        @Override
        public NodeList getElementsByTagName(String string) {
            return new DOMNode.MyNodeList(this.element.getElementsByTagName(string));
        }

        @Override
        public String getAttributeNS(String string, String string2) throws DOMException {
            Attr attr = this.element.getAttributeNodeNS(string, string2);
            if (attr == null) {
                return "";
            }
            return this.getCSSNode(attr).getNodeValue();
        }

        @Override
        public void setAttributeNS(String string, String string2, String string3) throws DOMException {
            this.element.setAttributeNS(string, string2, string3);
        }

        @Override
        public void removeAttributeNS(String string, String string2) throws DOMException {
            Attr attr = this.element.getAttributeNodeNS(string, string2);
            StylableDocumentWrapper.this.nodemap.remove(attr);
            this.element.removeAttributeNS(string, string2);
        }

        @Override
        public Attr getAttributeNodeNS(String string, String string2) throws DOMException {
            Attr attr = this.element.getAttributeNodeNS(string, string2);
            if (attr == null) {
                return null;
            }
            return (Attr)((Object)this.getCSSNode(attr));
        }

        @Override
        public Attr setAttributeNodeNS(Attr attr) throws DOMException {
            Attr attr2 = (Attr)((DOMNode)((Object)attr)).rawnode;
            this.element.setAttributeNodeNS(attr2);
            return attr;
        }

        @Override
        public NodeList getElementsByTagNameNS(String string, String string2) throws DOMException {
            return new DOMNode.MyNodeList(this.element.getElementsByTagNameNS(string, string2));
        }

        @Override
        public boolean hasAttribute(String string) {
            return this.element.hasAttribute(string);
        }

        @Override
        public boolean hasAttributeNS(String string, String string2) throws DOMException {
            return this.element.hasAttributeNS(string, string2);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.element.getSchemaTypeInfo();
        }

        @Override
        public void setIdAttribute(String string, boolean bl) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        @Override
        public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        @Override
        public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        @Override
        public SelectorMatcher getSelectorMatcher() {
            SelectorMatcher selectorMatcher = null;
            if (this.selectorMatcherRef != null) {
                selectorMatcher = (SelectorMatcher)this.selectorMatcherRef.get();
            }
            if (selectorMatcher == null) {
                selectorMatcher = new WrapperSelectorMatcher(this, this.element);
                this.selectorMatcherRef = new WeakReference<SelectorMatcher>(selectorMatcher);
            }
            return selectorMatcher;
        }

        @Override
        public boolean matches(String string, String string2) throws DOMException {
            Condition condition;
            SelectorList selectorList;
            CSSParser cSSParser = new CSSParser();
            try {
                selectorList = cSSParser.parseSelectors(new StringReader(string));
            }
            catch (Exception exception) {
                throw new DOMException(12, "Unable to parse selector in: " + string);
            }
            if (string2 != null) {
                try {
                    condition = cSSParser.parsePseudoElement(string2);
                }
                catch (Exception exception) {
                    throw new DOMException(12, "Unable to parse pseudo-element in: " + string2);
                }
            } else {
                condition = null;
            }
            return this.matches(selectorList, condition);
        }

        @Override
        public boolean matches(SelectorList selectorList, Condition condition) {
            SelectorMatcher selectorMatcher = this.getSelectorMatcher();
            selectorMatcher.setPseudoElement(condition);
            return selectorMatcher.matches(selectorList) != -1;
        }

        @Override
        public CSSStyleDeclaration getStyle() {
            StyleAttr styleAttr = (StyleAttr)this.getAttributeNode("style");
            if (styleAttr == null) {
                if (StylableDocumentWrapper.this.getComplianceMode() == CSSDocument.ComplianceMode.QUIRKS) {
                    NamedNodeMap namedNodeMap = this.element.getAttributes();
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node node = namedNodeMap.item(i);
                        if (!"style".equalsIgnoreCase(node.getNodeName())) continue;
                        return ((StyleAttr)this.getCSSNode(node)).getStyle();
                    }
                }
                return null;
            }
            return styleAttr.getStyle();
        }

        @Override
        public boolean hasPresentationalHints() {
            return false;
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration cSSStyleDeclaration) {
        }

        @Override
        public boolean hasOverrideStyle(Condition condition) {
            if (this.overrideStyleSet == null) {
                return false;
            }
            return this.overrideStyleSet.containsKey(condition);
        }

        @Override
        public CSSStyleDeclaration getOverrideStyle(Condition condition) {
            InlineStyle inlineStyle = null;
            if (this.overrideStyleSet == null) {
                this.overrideStyleSet = new HashMap<Condition, InlineStyle>(1);
            } else {
                inlineStyle = this.overrideStyleSet.get(condition);
            }
            if (inlineStyle == null) {
                inlineStyle = StylableDocumentWrapper.this.getStyleSheetFactory().createInlineStyle(this);
                this.overrideStyleSet.put(condition, inlineStyle);
            }
            return inlineStyle;
        }

        @Override
        public ComputedCSSStyle getComputedStyle(String string) {
            Condition condition;
            if (string != null) {
                CSSParser cSSParser = new CSSParser();
                condition = cSSParser.parsePseudoElement(string);
            } else {
                condition = null;
            }
            return (ComputedCSSStyle)StylableDocumentWrapper.this.getStyleSheet().getComputedStyle(this, condition);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append('<').append(this.getTagName());
            NamedNodeMap namedNodeMap = this.getAttributes();
            int n = namedNodeMap.getLength();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Node node = namedNodeMap.item(i);
                    stringBuilder.append(' ');
                    stringBuilder.append(node.getNodeName()).append("='").append(node.getNodeValue());
                }
            }
            if (this.hasChildNodes()) {
                stringBuilder.append('>');
                NodeList nodeList = this.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    stringBuilder.append(nodeList.item(i).toString());
                }
                stringBuilder.append("</").append(this.getTagName()).append('>').append('\n');
            } else {
                stringBuilder.append(" />");
            }
            return stringBuilder.toString();
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        MyEntityReference(EntityReference entityReference) {
            super(entityReference);
        }
    }

    class MyNode
    extends DOMNode {
        MyNode(Node node) {
            super(node);
        }

        @Override
        public CSSDocument getOwnerDocument() {
            return StylableDocumentWrapper.this;
        }

        @Override
        protected CSSNode getCSSNode(Node node) {
            return StylableDocumentWrapper.this.getCSSNode(node);
        }

        @Override
        protected CSSNode getMappedCSSNode(Node node) {
            return StylableDocumentWrapper.this.getMappedCSSNode(node);
        }

        @Override
        public String getBaseURI() {
            return StylableDocumentWrapper.this.getBaseURI();
        }
    }

    class MyOMStyleSheetList
    extends StyleSheetList {
        private static final long serialVersionUID = 1L;

        protected MyOMStyleSheetList(int n) {
            super(n);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean bl = false;
            Iterator<AbstractCSSStyleSheet> iterator = this.iterator();
            while (iterator.hasNext()) {
                AbstractCSSStyleSheet abstractCSSStyleSheet = iterator.next();
                SheetErrorHandler sheetErrorHandler = abstractCSSStyleSheet.getErrorHandler();
                if (!abstractCSSStyleSheet.hasRuleErrorsOrWarnings() && !sheetErrorHandler.hasSacErrors() && !sheetErrorHandler.hasSacWarnings() && !sheetErrorHandler.hasOMErrors() && !sheetErrorHandler.hasOMWarnings()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        @Override
        protected void update() {
            super.update();
            StylableDocumentWrapper.this.updateStyleLists();
        }
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        MyProcessingInstruction(ProcessingInstruction processingInstruction) {
            super(processingInstruction);
        }

        @Override
        public String getData() {
            return ((ProcessingInstruction)this.rawnode).getData();
        }

        @Override
        public String getTarget() {
            return ((ProcessingInstruction)this.rawnode).getTarget();
        }

        @Override
        public void setData(String string) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        @Override
        public void setNodeValue(String string) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }
    }

    class MyStyleProcessingInstruction
    extends MyProcessingInstruction
    implements LinkStyleProcessingInstruction {
        private boolean needsUpdate;
        private AbstractCSSStyleSheet linkedSheet;
        private final LinkedHashMap<String, String> pseudoAttrs;

        MyStyleProcessingInstruction(ProcessingInstruction processingInstruction) {
            super(processingInstruction);
            this.needsUpdate = true;
            this.linkedSheet = null;
            this.pseudoAttrs = new LinkedHashMap();
            this.parseData();
        }

        @Override
        public void setData(String string) throws DOMException {
            this.rawnode.setNodeValue(string);
            this.parseData();
            this.resetLinkedSheet();
            if (this.getParentNode() != null) {
                StylableDocumentWrapper.this.onStyleModify();
            }
        }

        private void parseData() throws DOMException {
            DOMUtil.parsePseudoAttributes(this.getData(), this.pseudoAttrs);
        }

        @Override
        public void setNodeValue(String string) throws DOMException {
            this.setData(string);
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                boolean bl;
                String string = this.getPseudoAttribute("type");
                if (string.length() != 0 && !"text/css".equals(string)) {
                    return null;
                }
                String string2 = this.getPseudoAttribute("title");
                if (string2.length() == 0) {
                    string2 = null;
                }
                if ((bl = "yes".equalsIgnoreCase(this.getPseudoAttribute("alternate"))) && string2 == null) {
                    StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                    return null;
                }
                boolean bl2 = bl && (this.linkedSheet == null || !string2.equalsIgnoreCase(StylableDocumentWrapper.this.getSelectedStyleSheetSet()));
                String string3 = this.getPseudoAttribute("href");
                int n = string3.length();
                if (n > 1) {
                    if (string3.charAt(0) != '#') {
                        this.linkedSheet = StylableDocumentWrapper.this.loadStyleSheet(this.linkedSheet, string3, string2, this.getPseudoAttribute("media"), this);
                        if (this.linkedSheet != null) {
                            this.needsUpdate = false;
                        }
                    } else {
                        String string4 = string3.substring(1);
                        CSSElement cSSElement = StylableDocumentWrapper.this.getElementById(string4);
                        if (cSSElement != null) {
                            String string5 = cSSElement.getTextContent().trim();
                            this.linkedSheet = StylableDocumentWrapper.this.parseEmbeddedStyleSheet(this.linkedSheet, string5, string2, this.getPseudoAttribute("media"), this);
                            if (this.linkedSheet != null) {
                                this.needsUpdate = false;
                            }
                        } else {
                            this.linkedSheet = null;
                            StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Could not find element with id: " + string4);
                        }
                    }
                    if (bl2 && this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                } else {
                    StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Missing or void href pseudo-attribute.");
                }
            }
            return this.linkedSheet;
        }

        @Override
        public String getPseudoAttribute(String string) {
            String string2 = this.pseudoAttrs.get(string);
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        public boolean isSameSheet(String string) {
            String string2 = this.getPseudoAttribute("href");
            int n = string2.length();
            if (n > 1) {
                if (string2.charAt(0) != '#') {
                    return string2.equals(string);
                }
                return string.equals(string2.substring(1));
            }
            return false;
        }

        @Override
        public void resetLinkedSheet() {
            this.needsUpdate = true;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        MyText(Text text) {
            super(text);
        }

        @Override
        public Text splitText(int n) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        @Override
        public boolean isElementContentWhitespace() {
            return ((Text)this.rawnode).isElementContentWhitespace();
        }

        @Override
        public String getWholeText() {
            return ((Text)this.rawnode).getWholeText();
        }

        @Override
        public Text replaceWholeText(String string) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        public String toString() {
            return this.getData();
        }

        @Override
        void onDOMChange() {
            LinkStyleDefiner linkStyleDefiner = StylableDocumentWrapper.this.getEmbeddedStyleDefiner((CSSElement)this.getParentNode());
            if (linkStyleDefiner != null) {
                linkStyleDefiner.resetLinkedSheet();
                linkStyleDefiner.getSheet();
            }
        }
    }

    class StyleAttr
    extends MyAttr {
        private final AbstractCSSStyleDeclaration inlineStyle;

        StyleAttr(Attr attr) {
            super(attr);
            this.inlineStyle = StylableDocumentWrapper.this.getStyleSheetFactory().createInlineStyle(this);
            this.setInlineStyle(attr.getValue());
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getValue();
        }

        @Override
        public String getValue() {
            return this.inlineStyle.getCssText();
        }

        @Override
        public void setValue(String string) throws DOMException {
            super.setValue(string);
            this.setInlineStyle(string);
        }

        public AbstractCSSStyleDeclaration getStyle() {
            return this.inlineStyle;
        }

        void setInlineStyle(String string) {
            if (string == null) {
                string = "";
            }
            try {
                this.inlineStyle.setCssText(string);
            }
            catch (DOMException dOMException) {
                StylableDocumentWrapper.this.getErrorHandler().inlineStyleError(this.getOwnerElement(), dOMException, string);
            }
        }
    }

    abstract class StyleDefinerElement
    extends MyElement
    implements LinkStyleDefiner {
        AbstractCSSStyleSheet definedSheet;
        boolean needsUpdate;

        StyleDefinerElement(Element element) {
            super(element);
            this.definedSheet = null;
            this.needsUpdate = true;
        }

        @Override
        public void resetLinkedSheet() {
            if (this.definedSheet != null) {
                this.definedSheet.getCssRules().clear();
            }
            this.needsUpdate = true;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class StyleElement
    extends StyleDefinerElement {
        StyleElement(Element element) {
            super(element);
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                String string = this.getAttribute("type");
                if (!"text/css".equalsIgnoreCase(string) && string.length() != 0) {
                    return null;
                }
                this.definedSheet = StylableDocumentWrapper.this.parseEmbeddedStyleSheet(this.definedSheet, this.getTextContent().trim(), this.getAttribute("title"), this.getAttribute("media"), this);
                if (this.definedSheet != null) {
                    this.needsUpdate = false;
                }
            }
            return this.definedSheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.needsUpdate = true;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class StyleEventAttr
    extends MyAttr {
        StyleEventAttr(Attr attr) {
            super(attr);
        }

        @Override
        public void setValue(String string) throws DOMException {
            super.setValue(string);
            this.onDOMChange(this.getOwnerElement());
        }

        void onDOMChange(Node node) {
            if (node instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)node).resetLinkedSheet();
            }
        }
    }
}

