/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.BooleanConditionHelper;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

abstract class BooleanConditionUnit
extends LexicalUnitImpl
implements BooleanCondition {
    private static final long serialVersionUID = 1L;
    private BooleanCondition parent = null;

    BooleanConditionUnit(LexicalUnit.LexicalType lexicalType) {
        super(lexicalType);
    }

    @Override
    public List<BooleanCondition> getSubConditions() {
        return null;
    }

    @Override
    public BooleanCondition getNestedCondition() {
        return null;
    }

    @Override
    public BooleanCondition getParentCondition() {
        return this.parent;
    }

    @Override
    public void setParentCondition(BooleanCondition booleanCondition) {
        this.parent = booleanCondition;
    }

    @Override
    public abstract void addCondition(BooleanCondition var1);

    @Override
    public abstract BooleanCondition replaceLast(BooleanCondition var1);

    @Override
    public abstract void appendText(StringBuilder var1);

    @Override
    String currentToString() {
        return this.getCssText();
    }

    @Override
    public String getCssText() {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.appendText(stringBuilder);
        return stringBuilder.toString();
    }

    static class AndCondition
    extends GroupCondition {
        private static final long serialVersionUID = 1L;

        AndCondition() {
            super(LexicalUnit.LexicalType.CONDITION_AND);
            this.nestedConditions = new LinkedList();
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.AND;
        }

        @Override
        public void appendText(StringBuilder stringBuilder) {
            BooleanConditionHelper.appendANDText(this, stringBuilder);
        }

        @Override
        public void appendMinifiedText(StringBuilder stringBuilder) {
            BooleanConditionHelper.appendANDMinifiedText(this, stringBuilder);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + 13;
        }
    }

    static class FalseCondition
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 1L;
        private final String condition;

        public FalseCondition(LexicalUnit.LexicalType lexicalType, String string) {
            super(lexicalType);
            this.condition = string;
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.OTHER;
        }

        @Override
        public void addCondition(BooleanCondition booleanCondition) {
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition booleanCondition) {
            return this;
        }

        @Override
        public void appendText(StringBuilder stringBuilder) {
            stringBuilder.append(this.condition);
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = super.hashCode();
            n2 = 31 * n2 + Objects.hash(this.condition);
            return n2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FalseCondition falseCondition = (FalseCondition)object;
            return Objects.equals(this.condition, falseCondition.condition);
        }
    }

    static abstract class GroupCondition
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 1L;
        LinkedList<BooleanCondition> nestedConditions = new LinkedList();

        GroupCondition(LexicalUnit.LexicalType lexicalType) {
            super(lexicalType);
        }

        @Override
        public void addCondition(BooleanCondition booleanCondition) {
            booleanCondition.setParentCondition(this);
            this.nestedConditions.add(booleanCondition);
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition booleanCondition) {
            BooleanCondition booleanCondition2 = this.nestedConditions.removeLast();
            booleanCondition2.setParentCondition(null);
            this.addCondition(booleanCondition);
            return booleanCondition2;
        }

        @Override
        public List<BooleanCondition> getSubConditions() {
            return this.nestedConditions;
        }

        @Override
        public int hashCode() {
            return this.nestedConditions == null ? 0 : this.nestedConditions.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            GroupCondition groupCondition = (GroupCondition)object;
            return !(this.nestedConditions == null ? groupCondition.nestedConditions != null : !this.nestedConditions.equals(groupCondition.nestedConditions));
        }
    }

    static class NotCondition
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 1L;
        BooleanCondition nestedCondition;

        NotCondition() {
            super(LexicalUnit.LexicalType.CONDITION_NOT);
        }

        @Override
        public void addCondition(BooleanCondition booleanCondition) {
            booleanCondition.setParentCondition(this);
            this.nestedCondition = booleanCondition;
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition booleanCondition) {
            BooleanCondition booleanCondition2 = this.nestedCondition;
            this.addCondition(booleanCondition);
            return booleanCondition2;
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.NOT;
        }

        @Override
        public BooleanCondition getNestedCondition() {
            return this.nestedCondition;
        }

        @Override
        public void appendText(StringBuilder stringBuilder) {
            BooleanConditionHelper.appendNOTText(this, stringBuilder);
        }

        @Override
        public void appendMinifiedText(StringBuilder stringBuilder) {
            BooleanConditionHelper.appendNOTMinifiedText(this, stringBuilder);
        }

        @Override
        public int hashCode() {
            return this.nestedCondition == null ? 0 : this.nestedCondition.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NotCondition notCondition = (NotCondition)object;
            return !(this.nestedCondition == null ? notCondition.nestedCondition != null : !this.nestedCondition.equals(notCondition.nestedCondition));
        }
    }

    static class OrCondition
    extends GroupCondition {
        private static final long serialVersionUID = 1L;

        OrCondition() {
            super(LexicalUnit.LexicalType.CONDITION_OR);
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.OR;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + 7;
        }

        @Override
        public void appendText(StringBuilder stringBuilder) {
            BooleanConditionHelper.appendORText(this, stringBuilder);
        }

        @Override
        public void appendMinifiedText(StringBuilder stringBuilder) {
            BooleanConditionHelper.appendORMinifiedText(this, stringBuilder);
        }
    }

    static class Predicate
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 2L;
        private final String name;

        Predicate(String string) {
            super(LexicalUnit.LexicalType.CONDITION_PREDICATE);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.PREDICATE;
        }

        public int getPredicateType() {
            return 0;
        }

        @Override
        public void addCondition(BooleanCondition booleanCondition) {
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition booleanCondition) {
            return this;
        }

        @Override
        public void appendText(StringBuilder stringBuilder) {
            stringBuilder.append(this.name);
        }

        @Override
        public String getCssText() {
            return this.name;
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = super.hashCode();
            n2 = 31 * n2 + Objects.hash(this.name);
            return n2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Predicate predicate = (Predicate)object;
            return Objects.equals(this.name, predicate.name);
        }
    }
}

