/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.parser.ParseHelper;

class SyntaxComponent
implements CSSValueSyntax {
    private CSSValueSyntax.Category cat;
    private String name;
    private CSSValueSyntax.Multiplier multiplier = CSSValueSyntax.Multiplier.NONE;
    private SyntaxComponent next = null;

    SyntaxComponent(String string, CSSValueSyntax.Category category) {
        this.name = string;
        this.cat = category;
    }

    SyntaxComponent() {
    }

    @Override
    public CSSValueSyntax.Category getCategory() {
        return this.cat;
    }

    void setCategory(CSSValueSyntax.Category category) {
        this.cat = category;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    @Override
    public CSSValueSyntax.Multiplier getMultiplier() {
        return this.multiplier;
    }

    void setMultiplier(CSSValueSyntax.Multiplier multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public SyntaxComponent getNext() {
        return this.next;
    }

    void setNext(SyntaxComponent syntaxComponent) {
        this.next = syntaxComponent;
    }

    @Override
    public CSSValueSyntax shallowClone() {
        if (this.next == null) {
            return this;
        }
        SyntaxComponent syntaxComponent = new SyntaxComponent(this.name, this.cat);
        syntaxComponent.setMultiplier(this.getMultiplier());
        return syntaxComponent;
    }

    public String toString() {
        if (this.cat == CSSValueSyntax.Category.IDENT && this.next == null && this.multiplier == CSSValueSyntax.Multiplier.NONE) {
            return ParseHelper.escape(this.name, true, true);
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        SyntaxComponent.appendToBuffer(this, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendToBuffer(SyntaxComponent syntaxComponent, StringBuilder stringBuilder) {
        if (syntaxComponent.cat == CSSValueSyntax.Category.universal) {
            stringBuilder.append('*');
        } else if (syntaxComponent.cat == CSSValueSyntax.Category.IDENT) {
            stringBuilder.append(ParseHelper.escape(syntaxComponent.name, true, true));
        } else {
            stringBuilder.append('<').append(syntaxComponent.name).append('>');
        }
        switch (syntaxComponent.getMultiplier()) {
            case NUMBER: {
                stringBuilder.append('#');
                break;
            }
            case PLUS: {
                stringBuilder.append('+');
            }
        }
        if (syntaxComponent.next != null) {
            stringBuilder.append(" | ");
            SyntaxComponent.appendToBuffer(syntaxComponent.next, stringBuilder);
        }
    }
}

