/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorMixFunction;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorSpaceHelper;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HWBColorImpl;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProfiledColorImpl;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import org.w3c.dom.DOMException;

class ColorMixFunction
extends ColorValue
implements CSSColorMixFunction {
    private static final long serialVersionUID = 1L;
    private CSSColorValue.ColorModel inColorModel;
    private String inColorSpace;
    private ColorSpaceHelper.HueInterpolationMethod inMethod;
    private PrimitiveValue unknownMethod = null;
    private int hueIndex = -1;
    private PrimitiveValue colorValue1;
    private PrimitiveValue percent1 = null;
    private PrimitiveValue colorValue2;
    private PrimitiveValue percent2 = null;
    private BaseColor color;

    ColorMixFunction() {
        super(CSSValue.Type.COLOR_MIX);
    }

    ColorMixFunction(ColorMixFunction colorMixFunction) {
        super(colorMixFunction);
        this.inColorSpace = colorMixFunction.inColorSpace;
        this.inMethod = colorMixFunction.inMethod;
        this.unknownMethod = colorMixFunction.unknownMethod;
        this.colorValue1 = colorMixFunction.colorValue1.clone();
        this.colorValue2 = colorMixFunction.colorValue2.clone();
        if (colorMixFunction.percent1 != null) {
            this.percent1 = colorMixFunction.percent1.clone();
        }
        if (colorMixFunction.percent2 != null) {
            this.percent2 = colorMixFunction.percent2.clone();
        }
        this.setColorModelSpace(this.inColorSpace);
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        ColorMixFunction colorMixFunction = (ColorMixFunction)styleValue;
        this.inColorSpace = colorMixFunction.inColorSpace;
        this.inColorModel = colorMixFunction.inColorModel;
        this.inMethod = colorMixFunction.inMethod;
        this.unknownMethod = colorMixFunction.unknownMethod;
        this.colorValue1 = colorMixFunction.colorValue1;
        this.colorValue2 = colorMixFunction.colorValue2;
        this.percent1 = colorMixFunction.percent1;
        this.percent2 = colorMixFunction.percent2;
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return this.inColorModel;
    }

    @Override
    public String getCSSColorSpace() {
        return this.inColorSpace;
    }

    @Override
    public PrimitiveValue getColorValue1() {
        return this.colorValue1;
    }

    public void setColorValue1(PrimitiveValue primitiveValue) {
        ColorMixFunction.checkColorValidity(primitiveValue);
        this.colorValue1 = primitiveValue;
        this.mixColors();
    }

    @Override
    public PrimitiveValue getColorValue2() {
        return this.colorValue2;
    }

    public void setColorValue2(PrimitiveValue primitiveValue) {
        ColorMixFunction.checkColorValidity(primitiveValue);
        this.colorValue2 = primitiveValue;
        this.mixColors();
    }

    private static void checkColorValidity(PrimitiveValue primitiveValue) {
        if (!ColorMixFunction.isValidColor(primitiveValue)) {
            throw new DOMException(17, "Unsupported value: " + primitiveValue.getCssText());
        }
    }

    private static boolean isValidColor(PrimitiveValue primitiveValue) {
        CSSValue.Type type = primitiveValue.getPrimitiveType();
        return type == CSSValue.Type.COLOR || primitiveValue.getCssValueType() == CSSValue.CssType.PROXY || type == CSSValue.Type.IDENT && ColorIdentifiers.getInstance().isColorIdentifier(((TypedValue)primitiveValue).getStringValue());
    }

    @Override
    public PrimitiveValue getPercentage1() {
        return this.percent1;
    }

    public void setPercentage1(PrimitiveValue primitiveValue) {
        this.percent1 = ColorMixFunction.normalizePercent(primitiveValue);
    }

    @Override
    public PrimitiveValue getPercentage2() {
        return this.percent2;
    }

    public void setPercentage2(PrimitiveValue primitiveValue) throws DOMException {
        this.percent2 = ColorMixFunction.normalizePercent(primitiveValue);
    }

    private static PrimitiveValue normalizePercent(PrimitiveValue primitiveValue) {
        if (primitiveValue == null) {
            return null;
        }
        if (primitiveValue.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            PercentageEvaluator percentageEvaluator = new PercentageEvaluator();
            try {
                primitiveValue = percentageEvaluator.evaluateExpression((ExpressionValue)primitiveValue);
            }
            catch (DOMException dOMException) {}
        } else if (primitiveValue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            PercentageEvaluator percentageEvaluator = new PercentageEvaluator();
            try {
                primitiveValue = percentageEvaluator.evaluateFunction((CSSMathFunctionValue)((Object)primitiveValue));
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (primitiveValue.getUnitType() != 2 && primitiveValue.getCssValueType() != CSSValue.CssType.PROXY && primitiveValue.getPrimitiveType() != CSSValue.Type.EXPRESSION && primitiveValue.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) {
            throw new DOMException(17, "Type not compatible: " + primitiveValue.getCssText());
        }
        return primitiveValue;
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter();
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("color-mix(in ");
        stringBuilder.append(this.getCSSColorSpace());
        switch (this.inMethod) {
            case LONGER: {
                stringBuilder.append(" longer hue");
                break;
            }
            case INCREASING: {
                stringBuilder.append(" increasing hue");
                break;
            }
            case DECREASING: {
                stringBuilder.append(" decreasing hue");
                break;
            }
            case UNKNOWN: {
                stringBuilder.append(' ').append(this.unknownMethod).append(" hue");
                break;
            }
        }
        stringBuilder.append(',');
        stringBuilder.append(this.colorValue1.getMinifiedCssText(string));
        if (this.percent1 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.percent1.getMinifiedCssText(string));
        }
        stringBuilder.append(',');
        stringBuilder.append(this.colorValue2.getMinifiedCssText(string));
        if (this.percent2 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.percent2.getMinifiedCssText(string));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"color-mix(in ");
        simpleWriter.write((CharSequence)this.getCSSColorSpace());
        switch (this.inMethod) {
            case LONGER: {
                simpleWriter.write((CharSequence)" longer hue");
                break;
            }
            case INCREASING: {
                simpleWriter.write((CharSequence)" increasing hue");
                break;
            }
            case DECREASING: {
                simpleWriter.write((CharSequence)" decreasing hue");
                break;
            }
            case UNKNOWN: {
                simpleWriter.write(' ');
                this.unknownMethod.writeCssText(simpleWriter);
                simpleWriter.write((CharSequence)" hue");
                break;
            }
        }
        simpleWriter.write((CharSequence)", ");
        this.colorValue1.writeCssText(simpleWriter);
        if (this.percent1 != null) {
            simpleWriter.write(' ');
            this.percent1.writeCssText(simpleWriter);
        }
        simpleWriter.write((CharSequence)", ");
        this.colorValue2.writeCssText(simpleWriter);
        if (this.percent2 != null) {
            simpleWriter.write(' ');
            this.percent2.writeCssText(simpleWriter);
        }
        simpleWriter.write(')');
    }

    @Override
    public void setCssText(String string) throws DOMException {
        LexicalUnit lexicalUnit;
        CSSParser cSSParser = new CSSParser();
        try {
            lexicalUnit = cSSParser.parsePropertyValue(new StringReader(string));
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, "Wrong color-mix() value: " + string);
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (IOException iOException) {
            lexicalUnit = null;
        }
        PrimitiveValue.LexicalSetter lexicalSetter = this.newLexicalSetter();
        try {
            lexicalSetter.setLexicalUnit(lexicalUnit);
        }
        catch (IllegalStateException illegalStateException) {
            DOMException dOMException = new DOMException(13, "Not a color-mix() value: " + lexicalUnit.toString());
            dOMException.initCause(illegalStateException);
            throw dOMException;
        }
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        PrimitiveValue primitiveValue;
        switch (n) {
            case 0: {
                primitiveValue = this.colorValue1;
                break;
            }
            case 1: {
                primitiveValue = this.percent1;
                break;
            }
            case 2: {
                primitiveValue = this.colorValue2;
                break;
            }
            case 3: {
                primitiveValue = this.percent2;
                break;
            }
            case 4: {
                primitiveValue = this.unknownMethod;
                break;
            }
            default: {
                primitiveValue = null;
            }
        }
        return primitiveValue;
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        PrimitiveValue primitiveValue = (PrimitiveValue)styleValue;
        switch (n) {
            case 0: {
                this.setColorValue1(primitiveValue);
                break;
            }
            case 1: {
                this.setPercentage1(primitiveValue);
                break;
            }
            case 2: {
                this.setColorValue2(primitiveValue);
                break;
            }
            case 3: {
                this.setPercentage2(primitiveValue);
                break;
            }
            case 4: {
                this.setInterpolationMethod(primitiveValue);
                break;
            }
        }
    }

    private void setInterpolationMethod(PrimitiveValue primitiveValue) {
        if (primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            String string = ((TypedValue)primitiveValue).getStringValue();
            this.inMethod = ColorSpaceHelper.parseInterpolationMethod(string);
            if (this.inMethod != ColorSpaceHelper.HueInterpolationMethod.UNKNOWN) {
                this.unknownMethod = null;
                return;
            }
        } else {
            this.inMethod = ColorSpaceHelper.HueInterpolationMethod.UNKNOWN;
        }
        this.unknownMethod = primitiveValue;
    }

    @Override
    public int getComponentCount() {
        return this.unknownMethod == null ? 4 : 5;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean bl) throws DOMException {
        BaseColor baseColor = this.getColor();
        if (!baseColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        switch (baseColor.getSpace()) {
            case sRGB: {
                return (RGBColor)baseColor;
            }
            case CIE_XYZ: 
            case CIE_XYZ_D50: {
                return ((XYZColorImpl)baseColor).toSRGBColor(bl);
            }
        }
        if (this.getColorModel() == CSSColorValue.ColorModel.RGB) {
            return ((ProfiledRGBColor)baseColor).toSRGBColor(bl);
        }
        return (RGBAColor)((Object)baseColor.toColorSpace("srgb"));
    }

    @Override
    public BaseColor getColor() {
        if (this.mixColors()) {
            return this.color;
        }
        return null;
    }

    @Override
    boolean hasConvertibleComponents() {
        return !(!this.isConvertibleColor(this.colorValue1) || !this.isConvertibleColor(this.colorValue2) || this.percent1 != null && this.percent1.getUnitType() != 2 || this.percent2 != null && this.percent2.getUnitType() != 2 || this.unknownMethod != null);
    }

    private boolean isConvertibleColor(PrimitiveValue primitiveValue) {
        return primitiveValue instanceof ColorValue && ((ColorValue)primitiveValue).hasConvertibleComponents() || primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT;
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        BaseColor baseColor = this.getColor();
        if (baseColor == null || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        return baseColor.packInValue().deltaE2000(cSSColorValue);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private void setColorModelSpace(String string) {
        if ("srgb".equalsIgnoreCase(string)) {
            this.inColorSpace = "srgb";
            this.color = new RGBColor();
        } else if ("display-p3".equalsIgnoreCase(string)) {
            this.inColorSpace = "display-p3";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("a98-rgb".equalsIgnoreCase(string)) {
            this.inColorSpace = "a98-rgb";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("prophoto-rgb".equalsIgnoreCase(string)) {
            this.inColorSpace = "prophoto-rgb";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("rec2020".equalsIgnoreCase(string)) {
            this.inColorSpace = "rec2020";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("xyz".equalsIgnoreCase(string) || "xyz-d65".equalsIgnoreCase(string)) {
            this.inColorSpace = "xyz";
            this.color = new XYZColorImpl(ColorProfile.Illuminant.D65);
        } else if ("xyz-d50".equalsIgnoreCase(string)) {
            this.inColorSpace = "xyz-d50";
            this.color = new XYZColorImpl(ColorProfile.Illuminant.D50);
        } else if ("hsl".equalsIgnoreCase(string) || "hsla".equalsIgnoreCase(string)) {
            this.inColorSpace = "hsl";
            this.color = new HSLColorImpl();
            this.hueIndex = 0;
        } else if ("hwb".equalsIgnoreCase(string)) {
            this.inColorSpace = "hwb";
            this.color = new HWBColorImpl();
            this.hueIndex = 0;
        } else if ("lab".equalsIgnoreCase(string)) {
            this.inColorSpace = "lab";
            this.color = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
        } else if ("lch".equalsIgnoreCase(string)) {
            this.inColorSpace = "lch";
            this.color = new LCHColorImpl(BaseColor.Space.CIE_LCh, "lch");
            this.hueIndex = 2;
        } else if ("oklab".equalsIgnoreCase(string)) {
            this.inColorSpace = "oklab";
            this.color = new LABColorImpl(BaseColor.Space.OK_Lab, "oklab");
        } else if ("oklch".equalsIgnoreCase(string)) {
            this.inColorSpace = "oklch";
            this.color = new LCHColorImpl(BaseColor.Space.OK_LCh, "oklch");
            this.hueIndex = 2;
        } else if (string.startsWith("--")) {
            this.inColorSpace = string;
            this.color = new ProfiledColorImpl(string);
        } else {
            throw new DOMException(9, "Unsupported color space: " + string);
        }
        this.inColorModel = this.color.getColorModel();
    }

    private boolean mixColors() {
        if (this.hasConvertibleComponents()) {
            NumberValue numberValue;
            BaseColor baseColor;
            BaseColor baseColor2;
            try {
                baseColor2 = this.colorInSpace(this.colorValue1);
                baseColor = this.colorInSpace(this.colorValue2);
            }
            catch (DOMException dOMException) {
                return false;
            }
            float[] fArray = this.fractions();
            if (Float.isNaN(fArray[0])) {
                return false;
            }
            PrimitiveValue primitiveValue = baseColor2.getAlpha();
            PrimitiveValue primitiveValue2 = baseColor.getAlpha();
            if (primitiveValue == null || primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                numberValue = primitiveValue2.getPrimitiveType() == CSSValue.Type.IDENT ? NumberValue.createCSSNumberValue((short)0, 0.0f) : NumberValue.createCSSNumberValue((short)0, ((TypedValue)primitiveValue2).getFloatValue((short)0));
            } else if (primitiveValue2 == null || primitiveValue2.getPrimitiveType() == CSSValue.Type.IDENT) {
                numberValue = primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT ? NumberValue.createCSSNumberValue((short)0, 0.0f) : NumberValue.createCSSNumberValue((short)0, ((TypedValue)primitiveValue).getFloatValue((short)0));
            } else {
                float f;
                float f2;
                try {
                    f2 = ((TypedValue)primitiveValue).getFloatValue((short)0);
                    f = ((TypedValue)primitiveValue2).getFloatValue((short)0);
                }
                catch (DOMException dOMException) {
                    return false;
                }
                float f3 = f2 * fArray[0] + f * fArray[1];
                numberValue = NumberValue.createCSSNumberValue((short)0, f3);
            }
            this.color.setAlpha(numberValue);
            double[] dArray = baseColor2.toNumberArray();
            double[] dArray2 = baseColor.toNumberArray();
            int n = Math.max(dArray.length, dArray2.length);
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                TypedValue typedValue = (TypedValue)baseColor2.item(i + 1);
                TypedValue typedValue2 = (TypedValue)baseColor.item(i + 1);
                if (typedValue == null || typedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    if (typedValue2.getPrimitiveType() == CSSValue.Type.IDENT) {
                        dArray3[i] = 0.0;
                        continue;
                    }
                    dArray3[i] = dArray2[i];
                    continue;
                }
                if (typedValue2 == null || typedValue2.getPrimitiveType() == CSSValue.Type.IDENT) {
                    if (typedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                        dArray3[i] = 0.0;
                        continue;
                    }
                    dArray3[i] = dArray[i];
                    continue;
                }
                double d = dArray[i];
                double d2 = dArray2[i];
                double d3 = i == this.hueIndex ? this.hueInterpolation(d, fArray[0], d2, fArray[1]) : d * (double)fArray[0] + d2 * (double)fArray[1];
                dArray3[i] = d3;
            }
            this.color.setColorComponents(dArray3);
            return true;
        }
        return false;
    }

    private BaseColor colorInSpace(PrimitiveValue primitiveValue) {
        CSSColor cSSColor;
        if (primitiveValue.getPrimitiveType() == CSSValue.Type.COLOR) {
            cSSColor = ((ColorValue)primitiveValue).getColor().toColorSpace(this.inColorSpace);
        } else {
            cSSColor = ((TypedValue)primitiveValue).toRGBColor();
            cSSColor = cSSColor.toColorSpace(this.inColorSpace);
        }
        return (BaseColor)cSSColor;
    }

    private float[] fractions() {
        float f;
        float f2;
        if (this.percent1 == null) {
            if (this.percent2 == null) {
                f2 = 50.0f;
                f = 50.0f;
            } else {
                f = ((TypedValue)this.percent2).getFloatValue((short)2);
                f2 = 100.0f - f;
            }
        } else if (this.percent2 == null) {
            f2 = ((TypedValue)this.percent1).getFloatValue((short)2);
            f = 100.0f - f2;
        } else {
            f2 = ((TypedValue)this.percent1).getFloatValue((short)2);
            f = ((TypedValue)this.percent2).getFloatValue((short)2);
        }
        float f3 = f2 + f;
        float[] fArray = new float[2];
        if ((double)Math.abs(f3) >= 1.0E-7) {
            fArray[0] = f2 / f3;
            fArray[1] = f / f3;
        } else {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
        }
        return fArray;
    }

    private double hueInterpolation(double d, float f, double d2, float f2) {
        double d3 = d2 - d;
        switch (this.inMethod) {
            case UNKNOWN: 
            case SHORTER: {
                if (d3 > 180.0) {
                    d += 360.0;
                    break;
                }
                if (!(d3 < -180.0)) break;
                d2 += 360.0;
                break;
            }
            case LONGER: {
                if (d3 > 0.0 && d3 < 180.0) {
                    d += 360.0;
                    break;
                }
                if (!(d3 > -180.0) || !(d3 <= 0.0)) break;
                d2 += 360.0;
                break;
            }
            case INCREASING: {
                if (!(d3 < 0.0)) break;
                d2 += 360.0;
                break;
            }
            case DECREASING: {
                if (!(d3 > 0.0)) break;
                d += 360.0;
            }
        }
        double d4 = d * (double)f + d2 * (double)f2;
        if (d4 >= 360.0) {
            d4 -= 360.0;
        } else if (d4 < 0.0) {
            d4 += 360.0;
        }
        return d4;
    }

    @Override
    public LABColorValue toLABColorValue() {
        BaseColor baseColor = this.getColor();
        LABColorValue lABColorValue = new LABColorValue();
        LABColorImpl lABColorImpl = (LABColorImpl)lABColorValue.getColor();
        switch (baseColor.getColorModel()) {
            case RGB: {
                ((ProfiledRGBColor)baseColor).toLABColor(lABColorImpl);
                break;
            }
            case XYZ: {
                ((XYZColorImpl)baseColor).toLABColor(lABColorImpl);
                break;
            }
            default: {
                throw new DOMException(9, "Custom profiles are not suported.");
            }
        }
        return lABColorValue;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(new Object[]{this.inColorSpace, this.inColorModel, this.inMethod, this.colorValue1, this.colorValue2, this.percent1, this.percent2});
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColorMixFunction colorMixFunction = (ColorMixFunction)object;
        return this.inColorModel == colorMixFunction.inColorModel && this.inMethod == colorMixFunction.inMethod && Objects.equals(this.inColorSpace, colorMixFunction.inColorSpace) && Objects.equals(this.colorValue1, colorMixFunction.colorValue1) && Objects.equals(this.colorValue2, colorMixFunction.colorValue2) && Objects.equals(this.percent1, colorMixFunction.percent1) && Objects.equals(this.percent2, colorMixFunction.percent2);
    }

    @Override
    public ColorMixFunction clone() {
        return new ColorMixFunction(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(ColorMixFunction.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.COLOR_MIX) {
                    throw new IllegalStateException("No color-mix() value: " + lexicalUnit.toString());
                }
                this.setLexical(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexical(LexicalUnit lexicalUnit) {
            PrimitiveValue primitiveValue;
            PrimitiveValue primitiveValue2;
            PrimitiveValue primitiveValue3;
            Object object;
            String string;
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
            switch (lexicalType) {
                case VAR: 
                case ATTR: {
                    throw new CSSLexicalProcessingException("Unprocessable proxy inside color-mix() found.");
                }
                case IDENT: {
                    if ("in".equalsIgnoreCase(lexicalUnit2.getStringValue())) break;
                }
                default: {
                    throw new DOMException(12, "Color-Mix begings with 'in', not with " + lexicalUnit.toString());
                }
            }
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            lexicalType = lexicalUnit2.getLexicalUnitType();
            switch (lexicalType) {
                case VAR: 
                case ATTR: {
                    throw new CSSLexicalProcessingException("Unprocessable proxy inside color-mix() found.");
                }
                case IDENT: {
                    string = lexicalUnit2.getStringValue();
                    break;
                }
                default: {
                    throw new DOMException(17, "Color space must be identifier, not: " + lexicalUnit.toString());
                }
            }
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 == null) {
                this.wrongValueSyntax(lexicalUnit);
            }
            ColorSpaceHelper.HueInterpolationMethod hueInterpolationMethod = ColorSpaceHelper.HueInterpolationMethod.SHORTER;
            PrimitiveValue primitiveValue4 = null;
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                    object = lexicalUnit2.getStringValue();
                    hueInterpolationMethod = ColorSpaceHelper.parseInterpolationMethod((String)object);
                    if (hueInterpolationMethod == ColorSpaceHelper.HueInterpolationMethod.UNKNOWN) {
                        primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                        this.reportSyntaxWarning("Unknown interpolation method: " + (String)object);
                    }
                } else {
                    object = SyntaxParser.createSimpleSyntax("custom-ident");
                    if (lexicalUnit2.shallowClone().matches((CSSValueSyntax)object) != CSSValueSyntax.Match.TRUE) {
                        this.wrongValueSyntax(lexicalUnit);
                        return;
                    }
                    hueInterpolationMethod = ColorSpaceHelper.HueInterpolationMethod.UNKNOWN;
                    primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 == null) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                    if (!"hue".equalsIgnoreCase(lexicalUnit2.getStringValue())) {
                        this.wrongValueSyntax(lexicalUnit);
                        return;
                    }
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                        this.wrongValueSyntax(lexicalUnit);
                        return;
                    }
                }
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
            }
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                this.wrongValueSyntax(lexicalUnit);
            }
            CSSValueSyntax cSSValueSyntax = SyntaxParser.createSimpleSyntax("percentage");
            PrimitiveValue primitiveValue5 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            if (!ColorMixFunction.isValidColor(primitiveValue5)) {
                if (primitiveValue5.matches(cSSValueSyntax) == CSSValueSyntax.Match.FALSE) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                primitiveValue3 = primitiveValue5;
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                primitiveValue5 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                if (!ColorMixFunction.isValidColor(primitiveValue5)) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                object = primitiveValue5;
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
            } else {
                object = primitiveValue5;
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    primitiveValue5 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                    if (primitiveValue5.matches(cSSValueSyntax) == CSSValueSyntax.Match.FALSE) {
                        this.wrongValueSyntax(lexicalUnit);
                        return;
                    }
                    primitiveValue3 = primitiveValue5;
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.wrongValueSyntax(lexicalUnit);
                        return;
                    }
                } else {
                    primitiveValue3 = null;
                }
            }
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                this.wrongValueSyntax(lexicalUnit);
                return;
            }
            primitiveValue5 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            if (!ColorMixFunction.isValidColor(primitiveValue5)) {
                if (primitiveValue5.matches(cSSValueSyntax) == CSSValueSyntax.Match.FALSE) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                primitiveValue2 = primitiveValue5;
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                primitiveValue5 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                if (!ColorMixFunction.isValidColor(primitiveValue5)) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
                primitiveValue = primitiveValue5;
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    this.wrongValueSyntax(lexicalUnit);
                    return;
                }
            } else {
                primitiveValue = primitiveValue5;
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    primitiveValue5 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                    if (primitiveValue5.matches(cSSValueSyntax) == CSSValueSyntax.Match.FALSE) {
                        this.wrongValueSyntax(lexicalUnit);
                        return;
                    }
                    primitiveValue2 = primitiveValue5;
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                        this.wrongValueSyntax(lexicalUnit);
                        return;
                    }
                } else {
                    primitiveValue2 = null;
                }
            }
            ColorMixFunction.this.inColorSpace = string;
            ColorMixFunction.this.inMethod = hueInterpolationMethod;
            ColorMixFunction.this.unknownMethod = primitiveValue4;
            ColorMixFunction.this.colorValue1 = (PrimitiveValue)object;
            ColorMixFunction.this.colorValue2 = primitiveValue;
            ColorMixFunction.this.percent1 = primitiveValue3;
            ColorMixFunction.this.percent2 = primitiveValue2;
            ColorMixFunction.this.setColorModelSpace(string);
        }

        private void wrongValueSyntax(LexicalUnit lexicalUnit) {
            throw new DOMException(12, "Wrong color-mix() value: " + lexicalUnit.toString());
        }
    }
}

