/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.jclf.math.linear3.Matrices;

abstract class ColorProfile {
    final double[][] m = new double[3][3];
    final double[][] minv = new double[3][3];

    protected ColorProfile(float f, float f2, float f3, float f4, float f5, float f6, double[] dArray) {
        this.initialize(f, f2, f3, f4, f5, f6, dArray);
    }

    void initialize(float f, float f2, float f3, float f4, float f5, float f6, double[] dArray) {
        this.rgbToXYZmatrix(f, f2, f3, f4, f5, f6, dArray);
        Matrices.inverse3((double[][])this.m, (double[][])this.minv);
    }

    void rgbToXYZmatrix(float f, float f2, float f3, float f4, float f5, float f6, double[] dArray) {
        this.m[0][0] = f / f2;
        this.m[1][0] = 1.0;
        this.m[2][0] = (1.0 - (double)f - (double)f2) / (double)f2;
        this.m[0][1] = f3 / f4;
        this.m[1][1] = 1.0;
        this.m[2][1] = (1.0 - (double)f3 - (double)f4) / (double)f4;
        this.m[0][2] = f5 / f6;
        this.m[1][2] = 1.0;
        this.m[2][2] = (1.0 - (double)f5 - (double)f6) / (double)f6;
        double[][] dArray2 = new double[3][3];
        Matrices.inverse3((double[][])this.m, (double[][])dArray2);
        double[] dArray3 = new double[3];
        Matrices.multiplyByVector3((double[][])dArray2, (double[])dArray, (double[])dArray3);
        double[] dArray4 = this.m[0];
        dArray4[0] = dArray4[0] * dArray3[0];
        double[] dArray5 = this.m[1];
        dArray5[0] = dArray5[0] * dArray3[0];
        double[] dArray6 = this.m[2];
        dArray6[0] = dArray6[0] * dArray3[0];
        double[] dArray7 = this.m[0];
        dArray7[1] = dArray7[1] * dArray3[1];
        double[] dArray8 = this.m[1];
        dArray8[1] = dArray8[1] * dArray3[1];
        double[] dArray9 = this.m[2];
        dArray9[1] = dArray9[1] * dArray3[1];
        double[] dArray10 = this.m[0];
        dArray10[2] = dArray10[2] * dArray3[2];
        double[] dArray11 = this.m[1];
        dArray11[2] = dArray11[2] * dArray3[2];
        double[] dArray12 = this.m[2];
        dArray12[2] = dArray12[2] * dArray3[2];
    }

    public void linearRgbToXYZ(double d, double d2, double d3, double[] dArray) {
        dArray[0] = this.m[0][0] * d + this.m[0][1] * d2 + this.m[0][2] * d3;
        dArray[1] = this.m[1][0] * d + this.m[1][1] * d2 + this.m[1][2] * d3;
        dArray[2] = this.m[2][0] * d + this.m[2][1] * d2 + this.m[2][2] * d3;
    }

    public void linearRgbToXYZ(double[] dArray, double[] dArray2) {
        Matrices.multiplyByVector3((double[][])this.m, (double[])dArray, (double[])dArray2);
    }

    public void xyzToLinearRgb(double[] dArray, double[] dArray2) {
        Matrices.multiplyByVector3((double[][])this.minv, (double[])dArray, (double[])dArray2);
    }

    public void xyzToRgb(double[] dArray, double[] dArray2) {
        this.xyzToLinearRgb(dArray, dArray2);
        dArray2[0] = this.gammaCompanding(dArray2[0]);
        dArray2[1] = this.gammaCompanding(dArray2[1]);
        dArray2[2] = this.gammaCompanding(dArray2[2]);
    }

    public double gammaCompanding(double d) {
        double d2 = Math.abs(d);
        double d3 = d2 <= 0.0031308 ? 12.92 * d : 1.055 * Math.signum(d) * Math.pow(d2, 0.4166666666666667) - 0.055;
        return d3;
    }

    public double linearComponent(double d) {
        double d2 = Math.abs(d);
        double d3 = d2 <= 0.04045 ? d / 12.92 : Math.signum(d) * Math.pow((d2 + 0.055) / 1.055, 2.4);
        return d3;
    }

    public abstract Illuminant getIlluminant();

    static enum Illuminant {
        D50,
        D65;

    }
}

