/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.XYZColorImpl;

class ColorSpaceHelper {
    ColorSpaceHelper() {
    }

    static BaseColor.Space sRGBSpaceEnum(String string) {
        BaseColor.Space space;
        if (string == "srgb") {
            space = BaseColor.Space.sRGB;
        } else if (string == "a98-rgb") {
            space = BaseColor.Space.A98_RGB;
        } else if (string == "display-p3") {
            space = BaseColor.Space.p3;
        } else if (string == "prophoto-rgb") {
            space = BaseColor.Space.ProPhoto_RGB;
        } else if (string == "rec2020") {
            space = BaseColor.Space.Rec2020;
        } else {
            throw new IllegalStateException("This value only accepts RGB.");
        }
        return space;
    }

    static BaseColor createProfiledColor(String string) {
        BaseColor baseColor;
        if ("srgb".equalsIgnoreCase(string)) {
            string = "srgb";
            baseColor = new ProfiledRGBColor(string);
        } else if ("display-p3".equalsIgnoreCase(string)) {
            string = "display-p3";
            baseColor = new ProfiledRGBColor(string);
        } else if ("a98-rgb".equalsIgnoreCase(string)) {
            string = "a98-rgb";
            baseColor = new ProfiledRGBColor(string);
        } else if ("prophoto-rgb".equalsIgnoreCase(string)) {
            string = "prophoto-rgb";
            baseColor = new ProfiledRGBColor(string);
        } else if ("rec2020".equalsIgnoreCase(string)) {
            string = "rec2020";
            baseColor = new ProfiledRGBColor(string);
        } else {
            baseColor = "xyz".equalsIgnoreCase(string) || "xyz-d65".equalsIgnoreCase(string) ? new XYZColorImpl(ColorProfile.Illuminant.D65) : ("xyz-d50".equalsIgnoreCase(string) ? new XYZColorImpl(ColorProfile.Illuminant.D50) : null);
        }
        return baseColor;
    }

    static HueInterpolationMethod parseInterpolationMethod(String string) {
        HueInterpolationMethod hueInterpolationMethod = "shorter".equalsIgnoreCase(string) ? HueInterpolationMethod.SHORTER : ("longer".equalsIgnoreCase(string) ? HueInterpolationMethod.LONGER : ("increasing".equalsIgnoreCase(string) ? HueInterpolationMethod.INCREASING : ("decreasing".equalsIgnoreCase(string) ? HueInterpolationMethod.DECREASING : HueInterpolationMethod.UNKNOWN)));
        return hueInterpolationMethod;
    }

    static enum HueInterpolationMethod {
        SHORTER,
        LONGER,
        INCREASING,
        DECREASING,
        UNKNOWN;

    }
}

