/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.DimensionalEvaluator;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProductExpression;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.doc.style.css.property.SumExpression;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class ExpressionValue
extends TypedValue
implements CSSExpressionValue {
    private static final long serialVersionUID = 1L;
    private StyleExpression expression = null;
    private boolean roundResult = false;

    public ExpressionValue() {
        super(CSSValue.Type.EXPRESSION);
    }

    protected ExpressionValue(ExpressionValue expressionValue) {
        super(expressionValue);
        this.expression = expressionValue.expression.clone();
    }

    @Override
    ExpressionLexicalSetter newLexicalSetter() {
        return new ExpressionLexicalSetter();
    }

    private StyleExpression addOperand(StyleExpression styleExpression, OperandExpression operandExpression) {
        if (styleExpression == null) {
            styleExpression = operandExpression;
        } else {
            if (styleExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                throw new DOMException(5, "Bad expression");
            }
            styleExpression.addExpression(operandExpression);
        }
        return styleExpression;
    }

    protected boolean isInvalidOperand(PrimitiveValue primitiveValue, LexicalUnit.LexicalType lexicalType, LexicalUnit.LexicalType lexicalType2) {
        if (this.isOperatorType(lexicalType)) {
            return this.isOperatorType(lexicalType2);
        }
        return !this.isOperatorType(lexicalType2) && lexicalType2 != LexicalUnit.LexicalType.UNKNOWN && lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA;
    }

    private boolean isOperatorType(LexicalUnit.LexicalType lexicalType) {
        switch (lexicalType) {
            case OPERATOR_MINUS: 
            case OPERATOR_PLUS: 
            case OPERATOR_SLASH: 
            case OPERATOR_MULTIPLY: {
                return true;
            }
        }
        return false;
    }

    private TypedValue createConstant(String string) {
        NumberValue numberValue = new NumberValue();
        if ("pi".equalsIgnoreCase(string)) {
            numberValue.setFloatValue((short)0, (float)Math.PI);
        } else if ("e".equalsIgnoreCase(string)) {
            numberValue.setFloatValue((short)0, (float)Math.E);
        } else {
            if (this.isCalcValue()) {
                throw new DOMException(5, "Unknown constant: " + string);
            }
            IdentifierValue identifierValue = new IdentifierValue();
            identifierValue.setStringValue(CSSValue.Type.IDENT, string);
            return identifierValue;
        }
        return numberValue;
    }

    private boolean isCalcValue() {
        return this.getStringValue().length() != 0;
    }

    @Override
    public CSSExpression getExpression() {
        return this.expression;
    }

    @Override
    public String getStringValue() throws DOMException {
        return "";
    }

    @Override
    public String getCssText() {
        String string = this.expression.getCssText();
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('(').append(string).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        String string2 = this.expression.getMinifiedCssText();
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 2);
        stringBuilder.append('(').append(string2).append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            this.expression.writeCssText(simpleWriter);
        } else {
            simpleWriter.write('(');
            this.expression.writeCssText(simpleWriter);
            simpleWriter.write(')');
        }
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "The value of this property cannot be modified.");
    }

    @Override
    public void setExpectInteger() {
        this.roundResult = true;
    }

    boolean mustRoundResult() {
        return this.roundResult;
    }

    @Override
    public short computeUnitType() {
        short s;
        DimensionalEvaluator dimensionalEvaluator = new DimensionalEvaluator();
        try {
            s = dimensionalEvaluator.computeUnitType(this.getExpression());
        }
        catch (DOMException dOMException) {
            s = 255;
        }
        return s;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax == null) {
            return CSSValueSyntax.Match.FALSE;
        }
        return this.dimensionalAnalysis(cSSValueSyntax, true);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        return this.dimensionalAnalysis(cSSValueSyntax, false);
    }

    private CSSValueSyntax.Match dimensionalAnalysis(CSSValueSyntax cSSValueSyntax, boolean bl) {
        CSSValueSyntax.Category category;
        DimensionalEvaluator dimensionalEvaluator = new DimensionalEvaluator();
        try {
            category = dimensionalEvaluator.dimensionalAnalysis(this.getExpression());
        }
        catch (DOMException dOMException) {
            if (dimensionalEvaluator.hasUnknownFunction() && cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            CSSValueSyntax.Category category2;
            if ((category2 = cSSValueSyntax.getCategory()) == category) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (category2 == CSSValueSyntax.Category.lengthPercentage && (category == CSSValueSyntax.Category.length || category == CSSValueSyntax.Category.percentage) || category2 == CSSValueSyntax.Category.integer && category == CSSValueSyntax.Category.number) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (category != CSSValueSyntax.Category.lengthPercentage) continue;
            if (category2 == CSSValueSyntax.Category.length) {
                if (bl3) {
                    return CSSValueSyntax.Match.TRUE;
                }
                bl2 = true;
                continue;
            }
            if (category2 != CSSValueSyntax.Category.percentage) continue;
            if (bl2) {
                return CSSValueSyntax.Match.TRUE;
            }
            bl3 = true;
        } while (bl && (cSSValueSyntax = cSSValueSyntax.getNext()) != null);
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.expression == null ? 0 : this.expression.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionValue expressionValue = (ExpressionValue)object;
        if (this.expression == null) {
            return expressionValue.expression == null;
        }
        return this.expression.equals(expressionValue.expression);
    }

    @Override
    public ExpressionValue clone() {
        return new ExpressionValue(this);
    }

    class ExpressionLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        ExpressionLexicalSetter() {
            super(ExpressionValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) throws DOMException {
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
            this.setLexicalUnitFromSubValues(lexicalUnit.getParameters());
        }

        void setLexicalUnitFromSubValues(LexicalUnit lexicalUnit) throws DOMException {
            ExpressionValue.this.expression = this.fillExpressionLevel(lexicalUnit, new ValueFactory());
            if (ExpressionValue.this.expression == null) {
                throw new DOMException(12, "Void expression");
            }
        }

        private StyleExpression fillExpressionLevel(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            Object object = null;
            LexicalUnit.LexicalType lexicalType = LexicalUnit.LexicalType.UNKNOWN;
            block10: while (lexicalUnit != null) {
                boolean bl = false;
                LexicalUnit.LexicalType lexicalType2 = lexicalUnit.getLexicalUnitType();
                switch (lexicalType2) {
                    case OPERATOR_MINUS: {
                        bl = true;
                    }
                    case OPERATOR_PLUS: {
                        StyleExpression styleExpression;
                        if (object == null) {
                            if (bl) {
                                object = new SumExpression();
                                ((StyleExpression)object).nextOperandInverse = true;
                                break;
                            }
                            throw new DOMException(12, "Missing operand");
                        }
                        if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                            styleExpression = new SumExpression();
                            styleExpression.addExpression((StyleExpression)object);
                            styleExpression.nextOperandInverse = bl;
                            object = styleExpression;
                            break;
                        }
                        if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.SUM) {
                            ((StyleExpression)object).nextOperandInverse = bl;
                            break;
                        }
                        if (lexicalType != LexicalUnit.LexicalType.DIMENSION && lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                            throw new DOMException(12, "Missing operand");
                        }
                        Object object2 = ((StyleExpression)object).getParentExpression();
                        if (object2 == null) {
                            styleExpression = new SumExpression();
                            styleExpression.addExpression((StyleExpression)object);
                            styleExpression.nextOperandInverse = bl;
                            object = styleExpression;
                            break;
                        }
                        object = object2;
                        ((StyleExpression)object).nextOperandInverse = bl;
                        break;
                    }
                    case OPERATOR_SLASH: {
                        bl = true;
                    }
                    case OPERATOR_MULTIPLY: {
                        StyleExpression styleExpression;
                        if (object == null) {
                            throw new DOMException(12, "Missing factor");
                        }
                        if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                            styleExpression = new ProductExpression();
                            styleExpression.addExpression((StyleExpression)object);
                            styleExpression.nextOperandInverse = bl;
                            object = styleExpression;
                            break;
                        }
                        if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.SUM) {
                            if (lexicalType != LexicalUnit.LexicalType.DIMENSION && lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                                throw new DOMException(12, "Missing operand");
                            }
                            styleExpression = new ProductExpression();
                            if (lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                                ((StyleExpression)object).replaceLastExpression(styleExpression);
                            } else {
                                styleExpression.addExpression((StyleExpression)object);
                            }
                            styleExpression.nextOperandInverse = bl;
                            object = styleExpression;
                            break;
                        }
                        if (lexicalType != LexicalUnit.LexicalType.DIMENSION && lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                            throw new DOMException(12, "Missing operand");
                        }
                        ((StyleExpression)object).nextOperandInverse = bl;
                        break;
                    }
                    case SUB_EXPRESSION: {
                        Object object2 = lexicalUnit.getSubValues();
                        if (object2 == null) {
                            throw new DOMException(12, "Empty sub-expression");
                        }
                        StyleExpression styleExpression = this.fillExpressionLevel((LexicalUnit)object2, valueFactory);
                        if (styleExpression != null) {
                            if (object != null) {
                                ((StyleExpression)object).addExpression(styleExpression);
                                if (((StyleExpression)object).getPartType() != CSSExpression.AlgebraicPart.SUM) break;
                                object = styleExpression;
                                break;
                            }
                            object = styleExpression;
                            break;
                        }
                        throw new DOMException(12, "Bad subexpression");
                    }
                    case OPERATOR_COMMA: {
                        if (this.nextLexicalUnit != null || ((StyleExpression)object).getParentExpression() != null) {
                            throw new DOMException(5, "Bad operand: ','");
                        }
                        this.nextLexicalUnit = lexicalUnit;
                        return object;
                    }
                    case IDENT: {
                        String string = lexicalUnit.getStringValue();
                        TypedValue typedValue = ExpressionValue.this.createConstant(string);
                        if (ExpressionValue.this.isInvalidOperand(typedValue, lexicalType2, lexicalType)) {
                            throw new DOMException(5, "Bad operands");
                        }
                        OperandExpression operandExpression = new OperandExpression();
                        operandExpression.setOperand(typedValue);
                        object = ExpressionValue.this.addOperand((StyleExpression)object, operandExpression);
                        lexicalType = LexicalUnit.LexicalType.DIMENSION;
                        lexicalUnit = lexicalUnit.getNextLexicalUnit();
                        continue block10;
                    }
                    case CALC: {
                        StyleExpression styleExpression;
                        Object object2;
                        if (ExpressionValue.this.isCalcValue()) {
                            lexicalType2 = LexicalUnit.LexicalType.SUB_EXPRESSION;
                            object2 = lexicalUnit.getParameters();
                            if (object2 == null) {
                                throw new DOMException(12, "Empty sub-" + ExpressionValue.this.getStringValue() + "()");
                            }
                            styleExpression = this.fillExpressionLevel((LexicalUnit)object2, valueFactory);
                            if (styleExpression != null) {
                                styleExpression.setInverseOperation(bl);
                                if (object != null) {
                                    ((StyleExpression)object).addExpression(styleExpression);
                                    break;
                                }
                                object = styleExpression;
                                break;
                            }
                            throw new DOMException(12, "Bad sub-" + ExpressionValue.this.getStringValue() + "()");
                        }
                    }
                    default: {
                        PrimitiveValue.LexicalSetter lexicalSetter = valueFactory.createCSSPrimitiveValueItem(lexicalUnit, false, true);
                        PrimitiveValue primitiveValue = lexicalSetter.getCSSValue();
                        if (ExpressionValue.this.isInvalidOperand(primitiveValue, lexicalType2, lexicalType)) {
                            throw new DOMException(5, "Bad operands");
                        }
                        OperandExpression operandExpression = new OperandExpression();
                        operandExpression.setOperand(primitiveValue);
                        object = ExpressionValue.this.addOperand((StyleExpression)object, operandExpression);
                        lexicalType = LexicalUnit.LexicalType.DIMENSION;
                        lexicalUnit = lexicalSetter.getNextLexicalUnit();
                        continue block10;
                    }
                }
                lexicalType = lexicalType2;
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
            if (ExpressionValue.this.isOperatorType(lexicalType)) {
                throw new DOMException(12, "Missing operand");
            }
            if (((StyleExpression)object).getParentExpression() != null) {
                object = ((StyleExpression)object).getParentExpression();
            }
            return object;
        }
    }
}

