/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

public class LinkedCSSValueList
extends LinkedList<StyleValue>
implements CSSValueList<StyleValue> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean add(StyleValue styleValue) {
        return super.add(styleValue);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public StyleValue item(int n) {
        return (StyleValue)this.get(n);
    }

    @Override
    public LinkedCSSValueList clone() {
        LinkedCSSValueList linkedCSSValueList = new LinkedCSSValueList();
        linkedCSSValueList.addAll(this);
        return linkedCSSValueList;
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public String getCssText() {
        if (this.isEmpty()) {
            return "";
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.size() * 24 + 16);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.size() * 24 + 16);
        stringBuilder.append(this.item(0).getMinifiedCssText(string));
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(',').append(this.item(i).getMinifiedCssText(string));
        }
        return stringBuilder.toString();
    }

    @Override
    public StyleValue set(int n, StyleValue styleValue) {
        if (styleValue == null) {
            throw new NullPointerException("Null value set to ValueList");
        }
        return super.set(n, styleValue);
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        if (!this.isEmpty()) {
            ((StyleValue)this.get(0)).writeCssText(simpleWriter);
            int n = this.size();
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(',');
                simpleWriter.write(' ');
                ((StyleValue)this.get(i)).writeCssText(simpleWriter);
            }
        }
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "This value has to be modified by accessing its elements.");
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        if (!this.isEmpty() && cSSValueSyntax != null) {
            if (this.getLength() == 1) {
                return this.item(0).matches(cSSValueSyntax);
            }
            if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            do {
                CSSValueSyntax.Multiplier multiplier;
                if ((multiplier = cSSValueSyntax.getMultiplier()) == CSSValueSyntax.Multiplier.PLUS) continue;
                CSSValueSyntax.Match match2 = ValueList.valuesMatch(this.iterator(), cSSValueSyntax);
                if (match2 == CSSValueSyntax.Match.TRUE) {
                    return CSSValueSyntax.Match.TRUE;
                }
                if (match != CSSValueSyntax.Match.FALSE) continue;
                match = match2;
            } while ((cSSValueSyntax = cSSValueSyntax.getNext()) != null);
        }
        return match;
    }
}

