/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.DimensionalEvaluator;
import io.sf.carte.doc.style.css.property.FunctionValue;
import org.w3c.dom.DOMException;

class MathFunctionValue
extends FunctionValue
implements CSSMathFunctionValue {
    private static final long serialVersionUID = 1L;
    private final CSSMathFunctionValue.MathFunction function;

    MathFunctionValue(CSSMathFunctionValue.MathFunction mathFunction) {
        super(CSSValue.Type.MATH_FUNCTION);
        this.function = mathFunction;
    }

    MathFunctionValue(MathFunctionValue mathFunctionValue) {
        super(mathFunctionValue);
        this.function = mathFunctionValue.function;
    }

    @Override
    public CSSMathFunctionValue.MathFunction getFunction() {
        return this.function;
    }

    @Override
    public short computeUnitType() {
        short s;
        DimensionalEvaluator dimensionalEvaluator = new DimensionalEvaluator();
        try {
            s = dimensionalEvaluator.computeUnitType(this);
        }
        catch (DOMException dOMException) {
            s = 255;
        }
        return s;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax == null) {
            return CSSValueSyntax.Match.FALSE;
        }
        return this.dimensionalAnalysis(cSSValueSyntax, true);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        return this.dimensionalAnalysis(cSSValueSyntax, false);
    }

    private CSSValueSyntax.Match dimensionalAnalysis(CSSValueSyntax cSSValueSyntax, boolean bl) {
        CSSValueSyntax.Category category;
        DimensionalEvaluator dimensionalEvaluator = new DimensionalEvaluator();
        try {
            category = dimensionalEvaluator.dimensionalAnalysis(this);
        }
        catch (DOMException dOMException) {
            if (dimensionalEvaluator.hasUnknownFunction() && cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            CSSValueSyntax.Category category2;
            if ((category2 = cSSValueSyntax.getCategory()) == category) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (category2 == CSSValueSyntax.Category.lengthPercentage && (category == CSSValueSyntax.Category.length || category == CSSValueSyntax.Category.percentage) || category2 == CSSValueSyntax.Category.integer && category == CSSValueSyntax.Category.number) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (category != CSSValueSyntax.Category.lengthPercentage) continue;
            if (category2 == CSSValueSyntax.Category.length) {
                if (bl3) {
                    return CSSValueSyntax.Match.TRUE;
                }
                bl2 = true;
                continue;
            }
            if (category2 != CSSValueSyntax.Category.percentage) continue;
            if (bl2) {
                return CSSValueSyntax.Match.TRUE;
            }
            bl3 = true;
        } while (bl && (cSSValueSyntax = cSSValueSyntax.getNext()) != null);
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.function.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MathFunctionValue mathFunctionValue = (MathFunctionValue)object;
        return this.function == mathFunctionValue.function;
    }

    @Override
    public MathFunctionValue clone() {
        return new MathFunctionValue(this);
    }
}

