/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.AttrValue;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.CalcValue;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorMixFunction;
import io.sf.carte.doc.style.css.property.CounterValue;
import io.sf.carte.doc.style.css.property.CountersValue;
import io.sf.carte.doc.style.css.property.ElementReferenceValue;
import io.sf.carte.doc.style.css.property.EnvVariableValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.GradientValue;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.HWBColorValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.InitialValue;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.MathFunctionHelper;
import io.sf.carte.doc.style.css.property.MathFunctionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OKLABColorValue;
import io.sf.carte.doc.style.css.property.OKLCHColorValue;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.RatioValue;
import io.sf.carte.doc.style.css.property.RectValue;
import io.sf.carte.doc.style.css.property.RevertValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.UnicodeRangeValue;
import io.sf.carte.doc.style.css.property.UnicodeWildcardValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.doc.style.css.property.UnsetValue;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.doc.style.css.property.VarValue;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class ValueFactory {
    private final byte flags;

    public ValueFactory() {
        this(0);
    }

    public ValueFactory(byte by) {
        this.flags = by;
    }

    public static boolean isSizeSACUnit(LexicalUnit lexicalUnit) {
        return ValueFactory.sizeSACUnit(lexicalUnit) != 255;
    }

    private static short sizeSACUnit(LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        short s = ValueFactory.isFunctionType(lexicalType) ? ValueFactory.functionDimensionArgumentUnit(lexicalUnit) : (lexicalType == LexicalUnit.LexicalType.SUB_EXPRESSION ? ValueFactory.subexpressionDimensionUnit(lexicalUnit) : lexicalUnit.getCssUnit());
        if (CSSUnit.isLengthUnitType(s) || s == 2) {
            return s;
        }
        if (lexicalType == LexicalUnit.LexicalType.INTEGER && lexicalUnit.getIntegerValue() == 0) {
            return 0;
        }
        return 255;
    }

    private static boolean isFunctionType(LexicalUnit.LexicalType lexicalType) {
        return lexicalType == LexicalUnit.LexicalType.FUNCTION || lexicalType == LexicalUnit.LexicalType.CALC || lexicalType == LexicalUnit.LexicalType.VAR || lexicalType == LexicalUnit.LexicalType.ATTR;
    }

    public static boolean isResolutionSACUnit(LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(lexicalType)) {
            return (lexicalUnit = ValueFactory.firstDimensionArgument(lexicalUnit)) != null && ValueFactory.isResolutionSACUnit(lexicalUnit);
        }
        short s = lexicalUnit.getCssUnit();
        return CSSUnit.isResolutionUnitType(s);
    }

    public static boolean isPositiveSizeSACUnit(LexicalUnit lexicalUnit) {
        boolean bl;
        short s;
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(lexicalType)) {
            s = ValueFactory.functionDimensionArgumentUnit(lexicalUnit);
            bl = true;
        } else {
            s = lexicalUnit.getCssUnit();
            bl = false;
        }
        return !(!CSSUnit.isLengthUnitType(s) && s != 2 && s != 1 || !bl && !(lexicalUnit.getFloatValue() > 0.0f));
    }

    public static boolean isSizeOrNumberSACUnit(LexicalUnit lexicalUnit) {
        short s;
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(lexicalType)) {
            s = ValueFactory.functionDimensionArgumentUnit(lexicalUnit);
        } else {
            if (lexicalType == LexicalUnit.LexicalType.INTEGER || lexicalType == LexicalUnit.LexicalType.REAL) {
                return true;
            }
            s = lexicalUnit.getCssUnit();
        }
        return CSSUnit.isLengthUnitType(s) || s == 2 || s == 1;
    }

    public static boolean isPlainNumberOrPercentSACUnit(LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        switch (lexicalType) {
            case PERCENTAGE: 
            case INTEGER: 
            case REAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAngleSACUnit(LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(lexicalType)) {
            if (ValueFactory.isGradientFunction(lexicalUnit)) {
                return false;
            }
            return (lexicalUnit = ValueFactory.firstDimensionArgument(lexicalUnit)) != null && ValueFactory.isAngleSACUnit(lexicalUnit);
        }
        if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
            return lexicalUnit.getIntegerValue() == 0;
        }
        short s = lexicalUnit.getCssUnit();
        return CSSUnit.isAngleUnitType(s);
    }

    public static boolean isTimeSACUnit(LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(lexicalType)) {
            return (lexicalUnit = ValueFactory.firstDimensionArgument(lexicalUnit)) != null && ValueFactory.isTimeSACUnit(lexicalUnit);
        }
        if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
            return lexicalUnit.getIntegerValue() == 0;
        }
        short s = lexicalUnit.getCssUnit();
        return CSSUnit.isTimeUnitType(s);
    }

    static short functionDimensionArgumentUnit(LexicalUnit lexicalUnit) {
        if (ValueFactory.isGradientFunction(lexicalUnit)) {
            return -1;
        }
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
        while (lexicalUnit2 != null) {
            short s = ValueFactory.sizeSACUnit(lexicalUnit2);
            if (s != 255) {
                return s;
            }
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
        }
        return -1;
    }

    static short subexpressionDimensionUnit(LexicalUnit lexicalUnit) {
        LexicalUnit lexicalUnit2 = lexicalUnit.getSubValues();
        while (lexicalUnit2 != null) {
            short s = ValueFactory.sizeSACUnit(lexicalUnit2);
            if (s != 255) {
                return s;
            }
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
        }
        return -1;
    }

    private static LexicalUnit firstDimensionArgument(LexicalUnit lexicalUnit) {
        for (LexicalUnit lexicalUnit2 = lexicalUnit.getParameters(); lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
            if (lexicalType != LexicalUnit.LexicalType.DIMENSION) continue;
            return lexicalUnit2;
        }
        return null;
    }

    private static boolean isGradientFunction(LexicalUnit lexicalUnit) {
        String string = lexicalUnit.getFunctionName().toLowerCase(Locale.ROOT);
        return string.endsWith("-gradient");
    }

    public StyleValue parseProperty(String string) throws DOMException {
        return this.parseProperty(string, new CSSOMParser());
    }

    public StyleValue parseProperty(String string, Parser parser) throws DOMException {
        return this.parseProperty("", string, parser);
    }

    public StyleValue parseProperty(String string, String string2, CSSParser cSSParser) throws DOMException {
        StringReader stringReader = new StringReader(string2);
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = cSSParser.parsePropertyValue(string, stringReader);
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        StyleValue styleValue = this.createCSSValue(lexicalUnit);
        if (styleValue == null) {
            styleValue = this.createUnknownValue(string2, lexicalUnit);
        }
        return styleValue;
    }

    public StyleValue parseProperty(String string, String string2, Parser parser) throws DOMException {
        StringReader stringReader = new StringReader(string2);
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = parser.parsePropertyValue(stringReader);
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        StyleValue styleValue = this.createCSSValue(lexicalUnit);
        if (styleValue == null) {
            styleValue = this.createUnknownValue(string2, lexicalUnit);
        }
        return styleValue;
    }

    private UnknownValue createUnknownValue(String string, LexicalUnit lexicalUnit) {
        UnknownValue unknownValue;
        if (!this.isOperatorType(lexicalUnit.getLexicalUnitType())) {
            unknownValue = new UnknownValue();
            unknownValue.setCssText(string);
            ((PrimitiveValue)unknownValue).newLexicalSetter().setLexicalUnit(lexicalUnit);
        } else {
            unknownValue = null;
        }
        return unknownValue;
    }

    private boolean isOperatorType(LexicalUnit.LexicalType lexicalType) {
        switch (lexicalType) {
            case OPERATOR_COMMA: 
            case OPERATOR_EXP: 
            case OPERATOR_GE: 
            case OPERATOR_GT: 
            case OPERATOR_LE: 
            case OPERATOR_LT: 
            case OPERATOR_MINUS: 
            case OPERATOR_MULTIPLY: 
            case OPERATOR_PLUS: 
            case OPERATOR_SEMICOLON: 
            case OPERATOR_SLASH: 
            case OPERATOR_TILDE: {
                return true;
            }
        }
        return false;
    }

    public PrimitiveValue parseMediaFeature(String string) throws DOMException {
        return this.parseMediaFeature(string, new CSSOMParser());
    }

    public PrimitiveValue parseMediaFeature(String string, Parser parser) throws DOMException {
        StringReader stringReader = new StringReader(string);
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = parser.parsePropertyValue(stringReader);
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        PrimitiveValue.LexicalSetter lexicalSetter = this.createCSSPrimitiveValueItem(lexicalUnit, true, false);
        if (lexicalSetter.getNextLexicalUnit() != null) {
            throw new DOMException(12, "Bad feature: " + string);
        }
        return lexicalSetter.getCSSValue();
    }

    public StyleValue createCSSValue(LexicalUnit lexicalUnit) throws DOMException {
        return this.createCSSValue(lexicalUnit, null);
    }

    public StyleValue createCSSValue(LexicalUnit lexicalUnit, AbstractCSSStyleDeclaration abstractCSSStyleDeclaration) throws DOMException {
        return this.createCSSValue(lexicalUnit, abstractCSSStyleDeclaration, false);
    }

    public StyleValue createCSSValue(LexicalUnit lexicalUnit, AbstractCSSStyleDeclaration abstractCSSStyleDeclaration, boolean bl) throws DOMException {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler;
        if (lexicalUnit.getNextLexicalUnit() != null) {
            ValueList valueList = null;
            ValueList valueList2 = ValueList.createWSValueList();
            try {
                StyleValue styleValue;
                LexicalUnit lexicalUnit2 = lexicalUnit;
                do {
                    ValueItem valueItem;
                    if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.LEFT_BRACKET) {
                        Object object;
                        valueItem = this.createCSSValueItem(lexicalUnit2, bl);
                        if (valueItem.hasWarnings() && abstractCSSStyleDeclaration != null && (object = abstractCSSStyleDeclaration.getStyleDeclarationErrorHandler()) != null) {
                            valueItem.handleSyntaxWarnings((StyleDeclarationErrorHandler)object);
                        }
                        lexicalUnit2 = (object = (styleValue = valueItem.getCSSValue()).getCssValueType()) == CSSValue.CssType.TYPED || object == CSSValue.CssType.PROXY ? valueItem.getNextLexicalUnit() : lexicalUnit2.getNextLexicalUnit();
                    } else {
                        if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                            throw new DOMException(12, "Unmatched '['");
                        }
                        valueItem = this.parseBracketList(lexicalUnit2, abstractCSSStyleDeclaration, bl);
                        if (valueItem != null) {
                            styleValue = ((ListValueItem)valueItem).getCSSValue();
                            lexicalUnit2 = ((ListValueItem)valueItem).getNextLexicalUnit();
                        } else {
                            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                            continue;
                        }
                    }
                    if (lexicalUnit2 != null) {
                        if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                            if (valueList == null) {
                                valueList = ValueList.createCSValueList();
                            }
                            if (valueList2.getLength() > 0) {
                                valueList2.add(styleValue);
                                valueList.add(valueList2);
                                valueList2 = ValueList.createWSValueList();
                                continue;
                            }
                            valueList.add(styleValue);
                            continue;
                        }
                        valueList2.add(styleValue);
                        continue;
                    }
                    if (valueList == null) {
                        valueList2.add(styleValue);
                        break;
                    }
                    if (valueList2.getLength() > 0) {
                        valueList2.add(styleValue);
                        valueList.add(valueList2);
                        break;
                    }
                    valueList.add(styleValue);
                    break;
                } while (lexicalUnit2 != null);
                if (valueList != null) {
                    styleValue = ValueFactory.listOrFirstItem(valueList);
                    if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
                        return ValueFactory.listOrFirstItem((ValueList)styleValue);
                    }
                    return styleValue;
                }
            }
            catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
                lexicalSetter.setLexicalUnit(lexicalUnit);
                return lexicalSetter.getCSSValue();
            }
            return ValueFactory.listOrFirstItem(valueList2);
        }
        ValueItem valueItem = this.createCSSValueItem(lexicalUnit, bl);
        if (valueItem.hasWarnings() && abstractCSSStyleDeclaration != null && (styleDeclarationErrorHandler = abstractCSSStyleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            valueItem.handleSyntaxWarnings(styleDeclarationErrorHandler);
        }
        return valueItem.getCSSValue();
    }

    public ListValueItem parseBracketList(LexicalUnit lexicalUnit, AbstractCSSStyleDeclaration abstractCSSStyleDeclaration, boolean bl) {
        ListValueItem listValueItem = new ListValueItem();
        listValueItem.list = ValueList.createBracketValueList();
        try {
            while (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.RIGHT_BRACKET) {
                Object object;
                ValueItem valueItem = this.createCSSValueItem(lexicalUnit, bl);
                if (valueItem.hasWarnings() && abstractCSSStyleDeclaration != null && (object = abstractCSSStyleDeclaration.getStyleDeclarationErrorHandler()) != null) {
                    valueItem.handleSyntaxWarnings((StyleDeclarationErrorHandler)object);
                }
                lexicalUnit = (object = valueItem.getCSSValue()).getCssValueType() == CSSValue.CssType.TYPED ? valueItem.getNextLexicalUnit() : lexicalUnit.getNextLexicalUnit();
                listValueItem.list.add((StyleValue)object);
                if (lexicalUnit != null) {
                    if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || (lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null) continue;
                    throw new DOMException(12, "Unmatched '['");
                }
                throw new DOMException(12, "Unmatched '['");
            }
            if (listValueItem.list.getLength() != 0) {
                listValueItem.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
            } else {
                listValueItem = null;
            }
        }
        catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
            listValueItem.list.clear();
            PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
            lexicalSetter.setLexicalUnit(lexicalUnit);
            listValueItem.list.add(lexicalSetter.getCSSValue());
            listValueItem.nextLexicalUnit = null;
        }
        return listValueItem;
    }

    private static StyleValue listOrFirstItem(ValueList valueList) {
        int n = valueList.getLength();
        if (n > 1) {
            return valueList;
        }
        if (n == 1) {
            return valueList.item(0);
        }
        return null;
    }

    public ValueItem createCSSValueItem(LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                KeywordValue keywordValue = InheritValue.getValue();
                if (bl) {
                    keywordValue = keywordValue.asSubproperty();
                }
                return keywordValue;
            }
            case UNSET: {
                KeywordValue keywordValue = UnsetValue.getValue();
                if (bl) {
                    keywordValue = keywordValue.asSubproperty();
                }
                return keywordValue;
            }
            case REVERT: {
                KeywordValue keywordValue = RevertValue.getValue();
                if (bl) {
                    keywordValue = keywordValue.asSubproperty();
                }
                return keywordValue;
            }
            case INITIAL: {
                KeywordValue keywordValue = InitialValue.getValue();
                if (bl) {
                    keywordValue = keywordValue.asSubproperty();
                }
                return keywordValue;
            }
        }
        try {
            return this.createCSSPrimitiveValueItem(lexicalUnit, !bl, bl);
        }
        catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
            if (!this.isNotListLexicalUnit(lexicalUnit)) {
                throw cSSLexicalProcessingException;
            }
            PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
            lexicalSetter.setLexicalUnit(lexicalUnit);
            return lexicalSetter;
        }
    }

    PrimitiveValue createCSSPrimitiveValue(LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        return this.createCSSPrimitiveValueItem(lexicalUnit, !bl, bl).getCSSValue();
    }

    PrimitiveValue.LexicalSetter createCSSPrimitiveValueItem(LexicalUnit lexicalUnit, boolean bl, boolean bl2) throws DOMException {
        PrimitiveValue.LexicalSetter lexicalSetter;
        PrimitiveValue primitiveValue;
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        try {
            switch (lexicalType) {
                case IDENT: {
                    primitiveValue = new IdentifierValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case STRING: {
                    primitiveValue = new StringValue(this.flags);
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case URI: {
                    primitiveValue = new URIValue(this.flags);
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    try {
                        lexicalSetter.setLexicalUnit(lexicalUnit);
                    }
                    catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                        primitiveValue = new LexicalValue();
                        lexicalSetter = primitiveValue.newLexicalSetter();
                        lexicalSetter.setLexicalUnit(lexicalUnit);
                    }
                    break;
                }
                case PERCENTAGE: {
                    primitiveValue = new PercentageValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case DIMENSION: {
                    primitiveValue = new NumberValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    if (CSSUnit.isLengthUnitType(lexicalUnit.getCssUnit())) {
                        ((NumberValue)primitiveValue).lengthUnitType = true;
                    }
                    break;
                }
                case REAL: {
                    primitiveValue = new NumberValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    if (bl) {
                        return this.checkForRatio(lexicalSetter, bl2);
                    }
                    break;
                }
                case INTEGER: {
                    primitiveValue = new NumberValue();
                    ((NumberValue)primitiveValue).setIntegerValue(lexicalUnit.getIntegerValue());
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    primitiveValue.newLexicalSetter().nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (bl) {
                        return this.checkForRatio(lexicalSetter, bl2);
                    }
                    break;
                }
                case RGBCOLOR: {
                    primitiveValue = new RGBColorValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case HSLCOLOR: {
                    primitiveValue = new HSLColorValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case LABCOLOR: {
                    primitiveValue = new LABColorValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case LCHCOLOR: {
                    primitiveValue = new LCHColorValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case OKLABCOLOR: {
                    primitiveValue = new OKLABColorValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case OKLCHCOLOR: {
                    primitiveValue = new OKLCHColorValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case HWBCOLOR: {
                    primitiveValue = new HWBColorValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case CALC: {
                    primitiveValue = new CalcValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    if (bl) {
                        return this.checkForRatio(lexicalSetter, bl2);
                    }
                    break;
                }
                case COLOR_FUNCTION: {
                    primitiveValue = new ColorFunction();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case FUNCTION: {
                    CSSMathFunctionValue.MathFunction mathFunction;
                    String string = lexicalUnit.getFunctionName().toLowerCase(Locale.ROOT);
                    if (string.endsWith("linear-gradient") || string.endsWith("radial-gradient") || string.endsWith("conic-gradient")) {
                        primitiveValue = new GradientValue();
                        lexicalSetter = primitiveValue.newLexicalSetter();
                        try {
                            lexicalSetter.setLexicalUnit(lexicalUnit);
                            break;
                        }
                        catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                            if (!this.isNotListLexicalUnit(lexicalUnit)) {
                                throw cSSLexicalProcessingException;
                            }
                            primitiveValue = new LexicalValue();
                            lexicalSetter = primitiveValue.newLexicalSetter();
                            lexicalSetter.setLexicalUnit(lexicalUnit);
                            break;
                        }
                        catch (RuntimeException runtimeException) {
                            if (string.charAt(0) == '-') {
                                primitiveValue = new FunctionValue();
                                lexicalSetter = primitiveValue.newLexicalSetter();
                                lexicalSetter.setLexicalUnit(lexicalUnit);
                                break;
                            }
                            throw runtimeException;
                        }
                    }
                    primitiveValue = "env".equals(string) ? new EnvVariableValue() : ((mathFunction = MathFunctionHelper.getMathFunction(string)) != null ? new MathFunctionValue(mathFunction) : new FunctionValue());
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case VAR: {
                    if (!this.isIsolatedLexicalUnit(lexicalUnit)) {
                        throw new CSSLexicalProcessingException("var() found.");
                    }
                    primitiveValue = new VarValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case COLOR_MIX: {
                    primitiveValue = new ColorMixFunction();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case EMPTY: {
                    primitiveValue = new LexicalValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case ATTR: {
                    primitiveValue = new AttrValue(this.flags);
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case UNICODE_RANGE: {
                    primitiveValue = new UnicodeRangeValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case UNICODE_WILDCARD: {
                    primitiveValue = new UnicodeWildcardValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case RECT_FUNCTION: {
                    primitiveValue = new RectValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case COUNTER_FUNCTION: {
                    primitiveValue = new CounterValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case COUNTERS_FUNCTION: {
                    primitiveValue = new CountersValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case CUBIC_BEZIER_FUNCTION: {
                    primitiveValue = new FunctionValue(CSSValue.Type.CUBIC_BEZIER);
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case STEPS_FUNCTION: {
                    primitiveValue = new FunctionValue(CSSValue.Type.STEPS);
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case ELEMENT_REFERENCE: {
                    primitiveValue = new ElementReferenceValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                    break;
                }
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: {
                    throw new DOMException(12, "A comma or semicolon is not a valid primitive");
                }
                case OPERATOR_SLASH: {
                    if (this.isContentContext(lexicalUnit)) {
                        primitiveValue = new LexicalValue();
                        lexicalSetter = primitiveValue.newLexicalSetter();
                        lexicalSetter.setLexicalUnit(lexicalUnit.shallowClone());
                        lexicalSetter.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
                        break;
                    }
                }
                case OPERATOR_MINUS: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_PLUS: {
                    if (!lexicalUnit.isParameter()) {
                        throw new DOMException(12, "A '" + lexicalUnit.toString() + "' is not a valid primitive");
                    }
                }
                default: {
                    primitiveValue = new UnknownValue();
                    lexicalSetter = primitiveValue.newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit);
                }
            }
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
        catch (RuntimeException runtimeException) {
            DOMException dOMException = new DOMException(12, runtimeException.getMessage());
            dOMException.initCause(runtimeException);
            throw dOMException;
        }
        primitiveValue.setSubproperty(bl2);
        return lexicalSetter;
    }

    private boolean isIsolatedLexicalUnit(LexicalUnit lexicalUnit) {
        return !lexicalUnit.isParameter() && lexicalUnit.getNextLexicalUnit() == null && lexicalUnit.getPreviousLexicalUnit() == null;
    }

    private boolean isNotListLexicalUnit(LexicalUnit lexicalUnit) {
        return lexicalUnit.getNextLexicalUnit() == null && lexicalUnit.getPreviousLexicalUnit() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PrimitiveValue.LexicalSetter checkForRatio(PrimitiveValue.LexicalSetter lexicalSetter, boolean bl) throws DOMException {
        LexicalUnit lexicalUnit = lexicalSetter.getNextLexicalUnit();
        if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) return lexicalSetter;
        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) throw new DOMException(12, "Invalid ratio.");
        PrimitiveValue.LexicalSetter lexicalSetter2 = this.createCSSPrimitiveValueItem(lexicalUnit, false, false);
        RatioValue ratioValue = new RatioValue();
        try {
            ratioValue.setAntecedentValue(lexicalSetter.getCSSValue());
            ratioValue.setConsequentValue(lexicalSetter2.getCSSValue());
            lexicalSetter = ratioValue.newLexicalSetter();
            lexicalSetter.setLexicalUnit(lexicalSetter2.getNextLexicalUnit());
            ratioValue.setSubproperty(bl);
            return lexicalSetter;
        }
        catch (DOMException dOMException) {
            if (dOMException.code != 15) return lexicalSetter;
            throw dOMException;
        }
    }

    private boolean isContentContext(LexicalUnit lexicalUnit) {
        LexicalUnit lexicalUnit2 = lexicalUnit.getPreviousLexicalUnit();
        LexicalUnit lexicalUnit3 = lexicalUnit.getNextLexicalUnit();
        if (lexicalUnit2 != null && lexicalUnit3 != null && !lexicalUnit.isParameter()) {
            CSSValueSyntax cSSValueSyntax = new SyntaxParser().parseSyntax("<string> | <counter> | <image> | <custom-ident>");
            CSSValueSyntax cSSValueSyntax2 = new SyntaxParser().parseSyntax("<string> | <counter>");
            return lexicalUnit2.shallowClone().matches(cSSValueSyntax) != CSSValueSyntax.Match.FALSE && lexicalUnit3.matches(cSSValueSyntax2) != CSSValueSyntax.Match.FALSE;
        }
        return false;
    }

    public LexicalUnit appendValueString(StringBuilder stringBuilder, LexicalUnit lexicalUnit) {
        LexicalUnit lexicalUnit2;
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
            lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            stringBuilder.append(',');
        } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
            lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            stringBuilder.append(' ').append('/');
        } else if (lexicalType != LexicalUnit.LexicalType.LEFT_BRACKET) {
            ValueItem valueItem = this.createCSSValueItem(lexicalUnit, true);
            lexicalUnit2 = valueItem.getNextLexicalUnit();
            StyleValue styleValue = valueItem.getCSSValue();
            String string = styleValue.getCssText();
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        } else {
            lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            ListValueItem listValueItem = this.parseBracketList(lexicalUnit2, null, false);
            if (listValueItem != null) {
                lexicalUnit2 = listValueItem.getNextLexicalUnit();
                stringBuilder.append(listValueItem.getCSSValue().getCssText());
            } else {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
        }
        return lexicalUnit2;
    }

    public LexicalUnit appendMinifiedValueString(StringBuilder stringBuilder, LexicalUnit lexicalUnit) {
        LexicalUnit lexicalUnit2;
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
            lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            stringBuilder.append(',');
        } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
            lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            stringBuilder.append('/');
        } else if (lexicalType != LexicalUnit.LexicalType.LEFT_BRACKET) {
            char c;
            ValueItem valueItem = this.createCSSValueItem(lexicalUnit, true);
            lexicalUnit2 = valueItem.getNextLexicalUnit();
            StyleValue styleValue = valueItem.getCSSValue();
            String string = styleValue.getMinifiedCssText("");
            int n = stringBuilder.length();
            if (n != 0 && (c = stringBuilder.charAt(n - 1)) != ',' && c != '/') {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        } else {
            lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            ListValueItem listValueItem = this.parseBracketList(lexicalUnit2, null, false);
            if (listValueItem != null) {
                lexicalUnit2 = listValueItem.getNextLexicalUnit();
                stringBuilder.append(listValueItem.getCSSValue().getMinifiedCssText(""));
            } else {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
        }
        return lexicalUnit2;
    }

    public boolean hasFactoryFlag(byte by) {
        return (this.flags & by) == by;
    }

    static class BasicValueItem
    implements ValueItem {
        LexicalUnit nextLexicalUnit = null;

        BasicValueItem() {
        }

        @Override
        public StyleValue getCSSValue() {
            return null;
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler styleDeclarationErrorHandler) {
        }
    }

    public static class ListValueItem
    extends BasicValueItem {
        private ValueList list = null;

        @Override
        public ValueList getCSSValue() {
            return this.list;
        }
    }
}

