/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom.plane;

import com.jogamp.graph.geom.plane.Path2F;
import com.jogamp.opengl.math.FloatUtil;

class Crossing2F {
    static final float DELTA = 1.0E-5f;
    static final float ROOT_DELTA = 1.0E-10f;
    public static final int CROSSING = 255;
    static final int UNKNOWN = 254;

    Crossing2F() {
    }

    public static int solveQuad(float[] fArray, float[] fArray2) {
        float f = fArray[2];
        float f2 = fArray[1];
        float f3 = fArray[0];
        int n = 0;
        if ((double)f == 0.0) {
            if ((double)f2 == 0.0) {
                return -1;
            }
            fArray2[n++] = -f3 / f2;
        } else {
            float f4 = f2 * f2 - 4.0f * f * f3;
            if ((double)f4 < 0.0) {
                return 0;
            }
            f4 = FloatUtil.sqrt(f4);
            fArray2[n++] = (-f2 + f4) / (f * 2.0f);
            if ((double)f4 != 0.0) {
                fArray2[n++] = (-f2 - f4) / (f * 2.0f);
            }
        }
        return Crossing2F.fixRoots(fArray2, n);
    }

    public static int solveCubic(float[] fArray, float[] fArray2) {
        float f = fArray[3];
        if (f == 0.0f) {
            return Crossing2F.solveQuad(fArray, fArray2);
        }
        float f2 = fArray[2] / f;
        float f3 = fArray[1] / f;
        float f4 = fArray[0] / f;
        int n = 0;
        float f5 = (f2 * f2 - 3.0f * f3) / 9.0f;
        float f6 = (2.0f * f2 * f2 * f2 - 9.0f * f2 * f3 + 27.0f * f4) / 54.0f;
        float f7 = f5 * f5 * f5;
        float f8 = f6 * f6;
        float f9 = -f2 / 3.0f;
        if (f8 < f7) {
            float f10 = FloatUtil.acos(f6 / FloatUtil.sqrt(f7)) / 3.0f;
            float f11 = -2.0f * FloatUtil.sqrt(f5);
            fArray2[n++] = f11 * FloatUtil.cos(f10) + f9;
            fArray2[n++] = f11 * FloatUtil.cos(f10 + 2.0943952f) + f9;
            fArray2[n++] = f11 * FloatUtil.cos(f10 - 2.0943952f) + f9;
        } else {
            float f12 = FloatUtil.pow(FloatUtil.abs(f6) + FloatUtil.sqrt(f8 - f7), 0.33333334f);
            if ((double)f6 > 0.0) {
                f12 = -f12;
            }
            if (-1.0E-10f < f12 && f12 < 1.0E-10f) {
                fArray2[n++] = f9;
            } else {
                float f13 = f5 / f12;
                fArray2[n++] = f12 + f13 + f9;
                float f14 = f8 - f7;
                if (-1.0E-10f < f14 && f14 < 1.0E-10f) {
                    fArray2[n++] = -(f12 + f13) / 2.0f + f9;
                }
            }
        }
        return Crossing2F.fixRoots(fArray2, n);
    }

    static int fixRoots(float[] fArray, int n) {
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (Crossing2F.isZero(fArray[i] - fArray[j])) continue block0;
            }
            fArray[n2++] = fArray[i];
        }
        return n2;
    }

    public static int crossLine(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f5 < f && f5 < f3 || f5 > f && f5 > f3 || f6 > f2 && f6 > f4 || f == f3) {
            return 0;
        }
        if (!(f6 < f2 && f6 < f4 || !((f4 - f2) * (f5 - f) / (f3 - f) <= f6 - f2))) {
            return 0;
        }
        if (f5 == f) {
            return f < f3 ? 0 : -1;
        }
        if (f5 == f3) {
            return f < f3 ? 1 : 0;
        }
        return f < f3 ? 1 : -1;
    }

    public static int crossQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (f7 < f && f7 < f3 && f7 < f5 || f7 > f && f7 > f3 && f7 > f5 || f8 > f2 && f8 > f4 && f8 > f6 || f == f3 && f3 == f5) {
            return 0;
        }
        if (f8 < f2 && f8 < f4 && f8 < f6 && f7 != f && f7 != f5) {
            if (f < f5) {
                return f < f7 && f7 < f5 ? 1 : 0;
            }
            return f5 < f7 && f7 < f ? -1 : 0;
        }
        QuadCurve quadCurve = new QuadCurve(f, f2, f3, f4, f5, f6);
        float f9 = f7 - f;
        float f10 = f8 - f2;
        float[] fArray = new float[3];
        int n = quadCurve.solvePoint(fArray, f9);
        return quadCurve.cross(fArray, n, f10, f10);
    }

    public static int crossCubic(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (f9 < f && f9 < f3 && f9 < f5 && f9 < f7 || f9 > f && f9 > f3 && f9 > f5 && f9 > f7 || f10 > f2 && f10 > f4 && f10 > f6 && f10 > f8 || f == f3 && f3 == f5 && f5 == f7) {
            return 0;
        }
        if (f10 < f2 && f10 < f4 && f10 < f6 && f10 < f8 && f9 != f && f9 != f7) {
            if (f < f7) {
                return f < f9 && f9 < f7 ? 1 : 0;
            }
            return f7 < f9 && f9 < f ? -1 : 0;
        }
        CubicCurve cubicCurve = new CubicCurve(f, f2, f3, f4, f5, f6, f7, f8);
        float f11 = f9 - f;
        float f12 = f10 - f2;
        float[] fArray = new float[3];
        int n = cubicCurve.solvePoint(fArray, f11);
        return cubicCurve.cross(fArray, n, f12, f12);
    }

    public static int crossPath(Path2F.Iterator iterator, float f, float f2) {
        int n = 0;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float[] fArray = iterator.points();
        while (iterator.hasNext()) {
            int n2 = iterator.index();
            Path2F.SegmentType segmentType = iterator.next();
            switch (segmentType) {
                case MOVETO: {
                    if (f4 != f6 || f3 != f5) {
                        n += Crossing2F.crossLine(f4, f3, f6, f5, f, f2);
                    }
                    f6 = f4 = fArray[n2 + 0];
                    f5 = f3 = fArray[n2 + 1];
                    break;
                }
                case LINETO: {
                    float f7 = f4;
                    float f8 = f3;
                    f4 = fArray[n2 + 0];
                    f3 = fArray[n2 + 1];
                    n += Crossing2F.crossLine(f7, f8, f4, f3, f, f2);
                    break;
                }
                case QUADTO: {
                    float f9 = f4;
                    float f10 = f3;
                    f4 = fArray[n2 + 2];
                    f3 = fArray[n2 + 3];
                    n += Crossing2F.crossQuad(f9, f10, fArray[n2 + 0], fArray[n2 + 1], f4, f3, f, f2);
                    break;
                }
                case CUBICTO: {
                    float f11 = f4;
                    float f12 = f3;
                    f4 = fArray[n2 + 4];
                    f3 = fArray[n2 + 5];
                    n += Crossing2F.crossCubic(f11, f12, fArray[n2 + 0], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3], f4, f3, f, f2);
                    break;
                }
                case CLOSE: {
                    if (f3 == f5 && f4 == f6) break;
                    float f13 = f4;
                    float f14 = f3;
                    f4 = f6;
                    f3 = f5;
                    n += Crossing2F.crossLine(f13, f14, f4, f3, f, f2);
                }
            }
            if (f != f4 || f2 != f3) continue;
            n = 0;
            f3 = f5;
            break;
        }
        if (f3 != f5) {
            n += Crossing2F.crossLine(f4, f3, f6, f5, f, f2);
        }
        return n;
    }

    public static int crossShape(Path2F path2F, float f, float f2) {
        if (!path2F.getBounds2D().contains(f, f2)) {
            return 0;
        }
        return Crossing2F.crossPath(path2F.iterator(null), f, f2);
    }

    public static boolean isZero(float f) {
        return -1.0E-5f < f && f < 1.0E-5f;
    }

    static void sortBound(float[] fArray, int n) {
        for (int i = 0; i < n - 4; i += 4) {
            int n2 = i;
            for (int j = i + 4; j < n; j += 4) {
                if (!(fArray[n2] > fArray[j])) continue;
                n2 = j;
            }
            if (n2 == i) continue;
            float f = fArray[i];
            fArray[i] = fArray[n2];
            fArray[n2] = f;
            f = fArray[i + 1];
            fArray[i + 1] = fArray[n2 + 1];
            fArray[n2 + 1] = f;
            f = fArray[i + 2];
            fArray[i + 2] = fArray[n2 + 2];
            fArray[n2 + 2] = f;
            f = fArray[i + 3];
            fArray[i + 3] = fArray[n2 + 3];
            fArray[n2 + 3] = f;
        }
    }

    static int crossBound(float[] fArray, int n, float f, float f2) {
        int n2;
        if (n == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 2; n2 < n; n2 += 4) {
            if (fArray[n2] < f) {
                ++n3;
                continue;
            }
            if (fArray[n2] > f2) {
                ++n4;
                continue;
            }
            return 255;
        }
        if (n4 == 0) {
            return 0;
        }
        if (n3 != 0) {
            Crossing2F.sortBound(fArray, n);
            n2 = fArray[2] > f2 ? 1 : 0;
            for (int i = 6; i < n; i += 4) {
                int n5;
                int n6 = n5 = fArray[i] > f2 ? 1 : 0;
                if (n2 != n5 && fArray[i + 1] != fArray[i - 3]) {
                    return 255;
                }
                n2 = n5;
            }
        }
        return 254;
    }

    public static int intersectLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (f7 < f && f7 < f3 || f5 > f && f5 > f3 || f6 > f2 && f6 > f4) {
            return 0;
        }
        if (!(f8 < f2) || !(f8 < f4)) {
            float f9;
            float f10;
            if (f == f3) {
                return 255;
            }
            if (f < f3) {
                f10 = f < f5 ? f5 : f;
                f9 = f3 < f7 ? f3 : f7;
            } else {
                f10 = f3 < f5 ? f5 : f3;
                f9 = f < f7 ? f : f7;
            }
            float f11 = (f4 - f2) / (f3 - f);
            float f12 = f11 * (f10 - f) + f2;
            float f13 = f11 * (f9 - f) + f2;
            if (f12 < f6 && f13 < f6) {
                return 0;
            }
            if (!(f12 > f8) || !(f13 > f8)) {
                return 255;
            }
        }
        if (f == f3) {
            return 0;
        }
        if (f5 == f) {
            return f < f3 ? 0 : -1;
        }
        if (f5 == f3) {
            return f < f3 ? 1 : 0;
        }
        if (f < f3) {
            return f < f5 && f5 < f3 ? 1 : 0;
        }
        return f3 < f5 && f5 < f ? -1 : 0;
    }

    public static int intersectQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        int n;
        if (f9 < f && f9 < f3 && f9 < f5 || f7 > f && f7 > f3 && f7 > f5 || f8 > f2 && f8 > f4 && f8 > f6) {
            return 0;
        }
        if (f10 < f2 && f10 < f4 && f10 < f6 && f7 != f && f7 != f5) {
            if (f < f5) {
                return f < f7 && f7 < f5 ? 1 : 0;
            }
            return f5 < f7 && f7 < f ? -1 : 0;
        }
        QuadCurve quadCurve = new QuadCurve(f, f2, f3, f4, f5, f6);
        float f11 = f7 - f;
        float f12 = f8 - f2;
        float f13 = f9 - f;
        float f14 = f10 - f2;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n2 = quadCurve.solvePoint(fArray, f11);
        int n3 = quadCurve.solvePoint(fArray2, f13);
        if (n2 == 0 && n3 == 0) {
            return 0;
        }
        float f15 = f11 - 1.0E-5f;
        float f16 = f13 + 1.0E-5f;
        float[] fArray3 = new float[28];
        int n4 = 0;
        n4 = quadCurve.addBound(fArray3, n4, fArray, n2, f15, f16, false, 0);
        n4 = quadCurve.addBound(fArray3, n4, fArray2, n3, f15, f16, false, 1);
        n3 = quadCurve.solveExtrem(fArray2);
        n4 = quadCurve.addBound(fArray3, n4, fArray2, n3, f15, f16, true, 2);
        if (f7 < f && f < f9) {
            fArray3[n4++] = 0.0f;
            fArray3[n4++] = 0.0f;
            fArray3[n4++] = 0.0f;
            fArray3[n4++] = 4.0f;
        }
        if (f7 < f5 && f5 < f9) {
            fArray3[n4++] = 1.0f;
            fArray3[n4++] = quadCurve.ax;
            fArray3[n4++] = quadCurve.ay;
            fArray3[n4++] = 5.0f;
        }
        if ((n = Crossing2F.crossBound(fArray3, n4, f12, f14)) != 254) {
            return n;
        }
        return quadCurve.cross(fArray, n2, f12, f14);
    }

    public static int intersectCubic(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        int n;
        if (f11 < f && f11 < f3 && f11 < f5 && f11 < f7 || f9 > f && f9 > f3 && f9 > f5 && f9 > f7 || f10 > f2 && f10 > f4 && f10 > f6 && f10 > f8) {
            return 0;
        }
        if (f12 < f2 && f12 < f4 && f12 < f6 && f12 < f8 && f9 != f && f9 != f7) {
            if (f < f7) {
                return f < f9 && f9 < f7 ? 1 : 0;
            }
            return f7 < f9 && f9 < f ? -1 : 0;
        }
        CubicCurve cubicCurve = new CubicCurve(f, f2, f3, f4, f5, f6, f7, f8);
        float f13 = f9 - f;
        float f14 = f10 - f2;
        float f15 = f11 - f;
        float f16 = f12 - f2;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n2 = cubicCurve.solvePoint(fArray, f13);
        int n3 = cubicCurve.solvePoint(fArray2, f15);
        if (n2 == 0 && n3 == 0) {
            return 0;
        }
        float f17 = f13 - 1.0E-5f;
        float f18 = f15 + 1.0E-5f;
        float[] fArray3 = new float[40];
        int n4 = 0;
        n4 = cubicCurve.addBound(fArray3, n4, fArray, n2, f17, f18, false, 0);
        n4 = cubicCurve.addBound(fArray3, n4, fArray2, n3, f17, f18, false, 1);
        n3 = cubicCurve.solveExtremX(fArray2);
        n4 = cubicCurve.addBound(fArray3, n4, fArray2, n3, f17, f18, true, 2);
        n3 = cubicCurve.solveExtremY(fArray2);
        n4 = cubicCurve.addBound(fArray3, n4, fArray2, n3, f17, f18, true, 4);
        if (f9 < f && f < f11) {
            fArray3[n4++] = 0.0f;
            fArray3[n4++] = 0.0f;
            fArray3[n4++] = 0.0f;
            fArray3[n4++] = 6.0f;
        }
        if (f9 < f7 && f7 < f11) {
            fArray3[n4++] = 1.0f;
            fArray3[n4++] = cubicCurve.ax;
            fArray3[n4++] = cubicCurve.ay;
            fArray3[n4++] = 7.0f;
        }
        if ((n = Crossing2F.crossBound(fArray3, n4, f14, f16)) != 254) {
            return n;
        }
        return cubicCurve.cross(fArray, n2, f14, f16);
    }

    public static int intersectPath(Path2F.Iterator iterator, float f, float f2, float f3, float f4) {
        int n;
        int n2 = 0;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = f;
        float f10 = f2;
        float f11 = f + f3;
        float f12 = f2 + f4;
        float[] fArray = iterator.points();
        while (iterator.hasNext()) {
            int n3 = iterator.index();
            Path2F.SegmentType segmentType = iterator.next();
            n = 0;
            switch (segmentType) {
                case MOVETO: {
                    if (f6 != f8 || f5 != f7) {
                        n = Crossing2F.intersectLine(f6, f5, f8, f7, f9, f10, f11, f12);
                    }
                    f8 = f6 = fArray[n3 + 0];
                    f7 = f5 = fArray[n3 + 1];
                    break;
                }
                case LINETO: {
                    float f13 = f6;
                    float f14 = f5;
                    f6 = fArray[n3 + 0];
                    f5 = fArray[n3 + 1];
                    n = Crossing2F.intersectLine(f13, f14, f6, f5, f9, f10, f11, f12);
                    break;
                }
                case QUADTO: {
                    float f15 = f6;
                    float f16 = f5;
                    f6 = fArray[n3 + 2];
                    f5 = fArray[n3 + 3];
                    n = Crossing2F.intersectQuad(f15, f16, fArray[n3 + 0], fArray[n3 + 1], f6, f5, f9, f10, f11, f12);
                    break;
                }
                case CUBICTO: {
                    float f17 = f6;
                    float f18 = f5;
                    f6 = fArray[n3 + 4];
                    f5 = fArray[n3 + 5];
                    n = Crossing2F.intersectCubic(f17, f18, fArray[n3 + 0], fArray[n3 + 1], fArray[n3 + 2], fArray[n3 + 3], f6, f5, f9, f10, f11, f12);
                    break;
                }
                case CLOSE: {
                    if (f5 != f7 || f6 != f8) {
                        n = Crossing2F.intersectLine(f6, f5, f8, f7, f9, f10, f11, f12);
                    }
                    f6 = f8;
                    f5 = f7;
                }
            }
            if (n == 255) {
                return 255;
            }
            n2 += n;
        }
        if (f5 != f7) {
            n = Crossing2F.intersectLine(f6, f5, f8, f7, f9, f10, f11, f12);
            if (n == 255) {
                return 255;
            }
            n2 += n;
        }
        return n2;
    }

    public static int intersectShape(Path2F path2F, float f, float f2, float f3, float f4) {
        if (!path2F.getBounds2D().intersects2DRegion(f, f2, f3, f4)) {
            return 0;
        }
        return Crossing2F.intersectPath(path2F.iterator(null), f, f2, f3, f4);
    }

    public static boolean isInsideNonZero(int n) {
        return n != 0;
    }

    public static boolean isInsideEvenOdd(int n) {
        return (n & 1) != 0;
    }

    public static class CubicCurve {
        float ax;
        float ay;
        float bx;
        float by;
        float cx;
        float cy;
        float Ax;
        float Ay;
        float Bx;
        float By;
        float Cx;
        float Cy;
        float Ax3;
        float Bx2;

        public CubicCurve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.ax = f7 - f;
            this.ay = f8 - f2;
            this.bx = f3 - f;
            this.by = f4 - f2;
            this.cx = f5 - f;
            this.cy = f6 - f2;
            this.Cx = this.bx + this.bx + this.bx;
            this.Bx = this.cx + this.cx + this.cx - this.Cx - this.Cx;
            this.Ax = this.ax - this.Bx - this.Cx;
            this.Cy = this.by + this.by + this.by;
            this.By = this.cy + this.cy + this.cy - this.Cy - this.Cy;
            this.Ay = this.ay - this.By - this.Cy;
            this.Ax3 = this.Ax + this.Ax + this.Ax;
            this.Bx2 = this.Bx + this.Bx;
        }

        int cross(float[] fArray, int n, float f, float f2) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                float f3 = fArray[i];
                if (f3 < -1.0E-5f || f3 > 1.00001f) continue;
                if (f3 < 1.0E-5f) {
                    if (!((double)f < 0.0)) continue;
                    float f4 = (double)this.bx != 0.0 ? this.bx : (this.cx != this.bx ? this.cx - this.bx : this.ax - this.cx);
                    if (!((double)f4 < 0.0)) continue;
                    --n2;
                    continue;
                }
                if (f3 > 0.99999f) {
                    if (!(f < this.ay)) continue;
                    float f5 = this.ax != this.cx ? this.ax - this.cx : (this.cx != this.bx ? this.cx - this.bx : this.bx);
                    if (!((double)f5 > 0.0)) continue;
                    ++n2;
                    continue;
                }
                float f6 = f3 * (f3 * (f3 * this.Ay + this.By) + this.Cy);
                if (!(f6 > f2)) continue;
                float f7 = f3 * (f3 * this.Ax3 + this.Bx2) + this.Cx;
                if (f7 > -1.0E-5f && f7 < 1.0E-5f) {
                    f7 = f3 * (this.Ax3 + this.Ax3) + this.Bx2;
                    if (f7 < -1.0E-5f || f7 > 1.0E-5f) continue;
                    f7 = this.ax;
                }
                n2 += (double)f7 > 0.0 ? 1 : -1;
            }
            return n2;
        }

        int solvePoint(float[] fArray, float f) {
            float[] fArray2 = new float[]{-f, this.Cx, this.Bx, this.Ax};
            return Crossing2F.solveCubic(fArray2, fArray);
        }

        int solveExtremX(float[] fArray) {
            float[] fArray2 = new float[]{this.Cx, this.Bx2, this.Ax3};
            return Crossing2F.solveQuad(fArray2, fArray);
        }

        int solveExtremY(float[] fArray) {
            float[] fArray2 = new float[]{this.Cy, this.By + this.By, this.Ay + this.Ay + this.Ay};
            return Crossing2F.solveQuad(fArray2, fArray);
        }

        int addBound(float[] fArray, int n, float[] fArray2, int n2, float f, float f2, boolean bl, int n3) {
            for (int i = 0; i < n2; ++i) {
                float f3;
                float f4 = fArray2[i];
                if (!(f4 > -1.0E-5f) || !(f4 < 1.00001f) || !(f <= (f3 = f4 * (f4 * (f4 * this.Ax + this.Bx) + this.Cx))) || !(f3 <= f2)) continue;
                fArray[n++] = f4;
                fArray[n++] = f3;
                fArray[n++] = f4 * (f4 * (f4 * this.Ay + this.By) + this.Cy);
                fArray[n++] = n3;
                if (!bl) continue;
                ++n3;
            }
            return n;
        }
    }

    public static class QuadCurve {
        float ax;
        float ay;
        float bx;
        float by;
        float Ax;
        float Ay;
        float Bx;
        float By;

        public QuadCurve(float f, float f2, float f3, float f4, float f5, float f6) {
            this.ax = f5 - f;
            this.ay = f6 - f2;
            this.bx = f3 - f;
            this.by = f4 - f2;
            this.Bx = this.bx + this.bx;
            this.Ax = this.ax - this.Bx;
            this.By = this.by + this.by;
            this.Ay = this.ay - this.By;
        }

        int cross(float[] fArray, int n, float f, float f2) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                float f3;
                float f4 = fArray[i];
                if (f4 < -1.0E-5f || f4 > 1.00001f) continue;
                if (f4 < 1.0E-5f) {
                    if (!((double)f < 0.0)) continue;
                    float f5 = (double)this.bx != 0.0 ? this.bx : this.ax - this.bx;
                    if (!((double)f5 < 0.0)) continue;
                    --n2;
                    continue;
                }
                if (f4 > 0.99999f) {
                    if (!(f < this.ay)) continue;
                    float f6 = this.ax != this.bx ? this.ax - this.bx : this.bx;
                    if (!((double)f6 > 0.0)) continue;
                    ++n2;
                    continue;
                }
                float f7 = f4 * (f4 * this.Ay + this.By);
                if (!(f7 > f2) || (f3 = f4 * this.Ax + this.bx) > -1.0E-5f && f3 < 1.0E-5f) continue;
                n2 += (double)f3 > 0.0 ? 1 : -1;
            }
            return n2;
        }

        int solvePoint(float[] fArray, float f) {
            float[] fArray2 = new float[]{-f, this.Bx, this.Ax};
            return Crossing2F.solveQuad(fArray2, fArray);
        }

        int solveExtrem(float[] fArray) {
            int n = 0;
            if ((double)this.Ax != 0.0) {
                fArray[n++] = -this.Bx / (this.Ax + this.Ax);
            }
            if ((double)this.Ay != 0.0) {
                fArray[n++] = -this.By / (this.Ay + this.Ay);
            }
            return n;
        }

        int addBound(float[] fArray, int n, float[] fArray2, int n2, float f, float f2, boolean bl, int n3) {
            for (int i = 0; i < n2; ++i) {
                float f3;
                float f4 = fArray2[i];
                if (!(f4 > -1.0E-5f) || !(f4 < 1.00001f) || !(f <= (f3 = f4 * (f4 * this.Ax + this.Bx))) || !(f3 <= f2)) continue;
                fArray[n++] = f4;
                fArray[n++] = f3;
                fArray[n++] = f4 * (f4 * this.Ay + this.By);
                fArray[n++] = n3;
                if (!bl) continue;
                ++n3;
            }
            return n;
        }
    }
}

