/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.CompositeRule;
import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.SVGComposite;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractColorInterpolationRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.CompositeRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.PaintRable;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CompositeRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.FloodRed;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.ArrayList;
import java.util.List;

public class CompositeRable8Bit
extends AbstractColorInterpolationRable
implements CompositeRable,
PaintRable {
    protected CompositeRule rule;

    public CompositeRable8Bit(List<? extends RenderableImage> list, CompositeRule compositeRule, boolean bl) {
        super(list);
        this.setColorSpaceLinear(bl);
        this.rule = compositeRule;
    }

    @Override
    public void setSources(List<? extends RenderableImage> list) {
        this.init(list, null);
    }

    @Override
    public void setCompositeRule(CompositeRule compositeRule) {
        this.touch();
        this.rule = compositeRule;
    }

    @Override
    public CompositeRule getCompositeRule() {
        return this.rule;
    }

    @Override
    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        if (this.getCompositeRule() != CompositeRule.OVER) {
            return false;
        }
        ColorSpace colorSpace = this.getOperationColorSpace();
        ColorSpace colorSpace2 = GraphicsUtil.getDestinationColorSpace(graphics2D);
        if (colorSpace2 == null || colorSpace2 != colorSpace) {
            return false;
        }
        for (RenderableImage renderableImage : this.getSources()) {
            GraphicsUtil.drawImage(graphics2D, renderableImage);
        }
        return true;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        if (this.getSources().size() == 0) {
            return null;
        }
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            rectangle2D2 = this.getBounds2D();
        } else {
            rectangle2D2 = shape.getBounds2D();
            rectangle2D = this.getBounds2D();
            if (!rectangle2D.intersects(rectangle2D2)) {
                return null;
            }
            Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D2);
        }
        rectangle2D = affineTransform.createTransformedShape(rectangle2D2).getBounds();
        renderContext = new RenderContext(affineTransform, rectangle2D2, renderingHints);
        ArrayList<CachableRed> arrayList = new ArrayList<CachableRed>();
        for (RenderableImage renderableImage : this.getSources()) {
            Filter filter = (Filter)renderableImage;
            RenderedImage renderedImage = filter.createRendering(renderContext);
            if (renderedImage != null) {
                CachableRed cachableRed = this.convertSourceCS(renderedImage);
                arrayList.add(cachableRed);
                continue;
            }
            switch (this.rule.getRule()) {
                case 2: {
                    return null;
                }
                case 3: {
                    arrayList.clear();
                    break;
                }
                case 6: {
                    arrayList.add(new FloodRed((Rectangle)rectangle2D));
                    break;
                }
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        CompositeRed compositeRed = new CompositeRed(arrayList, this.rule);
        return compositeRed;
    }
}

