/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.rendered;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BufferedImageCachableRed
extends AbstractRed {
    BufferedImage bi;

    public BufferedImageCachableRed(BufferedImage bufferedImage) {
        super((CachableRed)null, new Rectangle(bufferedImage.getMinX(), bufferedImage.getMinY(), bufferedImage.getWidth(), bufferedImage.getHeight()), bufferedImage.getColorModel(), bufferedImage.getSampleModel(), bufferedImage.getMinX(), bufferedImage.getMinY(), null);
        this.bi = bufferedImage;
    }

    public BufferedImageCachableRed(BufferedImage bufferedImage, int n, int n2) {
        super((CachableRed)null, new Rectangle(n, n2, bufferedImage.getWidth(), bufferedImage.getHeight()), bufferedImage.getColorModel(), bufferedImage.getSampleModel(), n, n2, null);
        this.bi = bufferedImage;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    @Override
    public Object getProperty(String string) {
        return this.bi.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.bi.getPropertyNames();
    }

    @Override
    public Raster getTile(int n, int n2) {
        return this.bi.getTile(n, n2);
    }

    @Override
    public Raster getData() {
        Raster raster = this.bi.getData();
        return raster.createTranslatedChild(this.getMinX(), this.getMinY());
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        if (!rectangle2.intersects(this.getBounds())) {
            return null;
        }
        rectangle2 = rectangle2.intersection(this.getBounds());
        rectangle2.translate(-this.getMinX(), -this.getMinY());
        Raster raster = this.bi.getData(rectangle2);
        return raster.createTranslatedChild(raster.getMinX() + this.getMinX(), raster.getMinY() + this.getMinY());
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        WritableRaster writableRaster2 = writableRaster.createWritableTranslatedChild(writableRaster.getMinX() - this.getMinX(), writableRaster.getMinY() - this.getMinY());
        GraphicsUtil.copyData(this.bi.getRaster(), writableRaster2);
        return writableRaster;
    }
}

