/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class TokenParser
implements Iterator<String> {
    private String l;
    private char[] sep;
    private char[] delim;
    private boolean last_token_found = false;
    private String next = null;
    private boolean ignore_consecutive_sep = false;
    private final boolean keepDelimiters;
    private char nextDelimiter = '\u0000';
    private static final String DEFAULT_SEPARATOR = ", ";
    private static final String DEFAULT_DELIMITER = "\"";
    private static final int SEPARATOR_SIZE = 1;
    private char last_separator = '\u0000';
    private char next_separator = '\u0000';
    private final int ll;
    int ncom = -1;
    private int i = -1;
    private int lastdelim;

    public TokenParser(String string) {
        this(string, DEFAULT_SEPARATOR);
    }

    public TokenParser(String string, String string2) {
        this(string, string2, DEFAULT_DELIMITER);
    }

    public TokenParser(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public TokenParser(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3.toCharArray(), bl);
    }

    TokenParser(String string, String string2, char[] cArray, boolean bl) {
        this.l = string;
        this.keepDelimiters = bl;
        if (string2 == null || string2.length() == 0) {
            this.next = this.l;
            this.last_token_found = true;
            this.ll = 0;
            return;
        }
        this.sep = string2.toCharArray();
        this.checkSeparators();
        this.delim = cArray;
        boolean bl2 = this.ignore_consecutive_sep = this.isSeparator(' ') || this.isSeparator('\t');
        if (this.l == null || this.l.length() == 0) {
            this.next = null;
            this.ll = 0;
            return;
        }
        this.ll = this.l.length();
        this.findNext();
    }

    private void checkSeparators() {
        for (int i = 0; i < this.sep.length; ++i) {
            if (this.sep[i] != '\u0000') continue;
            throw new IllegalArgumentException("Separator cannot contain \\0");
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasMoreTokens() {
        return this.hasNext();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.next;
        this.last_separator = this.next_separator;
        this.findNext();
        return string;
    }

    public String nextToken() {
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void findNext() {
        if (this.last_token_found) {
            this.next = null;
            return;
        }
        int n = this.i + 1;
        StringBuilder stringBuilder = new StringBuilder();
        while (++this.i < this.ll - 1) {
            if (this.isDelimiter(this.l.charAt(this.i))) {
                this.setNextDelimiter();
                if (this.i - 1 > n) {
                    this.appendToToken(stringBuilder, this.i, n);
                } else if (this.keepDelimiters) {
                    stringBuilder.append(this.l.subSequence(this.i, this.i + 1));
                }
                n = this.i + 1;
                do {
                    ++this.i;
                } while (!this.isNextDelimiter(this.l.charAt(this.i)) && this.i < this.ll - 1);
                if (this.i >= this.ll - 1) break;
                ++this.ncom;
                this.appendToToken(stringBuilder, this.i, n);
                n = this.i + 1;
                continue;
            }
            if (!this.isSeparator(this.l.charAt(this.i))) continue;
            ++this.ncom;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(this.l.subSequence(n, this.i));
                this.next = stringBuilder.toString();
            } else {
                this.next = this.l.substring(n, this.i);
            }
            this.setNextSeparator(this.l.charAt(this.i));
            if (this.ignore_consecutive_sep) {
                for (n = this.i + 1; n < this.ll && this.isSeparator(this.l.charAt(n)); ++n) {
                    ++this.i;
                }
            }
            return;
        }
        ++this.ncom;
        if (this.i == this.ll) {
            this.last_token_found = true;
            return;
        }
        if (this.isDelimiter(this.l.charAt(this.ll - 1))) {
            this.i = this.ll - 2;
        }
        if (stringBuilder.length() > 0) {
            this.appendToToken(stringBuilder, this.i + 1, n);
            this.next = stringBuilder.toString();
        } else {
            this.next = this.l.substring(n, this.i + 1);
        }
        ++this.ncom;
        this.last_token_found = true;
    }

    private void appendToToken(StringBuilder stringBuilder, int n, int n2) {
        if (this.keepDelimiters) {
            ++n;
        }
        stringBuilder.append(this.l.subSequence(n2, n));
    }

    private boolean isDelimiter(char c) {
        this.lastdelim = TokenParser.charInArray(this.l.charAt(this.i), this.delim);
        return this.lastdelim >= 0 || c == this.nextDelimiter;
    }

    private void setNextDelimiter() {
        this.nextDelimiter = this.delim[this.lastdelim];
        switch (this.nextDelimiter) {
            case '(': {
                this.nextDelimiter = (char)41;
                break;
            }
            case '[': {
                this.nextDelimiter = (char)93;
                break;
            }
            case '{': {
                this.nextDelimiter = (char)125;
            }
        }
    }

    private boolean isNextDelimiter(char c) {
        return c == this.nextDelimiter;
    }

    private boolean isSeparator(char c) {
        return TokenParser.charInArray(c, this.sep) >= 0;
    }

    private static int charInArray(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    private void setNextSeparator(char c) {
        this.next_separator = c;
    }

    public char getLastSeparator() {
        if (this.last_separator == '\u0000') {
            throw new IllegalStateException("Neeed to call next() before using this method");
        }
        return this.last_separator;
    }

    public char getNextSeparator() {
        if (this.next_separator == '\u0000') {
            throw new IllegalStateException("No separators in this text!");
        }
        return this.next_separator;
    }

    public boolean hasMultipleTokens() {
        return this.next_separator != '\u0000';
    }

    public static String[] tokenize(String string, String string2, char[] cArray, int n) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (string2 == null || string2.equals("")) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        TokenParser tokenParser = new TokenParser(string, string2, cArray, false);
        while (tokenParser.hasNext()) {
            linkedList.add(tokenParser.next());
        }
        return linkedList.toArray(new String[0]);
    }
}

