/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.doc.style.Alignable;
import io.sf.jclf.text.format.ExponentFormat;
import io.sf.jclf.text.format.FloatFormat;
import io.sf.jclf.text.format.HexFormat;
import io.sf.jclf.text.format.IntegerFormat;
import io.sf.jclf.text.format.OctalFormat;
import io.sf.jclf.text.format.SpecParsingException;
import io.sf.jclf.text.format.StringFormat;
import io.sf.jclf.text.format.TemplateDateFormat;
import io.sf.jclf.text.format.TextFormat;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public abstract class ObjectFormat
implements Alignable {
    protected char[] flags = null;
    protected boolean ralign = true;
    protected int width = 0;
    protected int precision = -1;

    protected ObjectFormat() {
    }

    public static ObjectFormat create(String string) throws SpecParsingException {
        ObjectFormat objectFormat;
        int n = string.length();
        char c = string.charAt(n - 1);
        switch (c) {
            case 'S': 
            case 's': {
                objectFormat = new StringFormat();
                break;
            }
            case 'T': {
                objectFormat = new TextFormat();
                break;
            }
            case 'D': {
                objectFormat = new TemplateDateFormat();
                break;
            }
            case 'G': 
            case 'f': 
            case 'g': {
                objectFormat = new FloatFormat();
                break;
            }
            case 'E': 
            case 'e': {
                objectFormat = new ExponentFormat();
                break;
            }
            case 'd': 
            case 'i': 
            case 'u': {
                objectFormat = new IntegerFormat();
                break;
            }
            case 'o': {
                objectFormat = new OctalFormat();
                break;
            }
            case 'x': {
                objectFormat = new HexFormat();
                break;
            }
            default: {
                throw new SpecParsingException("Unknown type: " + string);
            }
        }
        objectFormat.setFormat(string);
        return objectFormat;
    }

    public static ObjectFormat create(Class<?> clazz, int n, int n2) throws SpecParsingException {
        if (clazz.equals(String.class)) {
            return ObjectFormat.create(clazz, n, n2, false);
        }
        return ObjectFormat.create(clazz, n, n2, true);
    }

    public static ObjectFormat create(Class<?> clazz, int n, int n2, boolean bl) throws SpecParsingException {
        ObjectFormat objectFormat;
        if (clazz.equals(String.class)) {
            objectFormat = new StringFormat();
        } else if (clazz.equals(Float.class)) {
            objectFormat = new FloatFormat();
        } else if (clazz.equals(Double.class)) {
            objectFormat = new ExponentFormat();
        } else if (clazz.equals(Integer.class)) {
            objectFormat = new IntegerFormat();
        } else if (clazz.equals(Long.class)) {
            objectFormat = new IntegerFormat();
        } else if (clazz.equals(Date.class) || clazz.equals(Timestamp.class) || clazz.equals(Time.class)) {
            objectFormat = new TemplateDateFormat();
        } else {
            throw new SpecParsingException("Cannot format class: " + clazz.getName());
        }
        objectFormat.width = n;
        objectFormat.precision = n2;
        objectFormat.ralign = bl;
        return objectFormat;
    }

    protected char setFormat(String string) throws SpecParsingException {
        int n;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        int n3 = string.indexOf(46);
        if (n3 < 0) {
            n3 = n2 - 2;
        } else {
            this.precision = Integer.parseInt(string.substring(n3 + 1, n2 - 1));
            --n3;
        }
        for (n = n3; n >= 0 && Character.isDigit(string.charAt(n)); --n) {
        }
        if (n == n3) {
            this.width = 0;
        } else if (string.charAt(n + 1) == '0') {
            if (++n == n3) {
                this.width = 0;
            } else {
                this.parseWidth(string, n3, n);
            }
        } else {
            this.parseWidth(string, n3, n);
        }
        this.flags = (char[])(n < 0 ? null : string.substring(0, n + 1).toCharArray());
        if (this.flags != null) {
            this.setFlags(this.flags);
        }
        return c;
    }

    private void parseWidth(String string, int n, int n2) {
        String string2 = string.substring(n2 + 1, n + 1);
        this.width = Integer.parseInt(string2);
    }

    protected void setFlags(char[] cArray) throws SpecParsingException {
        for (int i = 0; i < cArray.length; ++i) {
            if (this.setFlag(cArray[i], i)) continue;
            throw new SpecParsingException("Unknown or wrong flag: " + cArray[i]);
        }
    }

    protected boolean setFlag(char c, int n) {
        switch (c) {
            case '-': {
                this.ralign = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected final void rightAppend(StringBuilder stringBuilder, String string, char c, int n, int n2) {
        int n3 = string.length();
        if (n != 0 && n3 < n) {
            int n4 = n - n3;
            for (int i = 0; i < n4; ++i) {
                stringBuilder.append(c);
            }
            stringBuilder.append(string);
            return;
        }
        if (n2 == 0 || n3 <= n2) {
            stringBuilder.append(string);
            return;
        }
        stringBuilder.append(string.substring(0, n2));
    }

    protected final String expandLeftToWidth(String string, char c) {
        if (this.width == 0) {
            return string;
        }
        int n = this.width - string.length();
        if (n <= 0) {
            return string;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
        return new StringBuilder(this.width).append(cArray).append(string).toString();
    }

    protected final String expandRightToWidth(String string) {
        if (this.width == 0) {
            return string;
        }
        int n = this.width - string.length();
        if (n <= 0) {
            return string;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return new StringBuilder(this.width).append(string).append(cArray).toString();
    }

    @Override
    public void align(int n) {
        switch (n) {
            case 2: {
                this.ralign = true;
                break;
            }
            case 1: {
                this.ralign = false;
            }
        }
    }

    @Override
    public int getAlignment() {
        return this.ralign ? 2 : 1;
    }

    static String leftJustify(String string, char c, int n, char c2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot left-justify String with zero width");
        }
        int n2 = n - string.length();
        if (n2 == 0) {
            return string;
        }
        if (n2 < 0) {
            return new StringBuilder(n).append(string.substring(0, n - 1)).append(c2).toString();
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = c;
        }
        return new StringBuilder(n).append(string).append(cArray).toString();
    }

    static String rightJustify(String string, char c, int n, char c2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot right-justify String with zero width");
        }
        int n2 = n - string.length();
        if (n2 == 0) {
            return string;
        }
        if (n2 < 0) {
            return new StringBuilder(n).append(c2).append(string.substring(-n2 + 1)).toString();
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = c;
        }
        return new StringBuilder(n).append(cArray).append(string).toString();
    }

    public abstract String format(Object var1);

    public abstract Object sample();
}

