/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.Messages;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class BridgeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected Element e;
    protected String code;
    protected String message;
    protected Object[] params;
    protected int line;
    protected GraphicsNode node;

    public BridgeException(BridgeContext bridgeContext, LiveAttributeException liveAttributeException) {
        switch (liveAttributeException.getCode()) {
            case 0: {
                this.code = "attribute.missing";
                break;
            }
            case 1: {
                this.code = "attribute.malformed";
                break;
            }
            case 2: {
                this.code = "length.negative";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown LiveAttributeException error code " + liveAttributeException.getCode());
            }
        }
        this.e = liveAttributeException.getElement();
        this.params = new Object[]{liveAttributeException.getAttributeName(), liveAttributeException.getValue()};
        if (this.e != null && bridgeContext != null) {
            this.line = bridgeContext.getDocumentLoader().getLineNumber(this.e);
        }
    }

    public BridgeException(BridgeContext bridgeContext, Element element, String string, Object[] objectArray) {
        this.e = element;
        this.code = string;
        this.params = objectArray;
        if (element != null && bridgeContext != null) {
            this.line = bridgeContext.getDocumentLoader().getLineNumber(element);
        }
    }

    public BridgeException(BridgeContext bridgeContext, Element element, Exception exception, String string, Object[] objectArray) {
        this.e = element;
        this.message = exception.getMessage();
        this.code = string;
        this.params = objectArray;
        if (element != null && bridgeContext != null) {
            this.line = bridgeContext.getDocumentLoader().getLineNumber(element);
        }
    }

    public BridgeException(BridgeContext bridgeContext, Element element, String string) {
        this.e = element;
        this.message = string;
        if (element != null && bridgeContext != null) {
            this.line = bridgeContext.getDocumentLoader().getLineNumber(element);
        }
    }

    public Element getElement() {
        return this.e;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        this.node = graphicsNode;
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        String string = "<Unknown Element>";
        SVGDocument sVGDocument = null;
        if (this.e != null) {
            sVGDocument = (SVGDocument)this.e.getOwnerDocument();
            string = this.e.getLocalName();
        }
        String string2 = sVGDocument == null ? "<Unknown Document>" : sVGDocument.getURL();
        Object[] objectArray = new Object[this.params.length + 3];
        objectArray[0] = string2;
        objectArray[1] = this.line;
        objectArray[2] = string;
        System.arraycopy(this.params, 0, objectArray, 3, this.params.length);
        return Messages.formatMessage(this.code, objectArray);
    }

    public String getCode() {
        return this.code;
    }
}

