/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.MarkerBridge;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.SVGColorProfileElementBridge;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.svg.ICCColor;
import io.sf.carte.echosvg.css.engine.value.svg12.CIELabColor;
import io.sf.carte.echosvg.css.engine.value.svg12.DeviceColor;
import io.sf.carte.echosvg.css.engine.value.svg12.ICCNamedColor;
import io.sf.carte.echosvg.gvt.CompositeShapePainter;
import io.sf.carte.echosvg.gvt.FillShapePainter;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.Marker;
import io.sf.carte.echosvg.gvt.MarkerShapePainter;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import io.sf.carte.echosvg.gvt.StrokeShapePainter;
import io.sf.carte.echosvg.util.CSSConstants;
import io.sf.carte.echosvg.util.SVGConstants;
import io.sf.graphics.java2d.color.CIELabColorSpace;
import io.sf.graphics.java2d.color.ColorSpaces;
import io.sf.graphics.java2d.color.ColorWithAlternatives;
import io.sf.graphics.java2d.color.DeviceCMYKColorSpace;
import io.sf.graphics.java2d.color.ICCColorSpaceWithIntent;
import io.sf.graphics.java2d.color.NamedColorSpace;
import io.sf.graphics.java2d.color.profile.NamedColorProfile;
import io.sf.graphics.java2d.color.profile.NamedColorProfileParser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.w3c.dom.Element;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 36);
        Marker marker = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 35);
        Marker marker2 = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 34);
        Marker marker3 = PaintServer.convertMarker(element, value, bridgeContext);
        if (marker != null || marker2 != null || marker3 != null) {
            MarkerShapePainter markerShapePainter = new MarkerShapePainter(shapeNode.getShape());
            markerShapePainter.setStartMarker(marker);
            markerShapePainter.setMiddleMarker(marker2);
            markerShapePainter.setEndMarker(marker3);
            return markerShapePainter;
        }
        return null;
    }

    public static Marker convertMarker(Element element, Value value, BridgeContext bridgeContext) {
        if (value.getPrimitiveType() == 21) {
            return null;
        }
        String string = value.getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        if (element2 == null) {
            return null;
        }
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null) {
            return null;
        }
        if (!(bridge instanceof MarkerBridge)) {
            BridgeException bridgeException = new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
            UserAgent userAgent = bridgeContext.getUserAgent();
            if (userAgent == null) {
                throw bridgeException;
            }
            userAgent.displayError(bridgeException);
            return null;
        }
        return ((MarkerBridge)bridge).createMarker(bridgeContext, element2, element);
    }

    public static ShapePainter convertFillAndStroke(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Shape shape = shapeNode.getShape();
        if (shape == null) {
            return null;
        }
        Paint paint = PaintServer.convertFillPaint(element, (GraphicsNode)shapeNode, bridgeContext);
        FillShapePainter fillShapePainter = new FillShapePainter(shape);
        fillShapePainter.setPaint(paint);
        Stroke stroke = PaintServer.convertStroke(element);
        if (stroke == null) {
            return fillShapePainter;
        }
        Paint paint2 = PaintServer.convertStrokePaint(element, (GraphicsNode)shapeNode, bridgeContext);
        StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
        strokeShapePainter.setStroke(stroke);
        strokeShapePainter.setPaint(paint2);
        CompositeShapePainter compositeShapePainter = new CompositeShapePainter(shape);
        compositeShapePainter.addShapePainter((ShapePainter)fillShapePainter);
        compositeShapePainter.addShapePainter((ShapePainter)strokeShapePainter);
        return compositeShapePainter;
    }

    public static ShapePainter convertStrokePainter(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Shape shape = shapeNode.getShape();
        if (shape == null) {
            return null;
        }
        Stroke stroke = PaintServer.convertStroke(element);
        if (stroke == null) {
            return null;
        }
        Paint paint = PaintServer.convertStrokePaint(element, (GraphicsNode)shapeNode, bridgeContext);
        StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
        strokeShapePainter.setStroke(stroke);
        strokeShapePainter.setPaint(paint);
        return strokeShapePainter;
    }

    public static Paint convertStrokePaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 51);
        float f = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 45);
        return PaintServer.convertPaint(element, graphicsNode, value, f, bridgeContext);
    }

    public static Paint convertFillPaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 16);
        float f = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 15);
        return PaintServer.convertPaint(element, graphicsNode, value, f, bridgeContext);
    }

    public static Paint convertPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 21: {
                    return null;
                }
                case 25: {
                    return PaintServer.convertColor(value, f);
                }
                case 20: {
                    return PaintServer.convertURIPaint(element, graphicsNode, value, f, bridgeContext);
                }
            }
            throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
        }
        Value value2 = value.item(0);
        switch (value2.getPrimitiveType()) {
            case 25: {
                return PaintServer.convertRGBICCColor(element, value2, value.item(1), f, bridgeContext);
            }
            case 20: {
                Paint paint = PaintServer.silentConvertURIPaint(element, graphicsNode, value2, f, bridgeContext);
                if (paint != null) {
                    return paint;
                }
                value2 = value.item(1);
                switch (value2.getPrimitiveType()) {
                    case 21: {
                        return null;
                    }
                    case 25: {
                        if (value.getLength() == 2) {
                            return PaintServer.convertColor(value2, f);
                        }
                        return PaintServer.convertRGBICCColor(element, value2, value.item(2), f, bridgeContext);
                    }
                }
                throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
            }
        }
        throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
    }

    public static Paint silentConvertURIPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(element, graphicsNode, value, f, bridgeContext);
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        String string = value.getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        if (element2 == null) {
            return null;
        }
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null) {
            return null;
        }
        if (!(bridge instanceof PaintBridge)) {
            BridgeException bridgeException = new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
            UserAgent userAgent = bridgeContext.getUserAgent();
            if (userAgent == null) {
                throw bridgeException;
            }
            userAgent.displayError(bridgeException);
            return null;
        }
        return ((PaintBridge)bridge).createPaint(bridgeContext, element2, element, graphicsNode, f);
    }

    public static Color convertRGBICCColor(Element element, Value value, Value value2, float f, BridgeContext bridgeContext) {
        Color color = null;
        if (value2 != null) {
            if (value2 instanceof ICCColor) {
                color = PaintServer.convertICCColor(element, (ICCColor)value2, f, bridgeContext);
            } else if (value2 instanceof ICCNamedColor) {
                color = PaintServer.convertICCNamedColor(element, (ICCNamedColor)value2, f, bridgeContext);
            } else if (value2 instanceof CIELabColor) {
                color = PaintServer.convertCIELabColor(element, (CIELabColor)value2, f, bridgeContext);
            } else if (value2 instanceof DeviceColor) {
                color = PaintServer.convertDeviceColor(element, value, (DeviceColor)value2, f, bridgeContext);
            }
        }
        if (color == null) {
            color = PaintServer.convertColor(value, f);
        }
        return color;
    }

    public static Color convertICCColor(Element element, ICCColor iCCColor, float f, BridgeContext bridgeContext) {
        String string = iCCColor.getColorProfile();
        if (string == null) {
            return null;
        }
        SVGColorProfileElementBridge sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (sVGColorProfileElementBridge == null) {
            return null;
        }
        ICCColorSpaceWithIntent iCCColorSpaceWithIntent = sVGColorProfileElementBridge.createICCColorSpaceWithIntent(bridgeContext, element, string);
        if (iCCColorSpaceWithIntent == null) {
            return null;
        }
        int n = iCCColor.getNumberOfColors();
        float[] fArray = new float[n];
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            fArray[i] = iCCColor.getColor(i);
        }
        float[] fArray2 = iCCColorSpaceWithIntent.intendedToRGB(fArray);
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    public static Color convertICCNamedColor(Element element, ICCNamedColor iCCNamedColor, float f, BridgeContext bridgeContext) {
        String string = iCCNamedColor.getColorProfile();
        if (string == null) {
            return null;
        }
        SVGColorProfileElementBridge sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (sVGColorProfileElementBridge == null) {
            return null;
        }
        ICCColorSpaceWithIntent iCCColorSpaceWithIntent = sVGColorProfileElementBridge.createICCColorSpaceWithIntent(bridgeContext, element, string);
        if (iCCColorSpaceWithIntent == null) {
            return null;
        }
        ICC_Profile iCC_Profile = iCCColorSpaceWithIntent.getProfile();
        String string2 = null;
        if (NamedColorProfileParser.isNamedColorProfile((ICC_Profile)iCC_Profile)) {
            NamedColorProfile namedColorProfile;
            NamedColorProfileParser namedColorProfileParser = new NamedColorProfileParser();
            try {
                namedColorProfile = namedColorProfileParser.parseProfile(iCC_Profile, string, string2);
            }
            catch (IOException iOException) {
                return null;
            }
            NamedColorSpace namedColorSpace = namedColorProfile.getNamedColor(iCCNamedColor.getColorName());
            if (namedColorSpace != null) {
                ColorWithAlternatives colorWithAlternatives = new ColorWithAlternatives((ColorSpace)namedColorSpace, new float[]{1.0f}, f, null);
                return colorWithAlternatives;
            }
        }
        return null;
    }

    public static Color convertCIELabColor(Element element, CIELabColor cIELabColor, float f, BridgeContext bridgeContext) {
        CIELabColorSpace cIELabColorSpace = new CIELabColorSpace(cIELabColor.getWhitePoint());
        float[] fArray = cIELabColor.getColorValues();
        Color color = cIELabColorSpace.toColor(fArray[0], fArray[1], fArray[2], f);
        return color;
    }

    public static Color convertDeviceColor(Element element, Value value, DeviceColor deviceColor, float f, BridgeContext bridgeContext) {
        if (deviceColor.isNChannel()) {
            return PaintServer.convertColor(value, f);
        }
        if (deviceColor.getNumberOfColors() == 4) {
            DeviceCMYKColorSpace deviceCMYKColorSpace = ColorSpaces.getDeviceCMYKColorSpace();
            float[] fArray = new float[4];
            for (int i = 0; i < 4; ++i) {
                fArray[i] = deviceColor.getColor(i);
            }
            ColorWithAlternatives colorWithAlternatives = new ColorWithAlternatives((ColorSpace)deviceCMYKColorSpace, fArray, f, null);
            int n = PaintServer.resolveColorComponent(value.getRed());
            int n2 = PaintServer.resolveColorComponent(value.getGreen());
            int n3 = PaintServer.resolveColorComponent(value.getBlue());
            float f2 = PaintServer.resolveAlphaComponent(deviceColor.getAlpha());
            ColorWithAlternatives colorWithAlternatives2 = new ColorWithAlternatives(n, n2, n3, Math.round(f2 * f * 255.0f), new Color[]{colorWithAlternatives});
            return colorWithAlternatives2;
        }
        return PaintServer.convertColor(value, f);
    }

    public static Color convertColor(Value value, float f) {
        int n = PaintServer.resolveColorComponent(value.getRed());
        int n2 = PaintServer.resolveColorComponent(value.getGreen());
        int n3 = PaintServer.resolveColorComponent(value.getBlue());
        float f2 = PaintServer.resolveAlphaComponent(value.getAlpha());
        return new Color(n, n2, n3, Math.round(f2 * f * 255.0f));
    }

    public static Stroke convertStroke(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 52);
        float f = value.getFloatValue();
        if (f == 0.0f) {
            return null;
        }
        value = CSSUtilities.getComputedStyle(element, 48);
        int n = PaintServer.convertStrokeLinecap(value);
        value = CSSUtilities.getComputedStyle(element, 49);
        int n2 = PaintServer.convertStrokeLinejoin(value);
        value = CSSUtilities.getComputedStyle(element, 50);
        float f2 = PaintServer.convertStrokeMiterlimit(value);
        value = CSSUtilities.getComputedStyle(element, 46);
        float[] fArray = PaintServer.convertStrokeDasharray(value);
        float f3 = 0.0f;
        if (fArray != null && (f3 = (value = CSSUtilities.getComputedStyle(element, 47)).getFloatValue()) < 0.0f) {
            float f4 = 0.0f;
            for (float f5 : fArray) {
                f4 += f5;
            }
            if (fArray.length % 2 != 0) {
                f4 *= 2.0f;
            }
            if (f4 == 0.0f) {
                f3 = 0.0f;
            } else {
                while (f3 < 0.0f) {
                    f3 += f4;
                }
            }
        }
        return new BasicStroke(f, n, n2, f2, fArray, f3);
    }

    public static float[] convertStrokeDasharray(Value value) {
        float[] fArray = null;
        if (value.getCssValueType() == 2) {
            int n = value.getLength();
            fArray = new float[n];
            float f = 0.0f;
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = value.item(i).getFloatValue();
                f += fArray[i];
            }
            if (f == 0.0f) {
                fArray = null;
            }
        }
        return fArray;
    }

    public static float convertStrokeMiterlimit(Value value) {
        float f = value.getFloatValue();
        return f < 1.0f ? 1.0f : f;
    }

    public static int convertStrokeLinecap(Value value) {
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linecap argument is not an appropriate CSS value");
    }

    public static int convertStrokeLinejoin(Value value) {
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linejoin argument is not an appropriate CSS value");
    }

    public static int resolveColorComponent(Value value) {
        switch (value.getPrimitiveType()) {
            case 2: {
                float f = value.getFloatValue();
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(255.0f * f / 100.0f);
            }
            case 1: {
                float f = value.getFloatValue();
                f = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(f);
            }
        }
        throw new IllegalArgumentException("Color component argument is not an appropriate CSS value");
    }

    private static float resolveAlphaComponent(Value value) {
        switch (value.getPrimitiveType()) {
            case 2: {
                float f = value.getFloatValue();
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return f;
            }
            case 1: {
                float f = value.getFloatValue();
                f = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
                return f;
            }
        }
        throw new IllegalArgumentException("Color alpha argument is not an appropriate CSS value");
    }

    public static float convertOpacity(Value value) {
        float f = value.getFloatValue();
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }
}

