/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.AbstractAnimation;
import io.sf.carte.echosvg.anim.dom.AnimatableElement;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.AnimationTargetListener;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.timing.TimedElement;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.bridge.AbstractSVGBridge;
import io.sf.carte.echosvg.bridge.AnimationSupport;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.BridgeUpdateHandler;
import io.sf.carte.echosvg.bridge.GenericBridge;
import io.sf.carte.echosvg.bridge.SVGAnimationEngine;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.css.engine.CSSEngineEvent;
import io.sf.carte.echosvg.dom.svg.SVGAnimationContext;
import io.sf.carte.echosvg.dom.svg.SVGContext;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGElement;

public abstract class SVGAnimationElementBridge
extends AbstractSVGBridge
implements GenericBridge,
BridgeUpdateHandler,
SVGAnimationContext,
AnimatableElement {
    protected SVGOMElement element;
    protected BridgeContext ctx;
    protected SVGAnimationEngine eng;
    protected TimedElement timedElement;
    protected AbstractAnimation animation;
    protected String attributeNamespaceURI;
    protected String attributeLocalName;
    protected short animationType;
    protected SVGOMElement targetElement;
    protected AnimationTarget animationTarget;

    public TimedElement getTimedElement() {
        return this.timedElement;
    }

    public AnimatableValue getUnderlyingValue() {
        if (this.animationType == 0) {
            return this.animationTarget.getUnderlyingValue(this.attributeNamespaceURI, this.attributeLocalName);
        }
        return this.eng.getUnderlyingCSSValue((Element)this.element, this.animationTarget, this.attributeLocalName);
    }

    @Override
    public void handleElement(BridgeContext bridgeContext, Element element) {
        if (bridgeContext.isDynamic() && BridgeContext.getSVGContext(element) == null) {
            SVGAnimationElementBridge sVGAnimationElementBridge = (SVGAnimationElementBridge)this.getInstance();
            sVGAnimationElementBridge.element = (SVGOMElement)element;
            sVGAnimationElementBridge.ctx = bridgeContext;
            sVGAnimationElementBridge.eng = bridgeContext.getAnimationEngine();
            sVGAnimationElementBridge.element.setSVGContext((SVGContext)sVGAnimationElementBridge);
            if (sVGAnimationElementBridge.eng.hasStarted()) {
                if (sVGAnimationElementBridge.initializeAnimation(bridgeContext)) {
                    sVGAnimationElementBridge.initializeTimedElement();
                }
            } else {
                sVGAnimationElementBridge.eng.addInitialBridge(sVGAnimationElementBridge);
            }
        }
    }

    protected boolean initializeAnimation(BridgeContext bridgeContext) {
        Object object;
        Node node;
        String string = XLinkSupport.getXLinkHref((Element)this.element);
        if (string.length() == 0) {
            node = this.element.getParentNode();
        } else {
            node = bridgeContext.getReferencedElement((Element)this.element, string);
            if (node == null || node.getOwnerDocument() != this.element.getOwnerDocument()) {
                BridgeException bridgeException = new BridgeException(bridgeContext, (Element)this.element, "uri.badTarget", new Object[]{string});
                UserAgent userAgent = bridgeContext.getUserAgent();
                if (userAgent == null) {
                    throw bridgeException;
                }
                userAgent.displayError(bridgeException);
                return false;
            }
        }
        this.animationTarget = null;
        if (node instanceof SVGOMElement) {
            this.targetElement = (SVGOMElement)node;
            this.animationTarget = this.targetElement;
        }
        if (this.animationTarget == null) {
            BridgeException bridgeException = new BridgeException(bridgeContext, (Element)this.element, "uri.badTarget", new Object[]{string});
            UserAgent userAgent = bridgeContext.getUserAgent();
            if (userAgent == null) {
                throw bridgeException;
            }
            userAgent.displayError(bridgeException);
            return false;
        }
        String string2 = this.element.getAttributeNS(null, "attributeName");
        int n = string2.indexOf(58);
        if (n == -1) {
            if (this.element.hasProperty(string2)) {
                this.animationType = 1;
                this.attributeLocalName = string2;
            } else {
                this.animationType = 0;
                this.attributeLocalName = string2;
            }
        } else {
            this.animationType = 0;
            object = string2.substring(0, n);
            this.attributeNamespaceURI = this.element.lookupNamespaceURI((String)object);
            this.attributeLocalName = string2.substring(n + 1);
        }
        if (this.animationType == 1 && !this.targetElement.isPropertyAnimatable(this.attributeLocalName) || this.animationType == 0 && !this.targetElement.isAttributeAnimatable(this.attributeNamespaceURI, this.attributeLocalName)) {
            object = new BridgeException(bridgeContext, (Element)this.element, "attribute.not.animatable", new Object[]{this.targetElement.getNodeName(), string2});
            UserAgent userAgent = bridgeContext.getUserAgent();
            if (userAgent == null) {
                throw object;
            }
            userAgent.displayError((Exception)object);
            return false;
        }
        int n2 = this.animationType == 1 ? this.targetElement.getPropertyType(this.attributeLocalName) : this.targetElement.getAttributeType(this.attributeNamespaceURI, this.attributeLocalName);
        if (!this.canAnimateType(n2)) {
            BridgeException bridgeException = new BridgeException(bridgeContext, (Element)this.element, "type.not.animatable", new Object[]{this.targetElement.getNodeName(), string2, this.element.getNodeName()});
            UserAgent userAgent = bridgeContext.getUserAgent();
            if (userAgent == null) {
                throw bridgeException;
            }
            userAgent.displayError(bridgeException);
            return false;
        }
        this.timedElement = this.createTimedElement();
        this.animation = this.createAnimation(this.animationTarget);
        this.eng.addAnimation(this.animationTarget, this.animationType, this.attributeNamespaceURI, this.attributeLocalName, this.animation);
        return true;
    }

    protected abstract boolean canAnimateType(int var1);

    protected boolean checkValueType(AnimatableValue animatableValue) {
        return true;
    }

    protected void initializeTimedElement() {
        this.initializeTimedElement(this.timedElement);
        this.timedElement.initialize();
    }

    protected TimedElement createTimedElement() {
        return new SVGTimedElement();
    }

    protected abstract AbstractAnimation createAnimation(AnimationTarget var1);

    protected AnimatableValue parseAnimatableValue(String string) {
        String string2;
        if (!this.element.hasAttributeNS(null, string)) {
            return null;
        }
        AnimatableValue animatableValue = this.eng.parseAnimatableValue((Element)this.element, this.animationTarget, this.attributeNamespaceURI, this.attributeLocalName, this.animationType == 1, string2 = this.element.getAttributeNS(null, string));
        if (!this.checkValueType(animatableValue)) {
            throw new BridgeException(this.ctx, (Element)this.element, "attribute.malformed", new Object[]{string, string2});
        }
        return animatableValue;
    }

    protected void initializeTimedElement(TimedElement timedElement) {
        timedElement.parseAttributes(this.element.getAttributeNS(null, "begin"), this.element.getAttributeNS(null, "dur"), this.element.getAttributeNS(null, "end"), this.element.getAttributeNS(null, "min"), this.element.getAttributeNS(null, "max"), this.element.getAttributeNS(null, "repeatCount"), this.element.getAttributeNS(null, "repeatDur"), this.element.getAttributeNS(null, "fill"), this.element.getAttributeNS(null, "restart"));
    }

    @Override
    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
    }

    @Override
    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        this.element.setSVGContext(null);
        this.dispose();
    }

    @Override
    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
    }

    @Override
    public void handleOtherAnimationChanged(String string) {
    }

    @Override
    public void dispose() {
        if (this.element.getSVGContext() == null) {
            this.eng.removeAnimation(this.animation);
            this.timedElement.deinitialize();
            this.timedElement = null;
            this.element = null;
        }
    }

    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    public Rectangle2D getBBox() {
        return null;
    }

    public AffineTransform getScreenTransform() {
        return this.ctx.getUserAgent().getTransform();
    }

    public void setScreenTransform(AffineTransform affineTransform) {
        this.ctx.getUserAgent().setTransform(affineTransform);
    }

    public AffineTransform getCTM() {
        return null;
    }

    public AffineTransform getGlobalTransform() {
        return null;
    }

    public float getViewportWidth() {
        return this.ctx.getBlockWidth((Element)this.element);
    }

    public float getViewportHeight() {
        return this.ctx.getBlockHeight((Element)this.element);
    }

    public float getFontSize() {
        return 0.0f;
    }

    public float svgToUserSpace(float f, int n, int n2) {
        return 0.0f;
    }

    public void addTargetListener(String string, AnimationTargetListener animationTargetListener) {
    }

    public void removeTargetListener(String string, AnimationTargetListener animationTargetListener) {
    }

    public SVGElement getTargetElement() {
        return this.targetElement;
    }

    public float getStartTime() {
        return this.timedElement.getCurrentBeginTime();
    }

    public float getCurrentTime() {
        return this.timedElement.getLastSampleTime();
    }

    public float getSimpleDuration() {
        return this.timedElement.getSimpleDur();
    }

    public float getHyperlinkBeginTime() {
        return this.timedElement.getHyperlinkBeginTime();
    }

    public boolean beginElement() throws DOMException {
        this.timedElement.beginElement();
        return this.timedElement.canBegin();
    }

    public boolean beginElementAt(float f) throws DOMException {
        this.timedElement.beginElement(f);
        return true;
    }

    public boolean endElement() throws DOMException {
        this.timedElement.endElement();
        return this.timedElement.canEnd();
    }

    public boolean endElementAt(float f) throws DOMException {
        this.timedElement.endElement(f);
        return true;
    }

    protected boolean isConstantAnimation() {
        return false;
    }

    protected class SVGTimedElement
    extends TimedElement {
        protected SVGTimedElement() {
        }

        public Element getElement() {
            return SVGAnimationElementBridge.this.element;
        }

        protected void fireTimeEvent(String string, Calendar calendar, int n) {
            AnimationSupport.fireTimeEvent((EventTarget)SVGAnimationElementBridge.this.element, string, calendar, n);
        }

        protected void toActive(float f) {
            SVGAnimationElementBridge.this.eng.toActive(SVGAnimationElementBridge.this.animation, f);
        }

        protected void toInactive(boolean bl, boolean bl2) {
            SVGAnimationElementBridge.this.eng.toInactive(SVGAnimationElementBridge.this.animation, bl2);
        }

        protected void removeFill() {
            SVGAnimationElementBridge.this.eng.removeFill(SVGAnimationElementBridge.this.animation);
        }

        protected void sampledAt(float f, float f2, int n) {
            SVGAnimationElementBridge.this.eng.sampledAt(SVGAnimationElementBridge.this.animation, f, f2, n);
        }

        protected void sampledLastValue(int n) {
            SVGAnimationElementBridge.this.eng.sampledLastValue(SVGAnimationElementBridge.this.animation, n);
        }

        protected TimedElement getTimedElementById(String string) {
            return AnimationSupport.getTimedElementById(string, (Node)SVGAnimationElementBridge.this.element);
        }

        protected EventTarget getEventTargetById(String string) {
            return AnimationSupport.getEventTargetById(string, (Node)SVGAnimationElementBridge.this.element);
        }

        protected EventTarget getRootEventTarget() {
            return (EventTarget)((Object)SVGAnimationElementBridge.this.element.getOwnerDocument());
        }

        protected EventTarget getAnimationEventTarget() {
            return SVGAnimationElementBridge.this.targetElement;
        }

        public boolean isBefore(TimedElement timedElement) {
            Element element = timedElement.getElement();
            short s = SVGAnimationElementBridge.this.element.compareDocumentPosition((Node)element);
            return (s & 2) != 0;
        }

        public String toString() {
            String string;
            if (SVGAnimationElementBridge.this.element != null && (string = SVGAnimationElementBridge.this.element.getAttributeNS(null, "id")).length() != 0) {
                return string;
            }
            return super.toString();
        }

        protected boolean isConstantAnimation() {
            return SVGAnimationElementBridge.this.isConstantAnimation();
        }
    }
}

