/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.AnimationEngine;
import io.sf.carte.echosvg.anim.AnimationException;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.dom.SVGStylableElement;
import io.sf.carte.echosvg.anim.timing.TimedDocumentRoot;
import io.sf.carte.echosvg.anim.timing.TimedElement;
import io.sf.carte.echosvg.anim.values.AnimatableAngleOrIdentValue;
import io.sf.carte.echosvg.anim.values.AnimatableAngleValue;
import io.sf.carte.echosvg.anim.values.AnimatableBooleanValue;
import io.sf.carte.echosvg.anim.values.AnimatableColorValue;
import io.sf.carte.echosvg.anim.values.AnimatableIntegerValue;
import io.sf.carte.echosvg.anim.values.AnimatableLengthListValue;
import io.sf.carte.echosvg.anim.values.AnimatableLengthOrIdentValue;
import io.sf.carte.echosvg.anim.values.AnimatableLengthValue;
import io.sf.carte.echosvg.anim.values.AnimatableNumberListValue;
import io.sf.carte.echosvg.anim.values.AnimatableNumberOrIdentValue;
import io.sf.carte.echosvg.anim.values.AnimatableNumberOrPercentageValue;
import io.sf.carte.echosvg.anim.values.AnimatableNumberValue;
import io.sf.carte.echosvg.anim.values.AnimatablePaintValue;
import io.sf.carte.echosvg.anim.values.AnimatablePathDataValue;
import io.sf.carte.echosvg.anim.values.AnimatablePointListValue;
import io.sf.carte.echosvg.anim.values.AnimatablePreserveAspectRatioValue;
import io.sf.carte.echosvg.anim.values.AnimatableRectValue;
import io.sf.carte.echosvg.anim.values.AnimatableStringValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.bridge.AnimationSupport;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.bridge.SVGAnimationElementBridge;
import io.sf.carte.echosvg.bridge.UpdateManager;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.parser.DefaultLengthHandler;
import io.sf.carte.echosvg.parser.DefaultPreserveAspectRatioHandler;
import io.sf.carte.echosvg.parser.FloatArrayProducer;
import io.sf.carte.echosvg.parser.LengthArrayProducer;
import io.sf.carte.echosvg.parser.LengthHandler;
import io.sf.carte.echosvg.parser.LengthListHandler;
import io.sf.carte.echosvg.parser.LengthListParser;
import io.sf.carte.echosvg.parser.LengthParser;
import io.sf.carte.echosvg.parser.NumberListHandler;
import io.sf.carte.echosvg.parser.NumberListParser;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PathArrayProducer;
import io.sf.carte.echosvg.parser.PathHandler;
import io.sf.carte.echosvg.parser.PathParser;
import io.sf.carte.echosvg.parser.PointsHandler;
import io.sf.carte.echosvg.parser.PointsParser;
import io.sf.carte.echosvg.parser.PreserveAspectRatioHandler;
import io.sf.carte.echosvg.parser.PreserveAspectRatioParser;
import io.sf.carte.echosvg.util.RunnableQueue;
import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.EventTarget;

public class SVGAnimationEngine
extends AnimationEngine {
    protected BridgeContext ctx;
    protected CSSEngine cssEngine;
    protected boolean started;
    protected AnimationTickRunnable animationTickRunnable;
    protected float initialStartTime;
    protected UncomputedAnimatableStringValueFactory uncomputedAnimatableStringValueFactory = new UncomputedAnimatableStringValueFactory();
    protected AnimatableLengthOrIdentFactory animatableLengthOrIdentFactory = new AnimatableLengthOrIdentFactory();
    protected AnimatableNumberOrIdentFactory animatableNumberOrIdentFactory = new AnimatableNumberOrIdentFactory(false);
    protected Factory[] factories = new Factory[]{null, new AnimatableIntegerValueFactory(), new AnimatableNumberValueFactory(), new AnimatableLengthValueFactory(), null, new AnimatableAngleValueFactory(), new AnimatableColorValueFactory(), new AnimatablePaintValueFactory(), null, null, this.uncomputedAnimatableStringValueFactory, null, null, new AnimatableNumberListValueFactory(), new AnimatableLengthListValueFactory(), this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.animatableLengthOrIdentFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, new AnimatablePathDataFactory(), this.uncomputedAnimatableStringValueFactory, null, this.animatableNumberOrIdentFactory, this.uncomputedAnimatableStringValueFactory, null, new AnimatableNumberOrIdentFactory(true), new AnimatableAngleOrIdentFactory(), null, new AnimatablePointListValueFactory(), new AnimatablePreserveAspectRatioValueFactory(), null, this.uncomputedAnimatableStringValueFactory, null, null, null, null, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableNumberOrIdentFactory, null, null, new AnimatableNumberOrPercentageValueFactory(), null, new AnimatableBooleanValueFactory(), new AnimatableRectValueFactory()};
    protected boolean isSVG12;
    protected LinkedList<SVGAnimationElementBridge> initialBridges = new LinkedList();
    protected StyleMap dummyStyleMap;
    protected AnimationThread animationThread;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected static final Set<String> animationEventNames11 = new HashSet<String>();
    protected static final Set<String> animationEventNames12 = new HashSet<String>();

    public SVGAnimationEngine(Document document, BridgeContext bridgeContext) {
        super(document);
        this.ctx = bridgeContext;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        this.cssEngine = sVGOMDocument.getCSSEngine();
        this.dummyStyleMap = new StyleMap(this.cssEngine.getNumberOfProperties());
        this.isSVG12 = sVGOMDocument.isSVG12();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SVGAnimationEngine sVGAnimationEngine = this;
        synchronized (sVGAnimationEngine) {
            this.pause();
            super.dispose();
        }
    }

    public void addInitialBridge(SVGAnimationElementBridge sVGAnimationElementBridge) {
        if (this.initialBridges != null) {
            this.initialBridges.add(sVGAnimationElementBridge);
        }
    }

    public boolean hasStarted() {
        return this.started;
    }

    public AnimatableValue parseAnimatableValue(Element element, AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
        SVGOMElement sVGOMElement = (SVGOMElement)animationTarget.getElement();
        int n = bl ? sVGOMElement.getPropertyType(string2) : sVGOMElement.getAttributeType(string, string2);
        Factory factory = this.factories[n];
        if (factory == null) {
            String string4 = string == null ? string2 : '{' + string + '}' + string2;
            throw new BridgeException(this.ctx, element, "attribute.not.animatable", new Object[]{animationTarget.getElement().getNodeName(), string4});
        }
        return this.factories[n].createValue(animationTarget, string, string2, bl, string3);
    }

    public AnimatableValue getUnderlyingCSSValue(Element element, AnimationTarget animationTarget, String string) {
        ValueManager[] valueManagerArray = this.cssEngine.getValueManagers();
        int n = this.cssEngine.getPropertyIndex(string);
        if (n != -1) {
            int n2 = valueManagerArray[n].getPropertyType();
            Factory factory = this.factories[n2];
            if (factory == null) {
                throw new BridgeException(this.ctx, element, "attribute.not.animatable", new Object[]{animationTarget.getElement().getNodeName(), string});
            }
            SVGStylableElement sVGStylableElement = (SVGStylableElement)animationTarget.getElement();
            CSSStyleDeclaration cSSStyleDeclaration = sVGStylableElement.getOverrideStyle();
            String string2 = cSSStyleDeclaration.getPropertyValue(string);
            if (string2 != null) {
                cSSStyleDeclaration.removeProperty(string);
            }
            Value value = this.cssEngine.getComputedStyle((CSSStylableElement)sVGStylableElement, null, n);
            if (string2 != null && !string2.equals("")) {
                cSSStyleDeclaration.setProperty(string, string2, null);
            }
            return this.factories[n2].createValue(animationTarget, string, value);
        }
        return null;
    }

    public void pause() {
        super.pause();
        UpdateManager updateManager = this.ctx.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().setIdleRunnable(null);
        }
    }

    public void unpause() {
        super.unpause();
        UpdateManager updateManager = this.ctx.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().setIdleRunnable((RunnableQueue.IdleRunnable)this.animationTickRunnable);
        }
    }

    public float getCurrentTime() {
        boolean bl = this.pauseTime != 0L;
        this.unpause();
        float f = this.timedDocumentRoot.getCurrentTime();
        if (bl) {
            this.pause();
        }
        return Float.isNaN(f) ? 0.0f : f;
    }

    public float setCurrentTime(float f) {
        if (this.started) {
            float f2 = super.setCurrentTime(f);
            if (this.animationTickRunnable != null) {
                this.animationTickRunnable.resume();
            }
            return f2;
        }
        this.initialStartTime = f;
        return 0.0f;
    }

    protected TimedDocumentRoot createDocumentRoot() {
        return new AnimationRoot();
    }

    public void start(long l) {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            try {
                int n;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(l));
                this.timedDocumentRoot.resetDocument(calendar);
                SVGAnimationElementBridge[] sVGAnimationElementBridgeArray = this.initialBridges.toArray(new SVGAnimationElementBridge[0]);
                boolean[] blArray = new boolean[sVGAnimationElementBridgeArray.length];
                this.initialBridges = null;
                for (n = 0; n < sVGAnimationElementBridgeArray.length; ++n) {
                    blArray[n] = sVGAnimationElementBridgeArray[n].initializeAnimation(this.ctx);
                }
                for (n = 0; n < sVGAnimationElementBridgeArray.length; ++n) {
                    if (!blArray[n]) continue;
                    sVGAnimationElementBridgeArray[n].initializeTimedElement();
                }
                UpdateManager updateManager = this.ctx.getUpdateManager();
                if (updateManager != null) {
                    RunnableQueue runnableQueue = updateManager.getUpdateRunnableQueue();
                    this.animationTickRunnable = new AnimationTickRunnable(runnableQueue, this);
                    runnableQueue.setIdleRunnable((RunnableQueue.IdleRunnable)this.animationTickRunnable);
                    if (this.initialStartTime != 0.0f) {
                        this.setCurrentTime(this.initialStartTime);
                    }
                }
            }
            catch (AnimationException animationException) {
                throw new BridgeException(this.ctx, animationException.getElement().getElement(), animationException.getMessage());
            }
        }
        catch (Exception exception) {
            if (this.ctx.getUserAgent() == null) {
                exception.printStackTrace();
            }
            this.ctx.getUserAgent().displayError(exception);
        }
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
    }

    public void setAnimationLimitingCPU(float f) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = f;
    }

    public void setAnimationLimitingFPS(float f) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = f;
    }

    static {
        String[] stringArray = new String[]{"click", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout", "beginEvent", "endEvent"};
        String[] stringArray2 = new String[]{"DOMSubtreeModified", "DOMNodeInserted", "DOMNodeRemoved", "DOMNodeRemovedFromDocument", "DOMNodeInsertedIntoDocument", "DOMAttrModified", "DOMCharacterDataModified", "SVGLoad", "SVGUnload", "SVGAbort", "SVGError", "SVGResize", "SVGScroll", "repeatEvent"};
        String[] stringArray3 = new String[]{"load", "resize", "scroll", "zoom"};
        for (String string : stringArray) {
            animationEventNames11.add(string);
            animationEventNames12.add(string);
        }
        for (String string : stringArray2) {
            animationEventNames11.add(string);
        }
        for (String string : stringArray3) {
            animationEventNames12.add(string);
        }
    }

    protected class AnimatableAngleOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableAngleOrIdentFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            short s;
            if (value instanceof StringValue) {
                return new AnimatableAngleOrIdentValue(animationTarget, value.getStringValue());
            }
            FloatValue floatValue = (FloatValue)value;
            switch (floatValue.getPrimitiveType()) {
                case 1: 
                case 11: {
                    s = 2;
                    break;
                }
                case 12: {
                    s = 3;
                    break;
                }
                case 13: {
                    s = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleOrIdentValue(animationTarget, floatValue.getFloatValue(), s);
        }
    }

    protected class AnimatableAngleValueFactory
    extends CSSValueFactory {
        protected AnimatableAngleValueFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            short s;
            FloatValue floatValue = (FloatValue)value;
            switch (floatValue.getPrimitiveType()) {
                case 1: 
                case 11: {
                    s = 2;
                    break;
                }
                case 12: {
                    s = 3;
                    break;
                }
                case 13: {
                    s = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleValue(animationTarget, floatValue.getFloatValue(), s);
        }
    }

    protected static class AnimatableBooleanValueFactory
    implements Factory {
        protected AnimatableBooleanValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableBooleanValue(animationTarget, "true".equals(string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableBooleanValue(animationTarget, "true".equals(value.getCssText()));
        }
    }

    protected class AnimatableColorValueFactory
    extends CSSValueFactory {
        protected AnimatableColorValueFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
            if (paint instanceof Color) {
                Color color = (Color)paint;
                return new AnimatableColorValue(animationTarget, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
            return null;
        }
    }

    protected static class AnimatableIntegerValueFactory
    implements Factory {
        protected AnimatableIntegerValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableIntegerValue(animationTarget, Integer.parseInt(string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableIntegerValue(animationTarget, Math.round(value.getFloatValue()));
        }
    }

    protected static class AnimatableLengthListValueFactory
    implements Factory {
        protected LengthListParser parser = new LengthListParser();
        protected LengthArrayProducer producer = new LengthArrayProducer();

        public AnimatableLengthListValueFactory() {
            this.parser.setLengthListHandler((LengthListHandler)this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                short s = animationTarget.getPercentageInterpretation(string, string2, bl);
                this.parser.parse(string3);
                return new AnimatableLengthListValue(animationTarget, this.producer.getLengthTypeArray(), this.producer.getLengthValueArray(), s);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableLengthOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableLengthOrIdentFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value instanceof StringValue) {
                return new AnimatableLengthOrIdentValue(animationTarget, value.getStringValue());
            }
            short s = animationTarget.getPercentageInterpretation(null, string, true);
            FloatValue floatValue = (FloatValue)value;
            return new AnimatableLengthOrIdentValue(animationTarget, floatValue.getPrimitiveType(), floatValue.getFloatValue(), s);
        }
    }

    protected static class AnimatableLengthValueFactory
    implements Factory {
        protected short type;
        protected float value;
        protected LengthParser parser = new LengthParser();
        protected LengthHandler handler = new DefaultLengthHandler(){

            public void startLength() throws ParseException {
                type = 1;
            }

            public void lengthValue(float f) throws ParseException {
                value = f;
            }

            public void em() throws ParseException {
                type = (short)3;
            }

            public void ex() throws ParseException {
                type = (short)4;
            }

            public void in() throws ParseException {
                type = (short)8;
            }

            public void cm() throws ParseException {
                type = (short)6;
            }

            public void mm() throws ParseException {
                type = (short)7;
            }

            public void pc() throws ParseException {
                type = (short)10;
            }

            public void pt() throws ParseException {
                type = (short)9;
            }

            public void px() throws ParseException {
                type = (short)5;
            }

            public void percentage() throws ParseException {
                type = (short)2;
            }

            public void endLength() throws ParseException {
            }
        };

        public AnimatableLengthValueFactory() {
            this.parser.setLengthHandler(this.handler);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            short s = animationTarget.getPercentageInterpretation(string, string2, bl);
            try {
                this.parser.parse(string3);
                return new AnimatableLengthValue(animationTarget, this.type, this.value, s);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableIntegerValue(animationTarget, Math.round(value.getFloatValue()));
        }
    }

    protected static class AnimatableNumberListValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableNumberListValueFactory() {
            this.parser.setNumberListHandler((NumberListHandler)this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatableNumberListValue(animationTarget, this.producer.getFloatArray());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableNumberOrIdentFactory
    extends CSSValueFactory {
        protected boolean numericIdents;

        public AnimatableNumberOrIdentFactory(boolean bl) {
            this.numericIdents = bl;
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value instanceof StringValue) {
                return new AnimatableNumberOrIdentValue(animationTarget, value.getStringValue());
            }
            FloatValue floatValue = (FloatValue)value;
            return new AnimatableNumberOrIdentValue(animationTarget, floatValue.getFloatValue(), this.numericIdents);
        }
    }

    protected static class AnimatableNumberOrPercentageValueFactory
    implements Factory {
        protected AnimatableNumberOrPercentageValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            boolean bl2;
            float f;
            if (string3.charAt(string3.length() - 1) == '%') {
                f = Float.parseFloat(string3.substring(0, string3.length() - 1));
                bl2 = true;
            } else {
                f = Float.parseFloat(string3);
                bl2 = false;
            }
            return new AnimatableNumberOrPercentageValue(animationTarget, f, bl2);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            switch (value.getPrimitiveType()) {
                case 2: {
                    return new AnimatableNumberOrPercentageValue(animationTarget, value.getFloatValue(), true);
                }
                case 1: {
                    return new AnimatableNumberOrPercentageValue(animationTarget, value.getFloatValue());
                }
            }
            return null;
        }
    }

    protected static class AnimatableNumberValueFactory
    implements Factory {
        protected AnimatableNumberValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableNumberValue(animationTarget, Float.parseFloat(string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableNumberValue(animationTarget, value.getFloatValue());
        }
    }

    protected class AnimatablePaintValueFactory
    extends CSSValueFactory {
        protected AnimatablePaintValueFactory() {
        }

        protected AnimatablePaintValue createColorPaintValue(AnimationTarget animationTarget, Color color) {
            return AnimatablePaintValue.createColorPaintValue((AnimationTarget)animationTarget, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            if (value.getCssValueType() == 1) {
                switch (value.getPrimitiveType()) {
                    case 21: {
                        return AnimatablePaintValue.createNonePaintValue((AnimationTarget)animationTarget);
                    }
                    case 25: {
                        Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(animationTarget, (Color)paint);
                    }
                    case 20: {
                        return AnimatablePaintValue.createURIPaintValue((AnimationTarget)animationTarget, (String)value.getStringValue());
                    }
                }
            } else {
                Value value2 = value.item(0);
                switch (value2.getPrimitiveType()) {
                    case 25: {
                        Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(animationTarget, (Color)paint);
                    }
                    case 20: {
                        Value value3 = value.item(1);
                        switch (value3.getPrimitiveType()) {
                            case 21: {
                                return AnimatablePaintValue.createURINonePaintValue((AnimationTarget)animationTarget, (String)value2.getStringValue());
                            }
                            case 25: {
                                Paint paint = PaintServer.convertPaint(animationTarget.getElement(), null, value.item(1), 1.0f, SVGAnimationEngine.this.ctx);
                                return this.createColorPaintValue(animationTarget, (Color)paint);
                            }
                        }
                    }
                }
            }
            return null;
        }
    }

    protected static class AnimatablePathDataFactory
    implements Factory {
        protected PathParser parser = new PathParser();
        protected PathArrayProducer producer = new PathArrayProducer();

        public AnimatablePathDataFactory() {
            this.parser.setPathHandler((PathHandler)this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePathDataValue(animationTarget, this.producer.getPathCommands(), this.producer.getPathParameters());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected static class AnimatablePointListValueFactory
    implements Factory {
        protected PointsParser parser = new PointsParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatablePointListValueFactory() {
            this.parser.setPointsHandler((PointsHandler)this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePointListValue(animationTarget, this.producer.getFloatArray());
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected static class AnimatablePreserveAspectRatioValueFactory
    implements Factory {
        protected short align;
        protected short meetOrSlice;
        protected PreserveAspectRatioParser parser = new PreserveAspectRatioParser();
        protected DefaultPreserveAspectRatioHandler handler = new DefaultPreserveAspectRatioHandler(){

            public void startPreserveAspectRatio() throws ParseException {
                align = 0;
                meetOrSlice = 0;
            }

            public void none() throws ParseException {
                align = 1;
            }

            public void xMaxYMax() throws ParseException {
                align = (short)10;
            }

            public void xMaxYMid() throws ParseException {
                align = (short)7;
            }

            public void xMaxYMin() throws ParseException {
                align = (short)4;
            }

            public void xMidYMax() throws ParseException {
                align = (short)9;
            }

            public void xMidYMid() throws ParseException {
                align = (short)6;
            }

            public void xMidYMin() throws ParseException {
                align = (short)3;
            }

            public void xMinYMax() throws ParseException {
                align = (short)8;
            }

            public void xMinYMid() throws ParseException {
                align = (short)5;
            }

            public void xMinYMin() throws ParseException {
                align = (short)2;
            }

            public void meet() throws ParseException {
                meetOrSlice = 1;
            }

            public void slice() throws ParseException {
                meetOrSlice = (short)2;
            }
        };

        public AnimatablePreserveAspectRatioValueFactory() {
            this.parser.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)this.handler);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                return new AnimatablePreserveAspectRatioValue(animationTarget, this.align, this.meetOrSlice);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected static class AnimatableRectValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableRectValueFactory() {
            this.parser.setNumberListHandler((NumberListHandler)this.producer);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            try {
                this.parser.parse(string3);
                float[] fArray = this.producer.getFloatArray();
                if (fArray.length != 4) {
                    return null;
                }
                return new AnimatableRectValue(animationTarget, fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return null;
        }
    }

    protected class AnimatableStringValueFactory
    extends CSSValueFactory {
        protected AnimatableStringValueFactory() {
        }

        @Override
        protected AnimatableValue createAnimatableValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableStringValue(animationTarget, value.getCssText());
        }
    }

    protected class AnimationRoot
    extends TimedDocumentRoot {
        public AnimationRoot() {
            super(!SVGAnimationEngine.this.isSVG12, SVGAnimationEngine.this.isSVG12);
        }

        protected String getEventNamespaceURI(String string) {
            if (!SVGAnimationEngine.this.isSVG12) {
                return null;
            }
            if (string.equals("focusin") || string.equals("focusout") || string.equals("activate") || animationEventNames12.contains(string)) {
                return "http://www.w3.org/2001/xml-events";
            }
            return null;
        }

        protected String getEventType(String string) {
            if (string.equals("focusin")) {
                return "DOMFocusIn";
            }
            if (string.equals("focusout")) {
                return "DOMFocusOut";
            }
            if (string.equals("activate")) {
                return "DOMActivate";
            }
            if (SVGAnimationEngine.this.isSVG12 ? animationEventNames12.contains(string) : animationEventNames11.contains(string)) {
                return string;
            }
            return null;
        }

        protected String getRepeatEventName() {
            return "repeatEvent";
        }

        protected void fireTimeEvent(String string, Calendar calendar, int n) {
            AnimationSupport.fireTimeEvent((EventTarget)((Object)SVGAnimationEngine.this.document), string, calendar, n);
        }

        protected void toActive(float f) {
        }

        protected void toInactive(boolean bl, boolean bl2) {
        }

        protected void removeFill() {
        }

        protected void sampledAt(float f, float f2, int n) {
        }

        protected void sampledLastValue(int n) {
        }

        protected TimedElement getTimedElementById(String string) {
            return AnimationSupport.getTimedElementById(string, SVGAnimationEngine.this.document);
        }

        protected EventTarget getEventTargetById(String string) {
            return AnimationSupport.getEventTargetById(string, SVGAnimationEngine.this.document);
        }

        protected EventTarget getAnimationEventTarget() {
            return null;
        }

        protected EventTarget getRootEventTarget() {
            return (EventTarget)((Object)SVGAnimationEngine.this.document);
        }

        public Element getElement() {
            return null;
        }

        public boolean isBefore(TimedElement timedElement) {
            return false;
        }

        protected void currentIntervalWillUpdate() {
            if (SVGAnimationEngine.this.animationTickRunnable != null) {
                SVGAnimationEngine.this.animationTickRunnable.resume();
            }
        }
    }

    protected class AnimationThread
    extends Thread {
        protected Calendar time = Calendar.getInstance();
        protected RunnableQueue runnableQueue;
        protected Ticker ticker;

        protected AnimationThread() {
            this.runnableQueue = SVGAnimationEngine.this.ctx.getUpdateManager().getUpdateRunnableQueue();
            this.ticker = new Ticker();
        }

        @Override
        public void run() {
            while (true) {
                this.time.setTime(new Date());
                this.ticker.t = SVGAnimationEngine.this.timedDocumentRoot.convertWallclockTime(this.time);
                try {
                    this.runnableQueue.invokeAndWait((Runnable)this.ticker);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }

        protected class Ticker
        implements Runnable {
            protected float t;

            protected Ticker() {
            }

            @Override
            public void run() {
                SVGAnimationEngine.this.tick(this.t, false);
            }
        }
    }

    protected static class AnimationTickRunnable
    implements RunnableQueue.IdleRunnable {
        protected Calendar time = Calendar.getInstance();
        protected long waitTime;
        protected RunnableQueue q;
        private static final int NUM_TIMES = 8;
        protected long[] times = new long[8];
        protected long sumTime;
        protected int timeIndex;
        protected WeakReference<SVGAnimationEngine> engRef;
        protected static final int MAX_EXCEPTION_COUNT = 10;
        protected int exceptionCount;

        public AnimationTickRunnable(RunnableQueue runnableQueue, SVGAnimationEngine sVGAnimationEngine) {
            this.q = runnableQueue;
            this.engRef = new WeakReference<SVGAnimationEngine>(sVGAnimationEngine);
            Arrays.fill(this.times, 100L);
            this.sumTime = 800L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Object object;
            this.waitTime = 0L;
            Object object2 = object = this.q.getIteratorLock();
            synchronized (object2) {
                object.notify();
            }
        }

        public long getWaitTime() {
            return this.waitTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SVGAnimationEngine sVGAnimationEngine = this.getAnimationEngine();
            if (sVGAnimationEngine == null) {
                throw new NullPointerException("Animation engine was collected.");
            }
            SVGAnimationEngine sVGAnimationEngine2 = sVGAnimationEngine;
            synchronized (sVGAnimationEngine2) {
                int n;
                block18: {
                    n = sVGAnimationEngine.animationLimitingMode;
                    float f = sVGAnimationEngine.animationLimitingAmount;
                    try {
                        try {
                            long l = System.currentTimeMillis();
                            this.time.setTime(new Date(l));
                            float f2 = sVGAnimationEngine.timedDocumentRoot.convertWallclockTime(this.time);
                            float f3 = sVGAnimationEngine.tick(f2, false);
                            long l2 = System.currentTimeMillis();
                            long l3 = l2 - l;
                            if (l3 == 0L) {
                                l3 = 1L;
                            }
                            this.sumTime -= this.times[this.timeIndex];
                            this.sumTime += l3;
                            this.times[this.timeIndex] = l3;
                            this.timeIndex = (this.timeIndex + 1) % 8;
                            if (f3 == Float.POSITIVE_INFINITY) {
                                this.waitTime = Long.MAX_VALUE;
                            } else {
                                this.waitTime = l + (long)(f3 * 1000.0f) - 1000L;
                                if (this.waitTime < l2) {
                                    this.waitTime = l2;
                                }
                                if (n != 0) {
                                    float f4 = (float)this.sumTime / 8.0f;
                                    float f5 = n == 1 ? f4 / f - f4 : 1000.0f / f - f4;
                                    long l4 = l2 + (long)f5;
                                    if (l4 > this.waitTime) {
                                        this.waitTime = l4;
                                    }
                                }
                            }
                        }
                        catch (AnimationException animationException) {
                            throw new BridgeException(sVGAnimationEngine.ctx, animationException.getElement().getElement(), animationException.getMessage());
                        }
                        this.exceptionCount = 0;
                    }
                    catch (Exception exception) {
                        if (++this.exceptionCount >= 10) break block18;
                        if (sVGAnimationEngine.ctx.getUserAgent() == null) {
                            exception.printStackTrace();
                        }
                        sVGAnimationEngine.ctx.getUserAgent().displayError(exception);
                    }
                }
                if (n == 0) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        protected SVGAnimationEngine getAnimationEngine() {
            return (SVGAnimationEngine)((Object)this.engRef.get());
        }
    }

    protected abstract class CSSValueFactory
    implements Factory {
        protected CSSValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return this.createValue(animationTarget, string2, this.createCSSValue(animationTarget, string2, string3));
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)animationTarget.getElement();
            value = this.computeValue(cSSStylableElement, string, value);
            return this.createAnimatableValue(animationTarget, string, value);
        }

        protected abstract AnimatableValue createAnimatableValue(AnimationTarget var1, String var2, Value var3);

        protected Value createCSSValue(AnimationTarget animationTarget, String string, String string2) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)animationTarget.getElement();
            Value value = SVGAnimationEngine.this.cssEngine.parsePropertyValue(cSSStylableElement, string, string2);
            return this.computeValue(cSSStylableElement, string, value);
        }

        protected Value computeValue(CSSStylableElement cSSStylableElement, String string, Value value) {
            ValueManager[] valueManagerArray = SVGAnimationEngine.this.cssEngine.getValueManagers();
            int n = SVGAnimationEngine.this.cssEngine.getPropertyIndex(string);
            if (n != -1) {
                if (value.getCssValueType() == 0) {
                    if ((cSSStylableElement = CSSEngine.getParentCSSStylableElement((Element)cSSStylableElement)) != null) {
                        return SVGAnimationEngine.this.cssEngine.getComputedStyle(cSSStylableElement, null, n);
                    }
                    return valueManagerArray[n].getDefaultValue();
                }
                value = valueManagerArray[n].computeValue(cSSStylableElement, null, SVGAnimationEngine.this.cssEngine, n, SVGAnimationEngine.this.dummyStyleMap, value);
            }
            return value;
        }
    }

    protected static class DebugAnimationTickRunnable
    extends AnimationTickRunnable {
        float t = 0.0f;

        public DebugAnimationTickRunnable(RunnableQueue runnableQueue, SVGAnimationEngine sVGAnimationEngine) {
            super(runnableQueue, sVGAnimationEngine);
            this.waitTime = Long.MAX_VALUE;
            new Thread(){

                @Override
                public void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Enter times.");
                    while (true) {
                        String string;
                        try {
                            string = bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            string = null;
                        }
                        if (string == null) {
                            System.exit(0);
                        }
                        t = Float.parseFloat(string);
                        this.resume();
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume() {
            Object object;
            this.waitTime = 0L;
            Object object2 = object = this.q.getIteratorLock();
            synchronized (object2) {
                object.notify();
            }
        }

        @Override
        public long getWaitTime() {
            long l = this.waitTime;
            this.waitTime = Long.MAX_VALUE;
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SVGAnimationEngine sVGAnimationEngine = this.getAnimationEngine();
            if (sVGAnimationEngine == null) {
                throw new NullPointerException("Animation engine was collected.");
            }
            SVGAnimationEngine sVGAnimationEngine2 = sVGAnimationEngine;
            synchronized (sVGAnimationEngine2) {
                try {
                    try {
                        sVGAnimationEngine.tick(this.t, false);
                    }
                    catch (AnimationException animationException) {
                        throw new BridgeException(sVGAnimationEngine.ctx, animationException.getElement().getElement(), animationException.getMessage());
                    }
                }
                catch (Exception exception) {
                    if (sVGAnimationEngine.ctx.getUserAgent() == null) {
                        exception.printStackTrace();
                    }
                    sVGAnimationEngine.ctx.getUserAgent().displayError(exception);
                }
            }
        }
    }

    protected static interface Factory {
        public AnimatableValue createValue(AnimationTarget var1, String var2, String var3, boolean var4, String var5);

        public AnimatableValue createValue(AnimationTarget var1, String var2, Value var3);
    }

    protected static class UncomputedAnimatableStringValueFactory
    implements Factory {
        protected UncomputedAnimatableStringValueFactory() {
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, String string2, boolean bl, String string3) {
            return new AnimatableStringValue(animationTarget, string3);
        }

        @Override
        public AnimatableValue createValue(AnimationTarget animationTarget, String string, Value value) {
            return new AnimatableStringValue(animationTarget, value.getCssText());
        }
    }
}

