/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedLength;
import io.sf.carte.echosvg.bridge.AbstractGraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.css.engine.CSSEngineEvent;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.RenderingHints;
import org.w3c.dom.Element;

public abstract class SVGShapeElementBridge
extends AbstractGraphicsNodeBridge {
    protected boolean hasNewShapePainter;

    protected SVGShapeElementBridge() {
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        ShapeNode shapeNode = (ShapeNode)super.createGraphicsNode(bridgeContext, element);
        if (shapeNode == null) {
            return null;
        }
        this.associateSVGContext(bridgeContext, element, (GraphicsNode)shapeNode);
        this.buildShape(bridgeContext, element, shapeNode);
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        renderingHints = CSSUtilities.convertShapeRendering(element, renderingHints);
        if (renderingHints != null) {
            shapeNode.setRenderingHints(renderingHints);
        }
        return shapeNode;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new ShapeNode();
    }

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        ShapeNode shapeNode = (ShapeNode)graphicsNode;
        shapeNode.setShapePainter(this.createShapePainter(bridgeContext, element, shapeNode));
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
    }

    protected ShapePainter createShapePainter(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        return PaintServer.convertFillAndStroke(element, shapeNode, bridgeContext);
    }

    protected abstract void buildShape(BridgeContext var1, Element var2, ShapeNode var3);

    float safeAnimatedCheckedValue(AbstractSVGAnimatedLength abstractSVGAnimatedLength, float f) {
        float f2;
        try {
            f2 = abstractSVGAnimatedLength.getCheckedValue();
        }
        catch (LiveAttributeException liveAttributeException) {
            f2 = f;
            BridgeException bridgeException = new BridgeException(this.ctx, liveAttributeException);
            if (this.ctx.userAgent == null) {
                throw bridgeException;
            }
            this.ctx.userAgent.displayError(bridgeException);
        }
        return f2;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    protected void handleGeometryChanged() {
        super.handleGeometryChanged();
        ShapeNode shapeNode = (ShapeNode)this.node;
        shapeNode.setShapePainter(this.createShapePainter(this.ctx, this.e, shapeNode));
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        this.hasNewShapePainter = false;
        super.handleCSSEngineEvent(cSSEngineEvent);
    }

    @Override
    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 15: 
            case 16: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                if (this.hasNewShapePainter) break;
                this.hasNewShapePainter = true;
                ShapeNode shapeNode = (ShapeNode)this.node;
                shapeNode.setShapePainter(this.createShapePainter(this.ctx, this.e, shapeNode));
                break;
            }
            case 42: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertShapeRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            case 9: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }
}

