/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.gvt.text.TextPath;
import io.sf.carte.echosvg.parser.AWTPathProducer;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PathHandler;
import io.sf.carte.echosvg.parser.PathParser;
import io.sf.carte.echosvg.parser.UnitProcessor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Element;

public class SVGTextPathElementBridge
extends AnimatableGenericSVGBridge
implements ErrorConstants {
    @Override
    public String getLocalName() {
        return "textPath";
    }

    @Override
    public void handleElement(BridgeContext bridgeContext, Element element) {
    }

    public TextPath createTextPath(BridgeContext bridgeContext, Element element) {
        Object object;
        String string = XLinkSupport.getXLinkHref((Element)element);
        Element element2 = bridgeContext.getReferencedElement(element, string);
        if (element2 == null || !"http://www.w3.org/2000/svg".equals(element2.getNamespaceURI()) || !element2.getLocalName().equals("path")) {
            throw new BridgeException(bridgeContext, element, "uri.badTarget", new Object[]{string});
        }
        String string2 = element2.getAttributeNS(null, "d");
        Shape shape = null;
        if (string2.length() != 0) {
            object = new AWTPathProducer();
            object.setWindingRule(CSSUtilities.convertFillRule(element2));
            try {
                PathParser pathParser = new PathParser();
                pathParser.setPathHandler((PathHandler)object);
                pathParser.parse(string2);
            }
            catch (ParseException parseException) {
                throw new BridgeException(bridgeContext, element2, (Exception)((Object)parseException), "attribute.malformed", new Object[]{"d"});
            }
            finally {
                shape = object.getShape();
            }
        } else {
            throw new BridgeException(bridgeContext, element2, "attribute.missing", new Object[]{"d"});
        }
        string2 = element2.getAttributeNS(null, "transform");
        if (string2.length() != 0) {
            object = SVGUtilities.convertTransform(element2, "transform", string2, bridgeContext);
            shape = ((AffineTransform)object).createTransformedShape(shape);
        }
        object = new TextPath(new GeneralPath(shape));
        string2 = element.getAttributeNS(null, "startOffset");
        if (string2.length() > 0) {
            float f = 0.0f;
            int n = string2.indexOf(37);
            if (n != -1) {
                float f2 = object.lengthOfPath();
                String string3 = string2.substring(0, n);
                float f3 = 0.0f;
                try {
                    f3 = SVGUtilities.convertSVGNumber(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"startOffset", string2});
                }
                f = f3 * f2 / 100.0f;
            } else {
                UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
                f = UnitProcessor.svgOtherLengthToUserSpace(string2, "startOffset", context);
            }
            object.setStartOffset(f);
        }
        return object;
    }
}

