/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;

public class HashSlotMap
implements SlotMap {
    private final LinkedHashMap<Object, Slot> map = new LinkedHashMap();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Slot query(Object object, int n) {
        Object object2 = this.makeKey(object, n);
        return this.map.get(object2);
    }

    @Override
    public Slot modify(Object object, int n, int n2) {
        Object object2 = this.makeKey(object, n);
        Slot slot = this.map.get(object2);
        if (slot != null) {
            return slot;
        }
        return this.createSlot(object, n, n2);
    }

    @Override
    public void replace(Slot slot, Slot slot2) {
        Object object = this.makeKey(slot);
        this.map.put(object, slot2);
    }

    private Slot createSlot(Object object, int n, int n2) {
        Slot slot = new Slot(object, n, n2);
        this.add(slot);
        return slot;
    }

    @Override
    public void add(Slot slot) {
        Object object = this.makeKey(slot);
        this.map.put(object, slot);
    }

    @Override
    public void remove(Object object, int n) {
        Object object2 = this.makeKey(object, n);
        Slot slot = this.map.get(object2);
        if (slot != null) {
            if ((slot.getAttributes() & 4) != 0) {
                Context context = Context.getContext();
                if (context.isStrictMode()) {
                    throw ScriptRuntime.typeErrorById("msg.delete.property.with.configurable.false", object);
                }
                return;
            }
            this.map.remove(object2);
        }
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.map.values().iterator();
    }

    private Object makeKey(Object object, int n) {
        return object == null ? String.valueOf(n) : object;
    }

    private Object makeKey(Slot slot) {
        return slot.name == null ? String.valueOf(slot.indexOrHash) : slot.name;
    }
}

