/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.WrapFactory;

public class InterfaceAdapter {
    private final Object proxyHelper;

    static Object create(Context context, Class<?> clazz, ScriptableObject scriptableObject) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        Scriptable scriptable = ScriptRuntime.getTopCallScope(context);
        ClassCache classCache = ClassCache.get(scriptable);
        InterfaceAdapter interfaceAdapter = (InterfaceAdapter)classCache.getInterfaceAdapter(clazz);
        ContextFactory contextFactory = context.getFactory();
        if (interfaceAdapter == null) {
            if (scriptableObject instanceof Callable) {
                boolean bl;
                Method[] methodArray = clazz.getMethods();
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = new HashSet<String>();
                for (Method method : methodArray) {
                    if (InterfaceAdapter.isFunctionalMethodCandidate(method)) {
                        hashSet.add(method.getName());
                        if (hashSet.size() <= 1) continue;
                        break;
                    }
                    hashSet2.add(method.getName());
                }
                boolean bl2 = bl = hashSet.size() == 1 || hashSet.isEmpty() && hashSet2.size() == 1;
                if (!bl) {
                    if (hashSet.isEmpty() && hashSet2.isEmpty()) {
                        throw Context.reportRuntimeErrorById("msg.no.empty.interface.conversion", clazz.getName());
                    }
                    throw Context.reportRuntimeErrorById("msg.no.function.interface.conversion", clazz.getName());
                }
            }
            interfaceAdapter = new InterfaceAdapter(contextFactory, clazz);
            classCache.cacheInterfaceAdapter(clazz, interfaceAdapter);
        }
        return VMBridge.instance.newInterfaceProxy(interfaceAdapter.proxyHelper, contextFactory, interfaceAdapter, scriptableObject, scriptable);
    }

    private static boolean isFunctionalMethodCandidate(Method method) {
        if (method.getName().equals("equals") || method.getName().equals("hashCode") || method.getName().equals("toString")) {
            return false;
        }
        return Modifier.isAbstract(method.getModifiers());
    }

    private InterfaceAdapter(ContextFactory contextFactory, Class<?> clazz) {
        this.proxyHelper = VMBridge.instance.getInterfaceProxyHelper(contextFactory, new Class[]{clazz});
    }

    public Object invoke(ContextFactory contextFactory, Object object, Scriptable scriptable, Object object2, Method method, Object[] objectArray) {
        return contextFactory.call(context -> this.invokeImpl(context, object, scriptable, object2, method, objectArray));
    }

    Object invokeImpl(Context context, Object object, Scriptable scriptable, Object object2, Method method, Object[] objectArray) {
        Class<?> clazz;
        Object object3;
        Object object4;
        Object object5;
        Callable callable;
        if (object instanceof Callable) {
            callable = (Callable)object;
        } else {
            object5 = (Scriptable)object;
            object4 = method.getName();
            object3 = ScriptableObject.getProperty((Scriptable)object5, (String)object4);
            if (object3 == Scriptable.NOT_FOUND) {
                Context.reportWarning(ScriptRuntime.getMessageById("msg.undefined.function.interface", object4));
                Class<?> clazz2 = method.getReturnType();
                if (clazz2 == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava(null, clazz2);
            }
            if (!(object3 instanceof Callable)) {
                throw Context.reportRuntimeErrorById("msg.not.function.interface", object4);
            }
            callable = (Callable)object3;
        }
        object5 = context.getWrapFactory();
        if (objectArray == null) {
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            int n = objectArray.length;
            for (int i = 0; i != n; ++i) {
                clazz = objectArray[i];
                if (clazz instanceof String || clazz instanceof Number || clazz instanceof Boolean) continue;
                objectArray[i] = ((WrapFactory)object5).wrap(context, scriptable, clazz, null);
            }
        }
        object4 = ((WrapFactory)object5).wrapAsJavaObject(context, scriptable, object2, null);
        object3 = callable.call(context, scriptable, (Scriptable)object4, objectArray);
        clazz = method.getReturnType();
        object3 = clazz == Void.TYPE ? null : Context.jsToJava(object3, clazz);
        return object3;
    }
}

