/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.NodeVisitor;

public class LabeledStatement
extends AstNode {
    private List<Label> labels = new ArrayList<Label>();
    private AstNode statement;

    public LabeledStatement() {
        this.type = 137;
    }

    public LabeledStatement(int n) {
        super(n);
        this.type = 137;
    }

    public LabeledStatement(int n, int n2) {
        super(n, n2);
        this.type = 137;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> list) {
        this.assertNotNull(list);
        if (this.labels != null) {
            this.labels.clear();
        }
        for (Label label : list) {
            this.addLabel(label);
        }
    }

    public void addLabel(Label label) {
        this.assertNotNull(label);
        this.labels.add(label);
        label.setParent(this);
    }

    public AstNode getStatement() {
        return this.statement;
    }

    public Label getLabelByName(String string) {
        for (Label label : this.labels) {
            if (!string.equals(label.getName())) continue;
            return label;
        }
        return null;
    }

    public void setStatement(AstNode astNode) {
        this.assertNotNull(astNode);
        this.statement = astNode;
        astNode.setParent(this);
    }

    public Label getFirstLabel() {
        return this.labels.get(0);
    }

    @Override
    public boolean hasSideEffects() {
        return true;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Label label : this.labels) {
            stringBuilder.append(label.toSource(n));
        }
        stringBuilder.append(this.statement.toSource(n + 1));
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (AstNode astNode : this.labels) {
                astNode.visit(nodeVisitor);
            }
            this.statement.visit(nodeVisitor);
        }
    }
}

