/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.ArrowFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ES6Generator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGenerator;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class OptRuntime
extends ScriptRuntime {
    public static final Double oneObj = 1.0;
    public static final Double minusOneObj = -1.0;

    public static Object call0(Callable callable, Scriptable scriptable, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, ScriptRuntime.emptyArgs);
    }

    public static Object call1(Callable callable, Scriptable scriptable, Object object, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, new Object[]{object});
    }

    public static Object call2(Callable callable, Scriptable scriptable, Object object, Object object2, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, new Object[]{object, object2});
    }

    public static Object callN(Callable callable, Scriptable scriptable, Object[] objectArray, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, objectArray);
    }

    public static Object callName(Object[] objectArray, String string, Context context, Scriptable scriptable) {
        Callable callable = OptRuntime.getNameFunctionAndThis(string, context, scriptable);
        Scriptable scriptable2 = OptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, objectArray);
    }

    public static Object callName0(String string, Context context, Scriptable scriptable) {
        Callable callable = OptRuntime.getNameFunctionAndThis(string, context, scriptable);
        Scriptable scriptable2 = OptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, ScriptRuntime.emptyArgs);
    }

    public static Object callProp0(Object object, String string, Context context, Scriptable scriptable) {
        Callable callable = OptRuntime.getPropFunctionAndThis(object, string, context, scriptable);
        Scriptable scriptable2 = OptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, ScriptRuntime.emptyArgs);
    }

    public static Object add(Object object, double d, Context context) {
        if (object instanceof Double) {
            return (Double)object + d;
        }
        if (object instanceof Integer) {
            return (double)((Integer)object).intValue() + d;
        }
        return ScriptRuntime.add(object, d, context);
    }

    public static Object add(double d, Object object, Context context) {
        if (object instanceof Double) {
            return d + (Double)object;
        }
        if (object instanceof Integer) {
            return d + (double)((Integer)object).intValue();
        }
        return ScriptRuntime.add(d, object, context);
    }

    @Deprecated
    public static Object elemIncrDecr(Object object, double d, Context context, int n) {
        return OptRuntime.elemIncrDecr(object, d, context, OptRuntime.getTopCallScope(context), n);
    }

    public static Object elemIncrDecr(Object object, double d, Context context, Scriptable scriptable, int n) {
        return ScriptRuntime.elemIncrDecr(object, d, context, scriptable, n);
    }

    public static Object[] padStart(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length + n];
        System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
        return objectArray2;
    }

    public static void initFunction(NativeFunction nativeFunction, int n, Scriptable scriptable, Context context) {
        ScriptRuntime.initFunction(context, scriptable, nativeFunction, n, false);
    }

    public static Function bindThis(NativeFunction nativeFunction, Context context, Scriptable scriptable, Scriptable scriptable2) {
        return new ArrowFunction(context, scriptable, nativeFunction, scriptable2);
    }

    public static Object callSpecial(Context context, Callable callable, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, Scriptable scriptable3, int n, String string, int n2) {
        return ScriptRuntime.callSpecial(context, callable, scriptable, objectArray, scriptable2, scriptable3, n, string, n2);
    }

    public static Object newObjectSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, int n) {
        return ScriptRuntime.newSpecial(context, object, objectArray, scriptable, n);
    }

    public static Double wrapDouble(double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                return zeroObj;
            }
        } else {
            if (d == 1.0) {
                return oneObj;
            }
            if (d == -1.0) {
                return minusOneObj;
            }
            if (Double.isNaN(d)) {
                return NaNobj;
            }
        }
        return d;
    }

    static String encodeIntArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        char[] cArray = new char[1 + n * 2];
        cArray[0] = '\u0001';
        for (int i = 0; i != n; ++i) {
            int n2 = nArray[i];
            int n3 = 1 + i * 2;
            cArray[n3] = (char)(n2 >>> 16);
            cArray[n3 + 1] = (char)n2;
        }
        return new String(cArray);
    }

    private static int[] decodeIntArray(String string, int n) {
        if (n == 0) {
            if (string != null) {
                throw new IllegalArgumentException();
            }
            return null;
        }
        if (string.length() != 1 + n * 2 && string.charAt(0) != '\u0001') {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[n];
        for (int i = 0; i != n; ++i) {
            int n2 = 1 + i * 2;
            nArray[i] = string.charAt(n2) << 16 | string.charAt(n2 + 1);
        }
        return nArray;
    }

    public static Scriptable newArrayLiteral(Object[] objectArray, String string, int n, Context context, Scriptable scriptable) {
        int[] nArray = OptRuntime.decodeIntArray(string, n);
        return OptRuntime.newArrayLiteral(objectArray, nArray, context, scriptable);
    }

    public static void main(Script script, String[] stringArray) {
        ContextFactory.getGlobal().call(context -> {
            ScriptableObject scriptableObject = OptRuntime.getGlobal(context);
            Object[] objectArray = new Object[stringArray.length];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            Scriptable scriptable = context.newArray((Scriptable)scriptableObject, objectArray);
            scriptableObject.defineProperty("arguments", (Object)scriptable, 2);
            script.exec(context, scriptableObject);
            return null;
        });
    }

    public static void throwStopIteration(Object object, Object object2) {
        Object object3 = OptRuntime.getGeneratorReturnValue(object2);
        Object object4 = object3 == Undefined.instance ? NativeIterator.getStopIterationObject((Scriptable)object) : new NativeIterator.StopIteration(object3);
        throw new JavaScriptException(object4, "", 0);
    }

    public static Scriptable createNativeGenerator(NativeFunction nativeFunction, Scriptable scriptable, Scriptable scriptable2, int n, int n2) {
        GeneratorState generatorState = new GeneratorState(scriptable2, n, n2);
        if (Context.getCurrentContext().getLanguageVersion() >= 200) {
            return new ES6Generator(scriptable, nativeFunction, generatorState);
        }
        return new NativeGenerator(scriptable, nativeFunction, generatorState);
    }

    public static Object[] getGeneratorStackState(Object object) {
        GeneratorState generatorState = (GeneratorState)object;
        if (generatorState.stackState == null) {
            generatorState.stackState = new Object[generatorState.maxStack];
        }
        return generatorState.stackState;
    }

    public static Object[] getGeneratorLocalsState(Object object) {
        GeneratorState generatorState = (GeneratorState)object;
        if (generatorState.localsState == null) {
            generatorState.localsState = new Object[generatorState.maxLocals];
        }
        return generatorState.localsState;
    }

    public static void setGeneratorReturnValue(Object object, Object object2) {
        GeneratorState generatorState = (GeneratorState)object;
        generatorState.returnValue = object2;
    }

    public static Object getGeneratorReturnValue(Object object) {
        GeneratorState generatorState = (GeneratorState)object;
        return generatorState.returnValue == null ? Undefined.instance : generatorState.returnValue;
    }

    public static class GeneratorState {
        static final String CLASS_NAME = "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState";
        public int resumptionPoint;
        static final String resumptionPoint_NAME = "resumptionPoint";
        static final String resumptionPoint_TYPE = "I";
        public Scriptable thisObj;
        static final String thisObj_NAME = "thisObj";
        static final String thisObj_TYPE = "Lorg/mozilla/javascript/Scriptable;";
        Object[] stackState;
        Object[] localsState;
        int maxLocals;
        int maxStack;
        Object returnValue;

        GeneratorState(Scriptable scriptable, int n, int n2) {
            this.thisObj = scriptable;
            this.maxLocals = n;
            this.maxStack = n2;
        }
    }
}

