/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.apps.rasterizer;

import io.sf.carte.echosvg.transcoder.Transcoder;
import io.sf.carte.echosvg.transcoder.image.JPEGTranscoder;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import io.sf.carte.echosvg.transcoder.image.TIFFTranscoder;

public final class DestinationType {
    public static final String PNG_STR = "image/png";
    public static final String JPEG_STR = "image/jpeg";
    public static final String TIFF_STR = "image/tiff";
    public static final int PNG_CODE = 0;
    public static final int JPEG_CODE = 1;
    public static final int TIFF_CODE = 2;
    public static final String PNG_EXTENSION = ".png";
    public static final String JPEG_EXTENSION = ".jpg";
    public static final String TIFF_EXTENSION = ".tif";
    public static final DestinationType PNG = new DestinationType("image/png", 0, ".png");
    public static final DestinationType JPEG = new DestinationType("image/jpeg", 1, ".jpg");
    public static final DestinationType TIFF = new DestinationType("image/tiff", 2, ".tif");
    private String type;
    private int code;
    private String extension;

    private DestinationType(String string, int n, String string2) {
        this.type = string;
        this.code = n;
        this.extension = string2;
    }

    public String getExtension() {
        return this.extension;
    }

    public String toString() {
        return this.type;
    }

    public int toInt() {
        return this.code;
    }

    protected Transcoder getTranscoder() {
        switch (this.code) {
            case 0: {
                return new PNGTranscoder();
            }
            case 1: {
                return new JPEGTranscoder();
            }
            case 2: {
                return new TIFFTranscoder();
            }
        }
        return null;
    }

    public DestinationType[] getValues() {
        return new DestinationType[]{PNG, JPEG, TIFF};
    }

    public Object readResolve() {
        switch (this.code) {
            case 0: {
                return PNG;
            }
            case 1: {
                return JPEG;
            }
            case 2: {
                return TIFF;
            }
        }
        throw new RuntimeException("unknown code:" + this.code);
    }
}

