/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.importer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import org.gephi.desktop.importer.WizardIterator;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.io.importer.spi.Importer;
import org.gephi.io.importer.spi.ImporterWizardUI;
import org.gephi.io.importer.spi.WizardImporter;
import org.gephi.io.importer.spi.WizardImporterBuilder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ImportWizard
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean cancelled;
        WizardIterator wizardIterator = new WizardIterator();
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)wizardIterator);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
        wizardDescriptor.setTitle(NbBundle.getMessage(this.getClass(), (String)"ImportWizard.wizard.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            ImporterWizardUI wizardUI = wizardIterator.getCurrentWizardUI();
            WizardImporter importer = null;
            for (WizardImporterBuilder wizardBuilder : Lookup.getDefault().lookupAll(WizardImporterBuilder.class)) {
                WizardImporter im = wizardBuilder.buildImporter();
                if (!wizardUI.isUIForImporter((Importer)im)) continue;
                importer = im;
            }
            if (importer == null) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"ImportWizard.error_no_matching_importer"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            wizardIterator.unsetupPanels(importer);
            ImportControllerUI importControllerUI = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
            importControllerUI.importWizard(importer);
        }
    }
}

