
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was GinkgoConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/Ginkgo" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(GINKGO_PROJECT_NAME "Ginkgo")
set(GINKGO_PROJECT_VERSION 1.7.0)
set(GINKGO_PROJECT_DESCRIPTION "A numerical linear algebra library targeting many-core architectures")

# Extra version information
set(GINKGO_VERSION_MAJOR 1)
set(GINKGO_VERSION_MINOR 7)
set(GINKGO_VERSION_PATCH 0)

# Git information
set(GINKGO_GIT_BRANCH "")
set(GINKGO_GIT_REVISION "")
set(GINKGO_GIT_SHORTREV "")

# CMake build configuration
set(GINKGO_BUILD_TYPE "None")
set(GINKGO_BUILD_SHARED_LIBS "ON")
set(GINKGO_DEBUG_POSTFIX "d")

# Compiler configuration
set(GINKGO_CXX_COMPILER "/usr/bin/c++")
set(GINKGO_CXX_COMPILER_VERSION 13.2.1)

set(GINKGO_CXX_FLAGS "-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=2 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection -Wp,-D_GLIBCXX_ASSERTIONS -g -ffile-prefix-map=/build/ginkgo-hpc/src=/usr/src/debug/ginkgo-hpc -flto=auto")
set(GINKGO_CXX_FLAGS_DEBUG "-g")
set(GINKGO_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")

set(GINKGO_EXE_LINKER_FLAGS "-Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs -flto=auto")
set(GINKGO_EXE_LINKER_FLAGS_DEBUG "")
set(GINKGO_EXE_LINKER_FLAGS_RELEASE "")

# Ginkgo configuration
set(GINKGO_BUILD_REFERENCE ON)
set(GINKGO_BUILD_OMP ON)
set(GINKGO_BUILD_CUDA ON)
set(GINKGO_BUILD_HIP OFF)
set(GINKGO_BUILD_MPI ON)
set(GINKGO_BUILD_SYCL OFF)

set(GINKGO_DEVEL_TOOLS OFF)
set(GINKGO_BUILD_TESTS ON)
set(GINKGO_BUILD_EXAMPLES ON)
set(GINKGO_BUILD_EXTLIB_EXAMPLE OFF)
set(GINKGO_BUILD_BENCHMARKS ON)

set(GINKGO_BUILD_DOC ON)
set(GINKGO_DOC_GENERATE_EXAMPLES ON)
set(GINKGO_DOC_GENERATE_PDF OFF)
set(GINKGO_DOC_GENERATE_DEV OFF)

set(GINKGO_SKIP_DEPENDENCY_UPDATE ON)
set(GINKGO_EXPORT_BUILD_DIR OFF)
set(GINKGO_VERBOSE_LEVEL 1)

set(GINKGO_WITH_CLANG_TIDY OFF)
set(GINKGO_WITH_IWYU OFF)
set(GINKGO_CLANG_TIDY_PATH )
set(GINKGO_IWYU_PATH )

set(GINKGO_JACOBI_FULL_OPTIMIZATIONS OFF)

set(GINKGO_CUDA_ARCHITECTURES "50;52;53;60;61;62;70;72;75;80;86;87;89;90")
set(GINKGO_CUDA_HOST_COMPILER "")

set(GINKGO_HIP_COMPILER_FLAGS "")
set(GINKGO_HIP_HCC_COMPILER_FLAGS "")
set(GINKGO_HIP_NVCC_COMPILER_FLAGS "")
set(GINKGO_HIP_CLANG_COMPILER_FLAGS "")
set(GINKGO_HIP_PLATFORM )
set(GINKGO_HIP_PLATFORM_AMD_REGEX "")
set(GINKGO_HIP_PLATFORM_NVIDIA_REGEX "")
set(GINKGO_HIP_AMDGPU "")
set(GINKGO_HIP_VERSION )
set(GINKGO_AMD_ARCH_FLAGS "")

set(GINKGO_DPCPP_VERSION )
set(GINKGO_DPCPP_MAJOR_VERSION 0)
set(GINKGO_DPCPP_FLAGS "")
set(GINKGO_MKL_ROOT "")
set(GINKGO_DPL_ROOT "")

set(GINKGO_BUILD_MPI ON)

set(GINKGO_HAVE_PAPI_SDE 0)

set(GINKGO_HAVE_HWLOC 1)

set(GINKGO_HAVE_ROCTX 0)

# Ginkgo compiler information
set(GINKGO_CXX_COMPILER "/usr/bin/c++")
set(GINKGO_CXX_COMPILER_SHORT "GNU:13.2.1")
set(GINKGO_CUDA_COMPILER "/opt/cuda/bin/nvcc")
set(GINKGO_CUDA_COMPILER_SHORT "NVIDIA:12.4.131")
set(GINKGO_CUDA_HOST_COMPILER "")
set(GINKGO_CUDA_HOST_COMPILER_SHORT "")  # dummy value to stay consistent

# Ginkgo installation configuration
set(GINKGO_INSTALL_PREFIX "${PACKAGE_PREFIX_DIR}")
set(GINKGO_INSTALL_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set(GINKGO_INSTALL_LIBRARY_DIR "${PACKAGE_PREFIX_DIR}/lib")
set(GINKGO_INSTALL_RPATH_FOR_HIP "-Wl,-rpath,${GINKGO_INSTALL_LIBRARY_DIR}")
set(GINKGO_INSTALL_RPATH ON)
set(GINKGO_INSTALL_RPATH_USE_ORIGIN )
set(GINKGO_INSTALL_RPATH_DEPENDENCIES OFF)

# Forward Ginkgo's MODULE PATH and the PREFIX PATH for HIP and more
list(APPEND CMAKE_MODULE_PATH "${PACKAGE_PREFIX_DIR}/lib/cmake/Ginkgo/Modules")
if(GINKGO_BUILD_HIP)
    list(APPEND CMAKE_MODULE_PATH "")
endif()
list(APPEND CMAKE_PREFIX_PATH "${GINKGO_INSTALL_PREFIX}")

set(GINKGO_INTERFACE_LINK_LIBRARIES "ginkgo_device;ginkgo_omp;ginkgo_cuda;ginkgo_reference;ginkgo_hip;ginkgo_dpcpp;MPI::MPI_CXX")
set(GINKGO_INTERFACE_LINK_FLAGS "-L/usr/lib -lginkgo$<$<CONFIG:Debug>:d> -lginkgo_omp$<$<CONFIG:Debug>:d> -lginkgo_cuda$<$<CONFIG:Debug>:d> -ldl -lginkgo_reference$<$<CONFIG:Debug>:d> -lginkgo_hip$<$<CONFIG:Debug>:d> -lginkgo_dpcpp$<$<CONFIG:Debug>:d> -lginkgo_device$<$<CONFIG:Debug>:d> /usr/lib/libhwloc.so /usr/lib/libmpi.so")
set(GINKGO_INTERFACE_CXX_FLAGS "-I/usr/include")

# CUDA
set(GINKGO_CUDA_COMPILER "/opt/cuda/bin/nvcc")
set(GINKGO_CUDA_COMPILER_VERSION 12.4.131)
set(GINKGO_CUDA_HOST_LINK_LAUNCHER "/opt/cuda/bin/g++")

set(GINKGO_CUDA_FLAGS "")
set(GINKGO_CUDA_FLAGS_DEBUG "-g")
set(GINKGO_CUDA_FLAGS_RELEASE "-O3 -DNDEBUG")

# OpenMP
set(GINKGO_OPENMP_VERSION 4.5)

set(GINKGO_OPENMP_LIB_NAMES "gomp;pthread")
set(GINKGO_OPENMP_LIBRARIES "/usr/lib/libgomp.so;/usr/lib/libpthread.a")

set(GINKGO_OPENMP_FLAGS "-fopenmp")

set(GINKGO_HAVE_TAU "0")
set(GINKGO_HAVE_VTUNE "0")
set(GINKGO_HAVE_METIS "0")
set(VTune_PATH "/..")

# ensure Threads settings 
set(THREADS_PREFER_PTHREAD_FLAG ON)

# NOTE: we do not export benchmarks, examples, tests or devel tools
#     so `third_party` libraries are currently unneeded.

if(GINKGO_HAVE_PAPI_SDE)
    find_package(PAPI REQUIRED COMPONENTS sde)
endif()

if(GINKGO_HAVE_HWLOC)
    find_package(HWLOC REQUIRED)
endif()

# Check for MPI if it is enabled
if(GINKGO_BUILD_MPI)
    find_package(MPI 3.1 COMPONENTS CXX REQUIRED)
endif()

# HIP and OpenMP depend on Threads::Threads in some circumstances, but don't find it
if (GINKGO_BUILD_HIP OR GINKGO_BUILD_OMP)
    find_package(Threads REQUIRED)
endif()

# Needed because of a known issue with CUDA while linking statically.
# For details, see https://gitlab.kitware.com/cmake/cmake/issues/18614
if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_BUILD_CUDA)
    enable_language(CUDA)
    find_package(CUDAToolkit REQUIRED)
    find_package(NVTX REQUIRED)
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_BUILD_HIP)
    find_package(HIP REQUIRED)
    find_package(hipblas REQUIRED)
    find_package(hipfft) # optional
    find_package(hiprand REQUIRED)
    find_package(hipsparse REQUIRED)
    find_package(rocrand REQUIRED)
    set(ROCTRACER_PATH "")
    if(GINKGO_HAVE_ROCTX)
        find_package(ROCTX REQUIRED)
    endif()
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_BUILD_SYCL)
    find_package(MKL CONFIG REQUIRED HINTS "${GINKGO_MKL_ROOT}")
    find_package(oneDPL REQUIRED HINTS "${GINKGO_DPL_ROOT}")
endif()

if(GINKGO_HAVE_VTUNE)
    find_package(VTune REQUIRED)
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_HAVE_METIS)
    find_package(METIS REQUIRED)
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_HAVE_TAU)
    find_package(PerfStubs REQUIRED)
endif()

# Check that the same compilers as for Ginkgo are used
function(_ginkgo_check_compiler lang)
    if(NOT ${CMAKE_${lang}_COMPILER} STREQUAL ${GINKGO_${lang}_COMPILER})
        set(_compiler_short "${CMAKE_${lang}_COMPILER_ID}:${CMAKE_${lang}_COMPILER_VERSION}")
        if(NOT _compiler_short STREQUAL "${GINKGO_${lang}_COMPILER_SHORT}")
            message(WARNING "The currently used ${lang} compiler: ${CMAKE_${lang}_COMPILER} does not match the compiler used to "
                            "build Ginkgo: ${GINKGO_${lang}_COMPILER}. It is encouraged to use the same compiler as Ginkgo to prevent ABI mismatch.")
        endif()
    endif()
endfunction()
_ginkgo_check_compiler(CXX)
if(GINKGO_BUILD_CUDA)
    _ginkgo_check_compiler(CUDA)
    _ginkgo_check_compiler(CUDA_HOST)
endif()

include(${CMAKE_CURRENT_LIST_DIR}/GinkgoTargets.cmake)
