/*******************************<GINKGO LICENSE>******************************
Copyright (c) 2017-2023, the Ginkgo authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************<GINKGO LICENSE>*******************************/

#ifndef GKO_INCLUDE_CONFIG_H
#define GKO_INCLUDE_CONFIG_H

// clang-format off
#define GKO_VERSION_MAJOR 1
#define GKO_VERSION_MINOR 7
#define GKO_VERSION_PATCH 0
#define GKO_VERSION_TAG "master"
#define GKO_VERSION_STR 1, 7, 0
// clang-format on

/*
 * Controls the amount of messages output by Ginkgo.
 * 0 disables all output (except for test, benchmarks and examples).
 * 1 activates important messages.
 */
// clang-format off
#define GKO_VERBOSE_LEVEL 1
// clang-format on


/* Is Itanium ABI available? */
#define GKO_HAVE_CXXABI_H


/* Should we use all optimizations for Jacobi? */
/* #undef GINKGO_JACOBI_FULL_OPTIMIZATIONS */


/* Should we compile Ginkgo specifically to tune values? */
/* #undef GINKGO_BENCHMARK_ENABLE_TUNING */


/* Should we compile mixed-precision kernels for Ginkgo? */
/* #undef GINKGO_MIXED_PRECISION */


/* What is HIP compiled for, hcc or nvcc? */
// clang-format off
#define GINKGO_HIP_PLATFORM_HCC 1


#define GINKGO_HIP_PLATFORM_NVCC 0
// clang-format on


/* What is the major version of dpcpp compiler */
// clang-format off
#define GINKGO_DPCPP_MAJOR_VERSION 0
// clang-format on


/* Is PAPI SDE available for Logging? */
// clang-format off
#define GKO_HAVE_PAPI_SDE 0
// clang-format on


/* Is TAU available for Profiling? */
// clang-format off
#define GKO_HAVE_TAU 0
// clang-format on


/* Is VTune ITT available for Profiling? */
// clang-format off
#define GKO_HAVE_VTUNE 0
// clang-format on


/* Is METIS available for Reordering? */
// clang-format off
#define GKO_HAVE_METIS 0
// clang-format on

#if GKO_HAVE_METIS
// clang-format off
#define GKO_METIS_HEADER <>
// clang-format on
#endif

/* Is ROCTX available for Profiling? */
// clang-format off
#define GKO_HAVE_ROCTX 1
// clang-format on


/* Is MPI available ? */
// clang-format off
#define GINKGO_BUILD_MPI 1
// clang-format on

/* Is the MPI implementation GPU aware? */
// clang-format off
#define GINKGO_HAVE_GPU_AWARE_MPI 0
// clang-format on


/* Is HWLOC available ? */
// clang-format off
#define GKO_HAVE_HWLOC 1
// clang-format on


/* Do we need to use blocking communication in our SpMV? */
// clang-format off
/* #undef GINKGO_FORCE_SPMV_BLOCKING_COMM */
// clang-format on


#endif  // GKO_INCLUDE_CONFIG_H
