#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 glirc
version:              2.39.0.1
visibility:           public
id:                   glirc-2.39.0.1-H7nnXNqLRfwFtvJyROlXGL
key:                  glirc-2.39.0.1-H7nnXNqLRfwFtvJyROlXGL
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  81edf572801b9bc7492a9edbcfe72063
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Window
    Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.Digraphs Client.View.Help
    Client.View.IgnoreList Client.View.KeyMap Client.View.MaskList
    Client.View.Mentions Client.View.Messages Client.View.Palette
    Client.View.RtsStats Client.View.UrlSelection Client.View.UserList
    Client.View.Windows

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.2.8/site-local/glirc-2.39.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/glirc-2.39.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.39.0.1-H7nnXNqLRfwFtvJyROlXGL
include-dirs:         /usr/lib/ghc-9.2.8/site-local/glirc-2.39.0.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.6-I5yfytMWDY8F8ou4oqS4M1
    async-2.2.5-L1pFc6v09ikFDHHjgXlurp
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK base-4.16.4.0
    base64-bytestring-1.2.1.0-6ICZKEZtNauKUlSfxjYXGw
    bytestring-0.11.4.0 config-schema-1.3.0.0-FHwIjXVl35F6LHscWffe4D
    config-value-0.8.3-8yCRuGm4wH18pEPQuVa8HA containers-0.6.5.1
    curve25519-0.2.8-G2P46wVsRmV2PDxh0K0xZv directory-1.3.6.2
    filepath-1.4.2.2 free-5.1.10-AN4bUDGIWGDJVoND3kN9wg
    githash-0.1.6.3-Hf61yXqxDs52GfOSixgdc8
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    hookup-0.8-WHRuZnxn9iDbqiAnftD5S
    irc-core-2.11-F2Wh4ae3f70O1fExgeZwU
    kan-extensions-5.2.6-CTEoKTH53iuABPcVTylQtk
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0 process-1.6.16.0
    psqueues-0.2.8.0-2OQKJAbUNrl4fTXmy1BF48
    random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH
    regex-tdfa-1.3.2.2-Js34ukrBSX51v3nGkmx3s
    split-0.2.5-FikGR5xLeivE3fJUC4tXgQ stm-2.5.0.2
    template-haskell-2.18.0.0 text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe
    vty-5.38-EHOJTJgLNwc8Lq4FAnLwnm

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

