/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByAttributesException;
import org.gradle.internal.component.resolution.failure.formatting.CapabilitiesDescriber;
import org.gradle.internal.component.resolution.failure.type.AmbiguousVariantsFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AmbiguousVariantsFailureDescriber
extends AbstractResolutionFailureDescriber<AmbiguousVariantsFailure> {
    private static final String AMBIGUOUS_VARIANTS_PREFIX = "Ambiguity errors are explained in more detail at ";
    private static final String AMBIGUOUS_VARIANTS_SECTION = "sub:variant-ambiguity";

    public VariantSelectionByAttributesException describeFailure(AmbiguousVariantsFailure failure, Optional<AttributesSchemaInternal> schema) {
        String message = this.buildFailureMsg(failure, schema.orElseThrow(IllegalArgumentException::new));
        List<String> resolutions = this.buildResolutions(this.suggestSpecificDocumentation(AMBIGUOUS_VARIANTS_PREFIX, AMBIGUOUS_VARIANTS_SECTION), this.suggestReviewAlgorithm());
        return new VariantSelectionByAttributesException(message, failure, resolutions);
    }

    protected String buildFailureMsg(AmbiguousVariantsFailure failure, AttributesSchemaInternal schema) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), schema);
        TreeFormatter formatter = new TreeFormatter();
        Map<String, ResolutionCandidateAssessor.AssessedCandidate> ambiguousVariants = this.summarizeAmbiguousVariants(failure, describer, formatter, true);
        formatter.startChildren();
        for (ResolutionCandidateAssessor.AssessedCandidate assessedCandidate : ambiguousVariants.values()) {
            this.formatUnselectable(assessedCandidate, formatter, describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    protected Map<String, ResolutionCandidateAssessor.AssessedCandidate> summarizeAmbiguousVariants(AmbiguousVariantsFailure failure, AttributeDescriber describer, TreeFormatter formatter, boolean listAvailableVariants) {
        TreeMap<String, ResolutionCandidateAssessor.AssessedCandidate> ambiguousVariants = new TreeMap<String, ResolutionCandidateAssessor.AssessedCandidate>();
        for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
            ambiguousVariants.put(candidate.getDisplayName(), candidate);
        }
        if (failure.getRequestedAttributes().isEmpty()) {
            formatter.node("Cannot choose between the available variants of ");
        } else {
            String node = "The consumer was configured to find " + describer.describeAttributeSet(failure.getRequestedAttributes().asMap());
            node = listAvailableVariants ? node + ". However we cannot choose between the following variants of " : node + ". There are several available matching variants of ";
            formatter.node(node);
        }
        formatter.append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.describeRequestTarget()));
        if (listAvailableVariants) {
            formatter.startChildren();
            for (String configuration : ambiguousVariants.keySet()) {
                formatter.node(configuration);
            }
            formatter.endChildren();
            formatter.node("All of them match the consumer attributes");
        }
        return ambiguousVariants;
    }

    private void formatUnselectable(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, AttributeDescriber describer) {
        formatter.node("Variant '");
        formatter.append((CharSequence)assessedCandidate.getDisplayName());
        formatter.append((CharSequence)"'");
        formatter.append((CharSequence)(" " + CapabilitiesDescriber.describeCapabilitiesWithTitle(assessedCandidate.getCandidateCapabilities().asSet())));
        this.formatAttributeMatchesForAmbiguity(assessedCandidate, formatter, describer);
    }
}

